import 'adminConsole/js/filters/clients.filters.js';
import 'vsa/js/controllers/collections.ctrl.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'jobs/js/services/jobs.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/services/restore.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'modules/ida/js/directives/cvDataMasking.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'sql/js/services/sqlRecoveryPoints.svc.js';
import 'sql/js/factory/sqlServer.fac.js';

import { acAppInstanceModule } from 'common/js/modules';
var app = acAppInstanceModule;

app.controller('databaseCloneCtrl', [
	'$log',
	'agentService',
	'cvLoc',
	'cvToaster',
	'cvBreadcrumbsTabsFactory',
	'$scope',
	'$stateParams',
	'$state',
	'restoreForAgents',
	'$timeout',
	'cvTableOptions',
	'idaService',
	'cvUtil',
	'jobService',
	'$filter',
	'sqlService',
	'AppTypes',
	'sqlRecoveryPointsService',
	'sqlServerFactory',
	function(
		$log,
		agentService,
		cvLoc,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		$scope,
		$stateParams,
		$state,
		restoreForAgents,
		$timeout,
		cvTableOptions,
		idaService,
		cvUtil,
		jobService,
		$filter,
		sqlService,
		AppTypes,
		sqlRecoveryPointsService,
		sqlServerFactory
	) {
		var self = this;
		var PIT = '1';
		var LATEST_SCN_NUMBER = 4;

		self.data = {
			destClient: null,
			instanceNameText: null,
			commondFilePath: null,
			databases: null,
			jobsPage: null,
			selectedJob: null,
			orclInstance: {},
			dataMaskingOptions: {},
			cloneEnv: {
				cloneType: 'INSTANCESNAP',
				instanceId: undefined,
				oraHome: undefined,
				oraUser: undefined,
				oraPfile: undefined,
				forceCleanup: false,
				resrvTimePeriod: 0,
				rsvTPDays: 7,
				rsvTPHours: 0,
				stagingPath: undefined,
				copyPrec: 0,
				pitType: 0,
				fromTime: null,
				toTime: null
			}
		};

		self.title = cvLoc('label.dbClone');
		self.instanceId = $stateParams.instanceId;
		self.applicationId = $stateParams.applicationId;
		self.sourceLocation = $stateParams.sourceLocation;
		self.isSqlClone = false;
		self.instanceNameSize = 8;
		if (self.applicationId == 81) {
			self.isSqlClone = true;
			self.instanceNameSize = -1;
		} else if (self.applicationId == AppTypes.ORACLE || self.applicationId == AppTypes.ORACLE_RAC) {
			self.isOracleClone = true;
		}
		self.errors = {};
		self.step = 0;
		$scope.database = {};
		self.showStagingPath = false;

		var generalPageValidate = function() {
			//Summary page text for Recover to
			self.pitSelection = cvLoc('label.mostRecent');

			contentSelectPage.skipStep = !self.isSqlClone && self.data.cloneEnv.pitType !== PIT;

			//self.data.cloneEnv.fromTime & self.data.cloneEnv.toTime are browse time used for display;
			if (self.isSqlClone && self.data.cloneEnv.pitType === PIT) {
				if (new Date(self.data.cloneEnv.fromTime) == 'Invalid Date') return cvLoc('error.fromTime');
				if (!self.data.cloneEnv.fromTime) {
					var tempdate = new Date();
					self.data.cloneEnv.fromTime = new Date(
						tempdate.getFullYear(),
						tempdate.getMonth(),
						tempdate.getDate(),
						tempdate.getHours(),
						tempdate.getMinutes(),
						tempdate.getSeconds()
					);
					var result = {};
					result.toDateString = cvUtil.getUTCDate(tempdate);
					self.data.cloneEnv.fromTimeUTC = result;
				}

				if (new Date(self.data.cloneEnv.toTime) == 'Invalid Date') return cvLoc('error.toTime');
				if (!self.data.cloneEnv.toTime) {
					var tempdate = new Date();
					self.data.cloneEnv.toTime = new Date(
						tempdate.getFullYear(),
						tempdate.getMonth(),
						tempdate.getDate(),
						tempdate.getHours(),
						tempdate.getMinutes(),
						tempdate.getSeconds()
					);
					var result = {};
					result.toDateString = cvUtil.getUTCDate(tempdate);
					self.data.cloneEnv.toTimeUTC = result;
				}

				var fromTimeDate = new Date(self.data.cloneEnv.fromTime);
				var toTimeDate = new Date(self.data.cloneEnv.toTime);
				if (fromTimeDate > toTimeDate) {
					return 'From time must be earlier than To time';
				}
				var tempdate = new Date(self.data.cloneEnv.toTime);
				self.pitSelection = $filter('date')(tempdate, 'medium');
			} else if (self.isOracleClone && self.data.cloneEnv.pitType === PIT) {
				if (!self.data.cloneEnv.toTime || new Date(self.data.cloneEnv.toTime) == 'Invalid Date') {
					return cvLoc('error.toTime');
				}
				var tempdate = new Date(self.data.cloneEnv.toTime);
				self.pitSelection = $filter('date')(tempdate, 'medium');
			}
			//self.loadData();
		};
		var validateContentPage = function() {
			if (self.showJobsTable) {
				self.pitSelection = 'PIT ( Job Id # ' + $scope.selectedJob + ' )';
			}
			if (!self.isSqlClone) {
				return null;
			} else {
				self.sourceItems = []; //each self.sourceItems is a sqlDatabaseInfo obj
				self.data.databases.forEach(function(db) {
					if (db.isSelected) {
						self.sourceItems.push(db);
					}
				});

				if (self.sourceItems.length < 1) {
					return cvLoc('error.database');
				}
			}
		};

		/**
		 * Validation method for the clone options page.
		 * Clone reservation days or hrs should be non zero value
		 */
		self.validateValue = function() {
			var rsvTime = self.data.cloneEnv.rsvTPDays + self.data.cloneEnv.rsvTPHours;
			if (!rsvTime || rsvTime < 1) {
				self.errors.rsvTPDays = true;
				return false;
			}
			self.errors.rsvTPDays = false;
			return true;
		};

		var validateCloneOptoins = function() {
			var isValid = self.validateValue();
			if (!isValid) return ' ';
			self.forceCleanup = 'No';
			if (self.data.cloneEnv.forceCleanup) {
				self.forceCleanup = 'Yes';
			}
		};

		var generalInfoPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/databaseClone/partials/databaseCloneGeneralPage.jsp',
			name: cvLoc('label.generalInfo'),
			skipStep: false,
			validateMethod: generalPageValidate
		};

		var contentSelectPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/databaseClone/partials/databaseCloneContentPage.jsp',
			name: cvLoc('label.contentSelt'),
			validateMethod: validateContentPage
		};

		var cloneOptionsPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/databaseClone/partials/databaseCloneDestinationDetailsPage.jsp',
			name: cvLoc('label.destDetails')
		};

		var postCloneOptPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/databaseClone/partials/databaseCloneOptionsPage.jsp',
			name: cvLoc('label.cloneOptions'),
			validateMethod: validateCloneOptoins
		};

		var summaryPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/databaseClone/partials/databaseCloneSummaryPage.jsp',
			name: cvLoc('label.summary')
		};

		var steps = [];
		steps.push(generalInfoPage);
		//Oracle doesn't need content select page
		if (!self.isOracleClone) {
			steps.push(contentSelectPage);
		}
		steps.push(cloneOptionsPage);
		steps.push(postCloneOptPage);
		steps.push(summaryPage);

		self.steps = steps;

		self.dummyInstance;
		self.destClientName;
		self.sqlClientInstanceMap = new Map();
		self.updateOptions = function(instanceSelected) {
			if (instanceSelected && instanceSelected.isDummyInstance) {
				instanceSelected.instanceName = self.data.instanceNameText;
				instanceSelected.oracleHome = self.data.cloneEnv.oraHome;
				instanceSelected.oracleUser = self.data.cloneEnv.oraUser;
			} else if (instanceSelected) {
				self.data.instanceNameText = instanceSelected.instanceName;
				self.data.instanceId = instanceSelected.instanceId;
				self.data.cloneEnv.oraHome = instanceSelected.oracleHome;
				self.data.cloneEnv.oraUser = instanceSelected.oracleUser;
			}
			self.data.instance = instanceSelected;
		};

		//timeValue is already in UTC
		var fromatDateForServer = function(timeValue) {
			var dateString = timeValue.toDateString;
			return $filter('date')(dateString, 'yyyy-MM-ddTHH:mm:ss');
		};
		//Get the snap jobs for the selected time interval
		var getSnapJobs = function() {
			var sortOptions = {
				fields: ['jobId'],
				directions: [1]
			};

			var jobType = 'SNAPBACKUP';
			var filterOptions = {
				clientId: self.entity.clientId,
				subClientId: self.entity.subClientId,
				jobType: jobType,
				status: 'Completed',
				showAgedJobs: false,
				update: true,
				pagingInfo: {
					pageSize: 100000,
					currentPage: 1
				},
				sortOptions: sortOptions,
				applicationId: self.entity.applicationId,
				instanceId: self.entity.instanceId,
				backupsetId: self.entity.backupsetId,
				activeJobs: '0',
				jobStartTime: {
					from: fromatDateForServer(self.data.cloneEnv.fromTimeUTC),
					to: fromatDateForServer(self.data.cloneEnv.toTimeUTC)
				},
				lastDuration: '365'
			};

			var successCallBack = function(data) {
				self.data.jobsPage = data.jobs;
				var jobDetails = null;
				if (self.data.jobsPage.length > 0) {
					jobDetails = self.data.jobsPage[0].jobSummary;
					$scope.selectedJob = jobDetails.jobId + '';
					self.selectedJobDetails = jobDetails;
					getDatabases(self.entity, jobDetails);
				}
			};
			jobService.getJobsForEntity(filterOptions, successCallBack, function(e) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.noJobs');
				$scope.loading = false;
			});
		};

		var loadBreadCrumbs = function() {
			var breadCrumbs = [];

			var instanceNode = {
				title: cvLoc('label.instance'),
				link: '#instances'
			};
			breadCrumbs.push(instanceNode);
			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		var getInstanceDetails = function(instanceId) {
			idaService
				.getInstanceDetails(instanceId)
				.success(function(data) {
					if (data) {
						self.instanceDetails = data;
						self.entity = self.instanceDetails.instance;
						self.clientId = self.entity.clientId;
						//RAC don't support clone to RAC, so default destination to source doesn't make sence
						if (self.applicationId != AppTypes.ORACLE_RAC) {
							self.data.destClient = {
								clientId: self.entity.clientId,
								clientName: self.entity.clientName,
								applicationId: self.entity.applicationId
							};
						}
						self.destClientName = self.entity.clientName;

						//Check if is ASM storage type for Oracle.
						if (self.entity.applicationId == AppTypes.ORACLE || self.entity.applicationId == AppTypes.ORACLE_RAC) {
							var ORA_ASM_DEVICE = 2;
							var ORA_IMAGE_ASM_DEVICE = 4;
							var storageType = self.instanceDetails.oracleInstance.storageType;
							self.isASMStorageType = storageType & ORA_ASM_DEVICE || storageType & ORA_IMAGE_ASM_DEVICE;
						}
						loadBreadCrumbs();
						//self.loadData();
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
				});
		};

		self.loadDestinationPage = function() {
			if (self.clientsList == null && !self.isSqlClone) {
				self.populateClientList();
			}
			if (self.isSqlClone) {
				if (self.instanceList == null) self.populateSqlInstanceDetails();

				var date = new Date();
				var month = date.getMonth() + 1;

				self.destinationItems = angular.copy(self.sourceItems);

				self.destinationItems.forEach(function(db) {
					db.databaseName =
						db.databaseName +
						'-' +
						month +
						'-' +
						date.getDate() +
						'-' +
						date.getFullYear() +
						'-' +
						date.getMilliseconds();
				});

				self.cloneDbName = self.destinationItems[0].databaseName; //for sql, currently only single db allowed for one clone job
			}
			self.data.showiSCSIServer =
				self.sourceItems[0].fullJobDetails != null ? !self.sourceItems[0].fullJobDetails.cloneable : false;
			self.data.destClientLb = self.isSqlClone ? cvLoc('label.destinationClient') : cvLoc('label.clientName');
			self.data.cloneEnv.stagingPathLb = self.isSqlClone ? cvLoc('label.snapMountPath') : cvLoc('label.stagingPath');
			self.data.instanceLb = self.isSqlClone ? cvLoc('label.destinationInstance') : cvLoc('label.instanceName');
		};

		getInstanceDetails(parseInt(self.instanceId));

		self.destClientChanged = function(client) {
			if (!self.isSqlClone) {
				self.populateInstanceDetails(client.clientId, client.applicationId);
			} else {
				self.instanceList = [];
				if (self.sqlClientInstanceMap.has(client.clientId) && self.sqlClientInstanceMap.get(client.clientId).length > 0)
					self.instanceList = cvUtil.sortAscending(self.sqlClientInstanceMap.get(client.clientId), 'instanceName');
				self.updateOptions(self.instanceList[0]);
			}
		};

		self.populateClientList = function() {
			idaService.getRestoreDestinations(self.clientId, self.applicationId).then(
				function(data) {
					if (data != null) {
						var clientsList = [];
						angular.forEach(data.data, function(clietnInfo) {
							//We don't support RAC to RAC clone. Only RAC to ORACLE single instance
							if (self.applicationId == AppTypes.ORACLE_RAC && clietnInfo.applicationId == AppTypes.ORACLE_RAC) {
								return;
							}
							clientsList.push(clietnInfo);
							if (self.clientId == clietnInfo.clientId) self.data.destClient = clietnInfo;
						});
						self.clientsList = clientsList;
						if (self.data.destClient == null) self.data.destClient = clientsList[0];
						self.destClientChanged(self.data.destClient);
					}
				},
				function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading client groups');
				}
			);
		};

		/**
		 * Find which destination instance to use for populating Oracle home with below criteria
		 * 1. Non ASM, (ASM instance name starts with + or -)
		 * 2. Find the first instance that matches source version
		 * 3. If no instance with matched version found, use first instance which has greater version than source
		 * 4. return {} otherwise
		 */
		function getInstanceForOracleHome() {
			var matchedVerInst;
			var greaterVerInst;

			var sourceVersion = self.instanceDetails.version ? self.instanceDetails.version.split('.') : undefined;
			self.instanceList.forEach(function(instance) {
				if (!instance.instanceName.startsWith('+') && !instance.instanceName.startsWith('-')) {
					//if same as source, no need to version
					if (instance.instanceId === self.instanceDetails.instance.instanceId) {
						matchedVerInst = instance;
					}

					if (sourceVersion && instance.version) {
						var version = instance.version.split('.');

						var cmp = 0;
						//compare major minor version in left to right order. Oracle version example: 11.5.1.2.0
						for (var i = 0, j = 0; i < sourceVersion.length || j < version.length; i++, j++) {
							var sV = i < sourceVersion.length ? parseInt(sourceVersion[i]) : 0;
							var v = j < version.length ? parseInt(version[j]) : 0;
							if (v != sV) {
								cmp = v - sV;
								break;
							}
						}

						if (cmp == 0 && !matchedVerInst) {
							matchedVerInst = instance;
						} else if (cmp > 0 && !greaterVerInst) {
							greaterVerInst = instance;
						}
					}
				}
			});
			return matchedVerInst ? matchedVerInst : greaterVerInst ? greaterVerInst : {};
		}

		self.populateSqlInstanceDetails = function() {
			var params = {
				instanceId: self.entity.instanceId,
				sourceItems: angular.toJson(self.sourceItems),
				restoreType: 'RECOVERY_POINT'
			};

			sqlService.getSQLServerRestoreOptions(params).success(
				function(sqlRestoreOptions) {
					self.sqlDbDeviceItems = sqlRestoreOptions.sqlDbdeviceItem;
					self.phyfileRename = [];
					self.logfileRename = [];
					for (var i = 0; i < self.sqlDbDeviceItems.length; i++) {
						self.phyfileRename.push(self.sqlDbDeviceItems[i].fileName);
						self.logfileRename.push(self.sqlDbDeviceItems[i].logicalFileName);
					}
					var instanceList = [];
					var clientList = [];
					for (var i = 0; i < sqlRestoreOptions.sqlDestinationInstances.length; i++) {
						if (sqlRestoreOptions.sqlDestinationInstances[i].serverType === 'DataBase Engine') {
							//instanceList.push(sqlRestoreOptions.sqlDestinationInstances[i].genericEntity);

							if (sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.instanceId == self.instanceId) {
								self.data.instance = sqlRestoreOptions.sqlDestinationInstances[i].genericEntity;
							}

							//if instance list for this client exists, push instance in; otherwise create list and push instance in
							if (self.sqlClientInstanceMap.has(sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.clientId)) {
								var instanceList = self.sqlClientInstanceMap.get(
									sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.clientId
								);
								if (instanceList.indexOf(sqlRestoreOptions.sqlDestinationInstances[i].genericEntity) === -1)
									instanceList.push(sqlRestoreOptions.sqlDestinationInstances[i].genericEntity);
							} else {
								var client = {
									clientId: sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.clientId,
									clientName: sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.clientName,
									applicationId: 81
								};
								if (self.clientId == sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.clientId) {
									self.data.destClient = client;
									self.data.proxyClient = client;
								}
								clientList.push(client);
								var instanceList = [];
								instanceList.push(sqlRestoreOptions.sqlDestinationInstances[i].genericEntity);
								self.sqlClientInstanceMap.set(
									sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.clientId,
									instanceList
								);
							}
						}
					}

					if (self.sqlClientInstanceMap.has(self.clientId) && self.sqlClientInstanceMap.get(self.clientId).length > 0)
						self.instanceList = cvUtil.sortAscending(self.sqlClientInstanceMap.get(self.clientId), 'instanceName');
					if (!self.data.instance) {
						self.data.instance = sqlRestoreOptions.sqlDestinationInstances[0].genericEntity;
					}
					if (self.data.destClient == null) self.data.destClient = clientList[0];
					self.clientsList = clientList;

					self.data.instanceNameText = self.data.instance.instanceName;
					self.data.instanceId = self.data.instance.instanceId;
					self.data.instance.isDummyInstance = false;
				},
				function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading sql server restore options');
				}
			);
		};
		self.populateInstanceDetails = function(clientId, applicationId) {
			var sourceInstanceId = self.instanceId;
			agentService
				.getInstances(clientId, applicationId)
				.success(function(data) {
					if (data != null) {
						var instanceList = [];
						angular.forEach(data, function(instance) {
							var instanceProps = new Object();
							instanceProps = instance.instance;
							var isOnDemandInstance = false;
							if (instance.oracleInstance) {
								instanceProps.version = instance.version;
								instanceProps.oracleHome = instance.oracleInstance.oracleHome;
								instanceProps.oracleUser = instance.oracleInstance.oracleUser.userName;
								isOnDemandInstance = instance.oracleInstance.isOnDemand;
							}
							if (!isOnDemandInstance) {
								instanceList.push(instanceProps);
							}
						});

						if (instanceList.length > 0) self.instanceList = cvUtil.sortAscending(instanceList, 'instanceName');

						var instance = new Object();

						if (self.instanceList.length > 0) {
							var instanceForOracleHome = getInstanceForOracleHome();
							instance = angular.copy(instanceForOracleHome);
							delete instance.instanceId;
							self.data.cloneEnv.oraHome = instance.oracleHome;
							self.data.cloneEnv.oraUser = instance.oracleUser;
						} else {
							self.data.cloneEnv.oraHome = undefined;
							self.data.cloneEnv.oraUser = undefined;
						}
						instance.isDummyInstance = true;
						self.dummyInstance = instance;
						self.updateOptions(instance);
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		//Content page data loading and functions to same page
		self.loadData = function() {
			$scope.serverMessage = null;
			//In case point in time is selected we have to show the jobs table and the database for the selected job
			self.showJobsTable = false;

			if (self.data.cloneEnv.pitType === PIT) {
				if (self.data.cloneEnv.fromTime) {
					var result = {};
					result.toDateString = cvUtil.getUTCDate(self.data.cloneEnv.fromTime);
					self.data.cloneEnv.fromTimeUTC = result;
				}
				if (self.data.cloneEnv.toTime) {
					var result = {};
					result.toDateString = cvUtil.getUTCDate(self.data.cloneEnv.toTime);
					self.data.cloneEnv.toTimeUTC = result;
				}
				if (!self.isSqlClone) {
					self.showJobsTable = true;
					createJobsTable();
				}
				createContentTable();
			} else {
				createContentTable();
			}
		};

		self.showDataMasking = function() {
			return self.isOracleClone;
		};

		self.updateRowSelection = function() {
			$timeout(function() {
				if (self.gridApi) {
					//self.gridApi.selection.selectAllRows();
					self.gridApi.grid.rows.forEach(function(row) {
						if (row.entity.isSelected) {
							row.isSelected = true;
						} else {
							row.isSelected = false;
						}
					});
				}
			});
		};

		var createJobsTable = function() {
			$scope.selectedJobFuc = function(jobDetails) {
				$scope.selectedJob = jobDetails.jobId + '';
				self.selectedJobDetails = jobDetails;
				self.data.cloneEnv.stagingPath = null;
				getDatabases(self.entity, jobDetails);
			};
			var columnDefs = [];

			columnDefs.push(
				{
					field: 'jobSummary.jobId',
					displayName: '',
					cellTemplate:
						'<div class="crop" ><input type="radio" id="jobId+{{row.entity.jobSummary.jobId}}" value="{{row.entity.jobSummary.jobId}}"' +
						'data-ng-model="grid.appScope.selectedJob" data-ng-click="grid.appScope.selectedJobFuc(row.entity.jobSummary)" name="jobSelection"/></div>',
					enableHiding: false,
					width: '6%'
				},
				{
					field: 'jobSummary.jobId',
					displayName: 'Job Id',
					cellTemplate: '<div class="crop" >{{row.entity.jobSummary.jobId}}</div>',
					sort: {
						direction: 'dsc',
						priority: 0
					},
					width: '25%',
					enableHiding: false,
					cellTooltip: true
				}
			);
			columnDefs.push({
				field: 'jobSummary.jobStartTime',
				displayName: cvLoc('label.jobStratTime'),
				cellTemplate: '<div class="crop" >{{row.entity.jobSummary.jobStartTime * 1000 | date:\'medium\'}}</div>'
			});
			columnDefs.push({
				field: 'jobSummary.lastUpdateTime',
				displayName: cvLoc('label.jobEndTime'),
				cellTemplate: '<div class="crop" >{{row.entity.jobSummary.lastUpdateTime * 1000 | date:\'medium\'}}</div>'
			});

			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			angular.extend(globalGridOptions, {
				data: 'dbClone.data.jobsPage',
				enableGridMenu: false,
				paginationPageSize: 5,
				paginationPageSizes: [5, 10, 20, 50],
				columnDefs: columnDefs
			});

			self.gridJobOptions = {
				cvHasTitle: false,
				cvTableName: 'cloneJobSelection',
				cvIsSearchable: false,
				cvSearchFields: ['jobSummary.jobId', 'jobSummary.jobStartTime'],
				cvHasViews: false,
				cvGridDirectives: {
					uiGridSelection: false,
					uiGridPagination: true
				},
				cvServerMessage: 'label.noDBBackup',
				gridOptions: globalGridOptions
			};
			if (!self.data.jobsPage) {
				getSnapJobs();
			}
		};

		var createContentTable = function() {
			$scope.selectedDbFuc = function(entity) {
				self.data.cloneEnv.stagingPath = null;

				self.data.databases.forEach(function(db) {
					db.isSelected = false;
				});
				entity.isSelected = true;
				$scope.database.selectedDbID = entity.databaseId;
			};

			var columnDefs = [];

			columnDefs.push(
				/*{
				field: 'id',
				displayName: '',
				cellTemplate: '<div class="crop" ><input type="radio" id="dbID+{{row.entity.databaseId}}" value="{{row.entity.databaseId}}"' + 'data-ng-model="grid.appScope.database.selectedDbID" data-ng-click="grid.appScope.selectedDbFuc(row.entity)" name="dbSelection"/></div>',

				enableHiding: false,
				width: '6%'
			}, */
				{
					field: 'id',
					displayName: cvLoc('label.DatabaseName'),
					cellTemplate: '<div class="crop" title="{{row.entity.databaseName}}">{{row.entity.databaseName}}</div>',
					sort: {
						direction: 'asc',
						priority: 0
					},
					enableHiding: false,
					cellTooltip: true
				},
				{
					field: 'version',
					displayName: cvLoc('label.version'),
					cellTemplate: '<div class="crop" title="{{row.entity.version}}">{{row.entity.version}}</div>',
					width: '25%'
				}
			);

			var globalGridOptions = angular //this table is only used by sql
				.copy(cvTableOptions.commonNgGridOptions);
			angular.extend(globalGridOptions, {
				data: 'dbClone.data.databases',
				enableGridMenu: false,
				enableRowSelection: true,
				enableSelectAll: false,
				multiSelect: false,
				paginationPageSize: 5,
				paginationPageSizes: [5, 10, 20, 50],
				columnDefs: columnDefs,
				onRegisterApi: function(gridApi) {
					self.gridApi = gridApi;
					self.updateRowSelection();
					gridApi.selection.enableVerticalScrollbar = 0;

					gridApi.selection.on.rowSelectionChanged($scope, function(row) {
						$scope.selectedDbFuc(row.entity);
					});
				}
			});

			self.gridContentOptions = {
				cvHasTitle: false,
				cvTableName: 'cloneDatabaseSelection',
				cvIsSearchable: true,
				cvSearchFields: ['databaseName'],
				cvHasViews: false,
				cvServerMessage: 'label.noDBBackup',
				cvGridDirectives: {
					uiGridSelection: true,
					uiGridPagination: true
				},
				cvShowSelectedOption: true,
				cvGridCssClass: {
					'users-grid': true,
					'bottom-grid-fix': true
				},
				gridOptions: globalGridOptions
			};
			getDatabases(self.entity, null);
		};

		var getDatabases = function(entity, jobDetails) {
			if (!self.isSqlClone) {
				return; //get the database only for the SQL agent clone
			}
			var options = new Object();

			if (self.data.cloneEnv.pitType === PIT) {
				options.fromTime = fromatDateForServer(self.data.cloneEnv.fromTimeUTC);
				options.toTime = fromatDateForServer(self.data.cloneEnv.toTimeUTC);
			}

			options['applicationId'] = self.applicationId;
			options['entityId'] = self.instanceId;
			options['entityType'] = 'INSTANCE_ENTITY';
			options['path'] = '\\';
			options['pageSize'] = 15;
			options['currentPage'] = 0;
			options['sortingInfo'] = 'asc:Flags,FileName';
			options['pagingInfo'] = '0,15';
			options['sqlMergeRPToClone'] = true;

			self.data.databases = null;

			idaService.getSnapDatabases(entity, options).then(
				function(data) {
					if (data && data.data) {
						self.data.databases = data.data;
					} else {
						self.data.databases = [];
					}

					self.updateRowSelection();
				},
				function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading snap databases');
				}
			);
		};

		self.timeSelectionChange = function(pitType) {
			//Clear the jobs list, so that it will re loads the data
			if (self.data.jobsPage) {
				self.data.jobsPage = null;
				self.data.databases = null;
			}
		};

		self.oraPfileResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.oraPfile = result.path;
		};

		self.stagingPathResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.stagingPath = result.path;
		};

		self.oracleHomeResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.oraHome = result.path;
		};

		self.commondFilePathResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.commondFilePath = result.path;
		};

		self.diskMappingFileResultFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.diskMappingFile = result.path;
		};

		var gotoSourceSelection = function() {
			if (self.sourceLocation && self.sourceLocation === 'manageClones') {
				$state.go('manageClones', {
					instanceId: self.instanceId
				});
			} else if (self.sourceLocation && self.sourceLocation === 'agentDetails') {
				$state.go('agentDetails', {
					clientId: self.entity.clientId,
					applicationId: self.applicationId
				});
			} else if (self.sourceLocation && self.sourceLocation === 'sqlInstantClones') {
				$state.go('sqlInstantClones', {
					clientId: self.entity.clientId,
					instanceId: self.instanceId
				});
			} else {
				$state.go('instances');
			}
		};

		self.wizardCancelMethod = function() {
			gotoSourceSelection();
		};

		self.composeCreateRecoveryObj = function() {
			var cloneData = self.data.cloneEnv;

			var timeRange = {
				fromTime: 0,
				toTime: 0
			};

			if (self.data.cloneEnv.pitType === PIT) {
				timeRange.toTime = getUnixTimestamp(self.data.cloneEnv.toTime);

				timeRange.fromTime = getUnixTimestamp(self.data.cloneEnv.fromTime);
			}

			var miningJobs = [];
			if (self.sourceItems[0].fullJobDetails) miningJobs.push(self.sourceItems[0].fullJobDetails.jobId);

			var createRPObj = {
				//map to SQLRecoveryPointCreationObj.java
				maClientId: self.data.destClient.clientId,
				expireDays: cloneData.rsvTPDays,
				expireHours: cloneData.rsvTPHours,
				database: self.sourceItems[0].databaseName,
				destDatabase: self.cloneDbName,
				miningJobs: miningJobs,
				fromTimeRange: timeRange.fromTime ? timeRange.fromTime : 0,
				toTimeRange: timeRange.toTime ? timeRange.toTime : 0,
				clientId: self.entity.clientId,
				iscsiMountHostId: self.data.proxyClient ? self.data.proxyClient.clientId : 0,
				sourceInstance: self.entity,
				mountInstance: self.data.instance,
				agentVersion: self.sourceItems[0].agentVersion ? self.sourceItems[0].agentVersion : 0,
				subclientId: self.sourceItems[0].fullJobDetails ? self.sourceItems[0].fullJobDetails.subclientId : 0,
				phyfileRename: self.phyfileRename,
				logfileRename: self.logfileRename,
				snapMountPath: self.data.cloneEnv.stagingPath,
				bOverwrite: self.data.cloneEnv.forceCleanup,
				backupMethod: self.sourceItems[0].fullJobDetails ? self.sourceItems[0].fullJobDetails.backupMethod : null,
				backupFinishTime: self.sourceItems[0].fullJobDetails
					? self.sourceItems[0].fullJobDetails.backupFinishTime
					: null
			};
			return createRPObj;
		};

		self.createRecoveryPointJob = function() {
			sqlRecoveryPointsService
				.createRecoveryPointObject({
					createRecoveryPointObj: angular.toJson(self.composeCreateRecoveryObj())
				})
				.success(function(successData) {
					if (successData > 0 && successData.length > 0) {
						var jobUrl = '#/jobs/' + successData;
						var viewCloneList = cvLoc('header.manageClones');
						var responseContent =
							' <a target="_blank" href="' + jobUrl + '">' + cvLoc('label.cloneRedirectMsg', successData) + '</a>';
						cvToaster.showSuccessMessage({
							ttl: '15000',
							message: responseContent
						});
						gotoSourceSelection();
					} else {
						self.serverMessage = cvUtil.errMsgLoc('error.start.rp.job');
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsgLoc('generic_error');
					$log.error(e);
				});
			return;
		};

		function getUnixTimestamp(timeText) {
			return new Date(timeText).getTime() / 1000;
		}

		self.submitCloneSnap = function() {
			if (self.isSqlClone) {
				self.createRecoveryPointJob();
			} else {
				var entityType = 'INSTANCE_ENTITY';
				var genericEntity = angular.copy(self.entity);

				var composeAgentSpecificOptions = function() {
					var agentSpecificOptions = new Object();
					var cloneData = self.data.cloneEnv;
					var resrTime = cloneData.rsvTPDays * 24 * 60 * 60 + cloneData.rsvTPHours * 60 * 60;

					if (self.isSqlClone) {
						agentSpecificOptions.cloneEnv = true;
						agentSpecificOptions.overWrite = self.data.cloneEnv.forceCleanup;
						agentSpecificOptions.cloneEnvType = 1;
						agentSpecificOptions.cloneResrvTimePeriod = resrTime;
						agentSpecificOptions.commonMountPath = [self.data.cloneEnv.stagingPath];

						var seperator = String.fromCharCode(9);
						var seperator12 = String.fromCharCode(0x12);

						var deviceInfoList = [];
						var deviceList = [];

						for (var i = 0; i < self.sqlDbDeviceItems.length; i++) {
							var temp = self.sqlDbDeviceItems[i];

							var deviceInfoStr =
								temp.sqlDBInfo.databaseId +
								seperator +
								self.cloneDbName +
								seperator +
								(temp.id == 0 ? ' ' : temp.id) +
								seperator +
								(temp.id == 0 ? ' ' : temp.fileName) +
								seperator +
								temp.fileName +
								seperator +
								temp.logicalFileName +
								seperator +
								temp.fileMaxSize +
								seperator +
								self.sourceItems[0].databaseName +
								seperator;

							deviceInfoList.push(deviceInfoStr);

							var deviceStr =
								temp.sqlDBInfo.databaseName +
								seperator12 +
								self.cloneDbName +
								seperator12 +
								temp.logicalFileName +
								seperator12 +
								temp.fileName +
								seperator12 +
								temp.fileName;

							deviceList.push(deviceStr);
							agentSpecificOptions.device = deviceList;
							agentSpecificOptions.deviceInfo = deviceInfoList;
						}
					} else if (self.isOracleClone) {
						var userConnect = new Object();
						agentSpecificOptions.noCatalog = true;
						agentSpecificOptions.cloneEnv = true;
						agentSpecificOptions.resetLogs = 0;
						agentSpecificOptions.restoreData = true;

						agentSpecificOptions.recover = true;

						agentSpecificOptions.cloneEnvParameters = self.data.cloneEnv;

						agentSpecificOptions.cloneEnvParameters.resrvTimePeriod = resrTime;
						agentSpecificOptions.cloneEnvParameters.instanceId = self.data.instance.instanceId;
						agentSpecificOptions.cloneEnvParameters.overfideExists = self.data.cloneEnv.forceCleanup;
						agentSpecificOptions.cloneEnvParameters.oraSID = self.data.instance.instanceName;

						//Set redoLogSize in format same as Java GUI
						if (self.data.cloneEnv.redoLogSize) {
							agentSpecificOptions.duplicateToLogFile = true;
							agentSpecificOptions.logFileGroup = true;
							agentSpecificOptions.duplicateToLogFilesList =
								"LOGFILE&#10;GROUP 1&#10;(&#10;'redo' &#10;)  SIZE " + self.data.cloneEnv.redoLogSize + 'M&#10;';
							agentSpecificOptions.duplicateToLogFilesListValue = [
								'1\t' + self.data.cloneEnv.redoLogSize + '\tM\tno&#10;redo'
							];
						}
						//Set Username to empty for Oracle.
						agentSpecificOptions.cloneEnvParameters.oraUser = undefined;

						//Set restore and recover time
						agentSpecificOptions.restoreFrom = PIT;
						agentSpecificOptions.restoreTime = {
							time: 0
						};
						agentSpecificOptions.recoverFrom = LATEST_SCN_NUMBER;
						if (self.data.cloneEnv.pitType === PIT) {
							var unixTime = getUnixTimestamp(self.data.cloneEnv.toTime);
							agentSpecificOptions.restoreTime.time = unixTime;
							agentSpecificOptions.recoverFrom = PIT;
							agentSpecificOptions.recoverTime = {
								time: unixTime
							};
						}
					}
					return agentSpecificOptions;
				};

				var agentSpecificOptions = composeAgentSpecificOptions();

				var composeSourceItemsToRestore = function() {
					if (self.isSqlClone) {
						var sourcePathList = [];
						self.sourceItems.forEach(function(entity) {
							var dbName = entity.databaseName;

							sourcePathList.push(dbName);
						});

						return sourcePathList;
					} else {
						return null;
					}
				};

				var sourceItemsToRestore = composeSourceItemsToRestore();

				var composeDestination = function() {
					var destination = new Object();
					destination.destClient = self.data.destClient;
					if (self.isSqlClone) {
						destination.destinationInstance = self.data.instance;
					} else {
						//Need to populate appId if user enters a new destination instance instead of selecting existing instance.
						destination.destinationInstance = angular.extend({}, destination.destClient, {
							//RAC restores to Oracle instead of RAC
							applicationId: self.applicationId == AppTypes.ORACLE_RAC ? AppTypes.ORACLE : self.entity.applicationId,
							appName: self.applicationId == AppTypes.ORACLE_RAC ? 'Oracle' : self.entity.appName,
							instanceId: self.data.instance.instanceId,
							instanceName: self.data.instance.instanceName
						});
					}
					return destination;
				};

				var browseOption = {
					commCellId: 2,
					browseJobId: null,
					timeRange: {
						fromTimeValue: null,
						toTimeValue: null
					},
					mediaOption: {
						copyPrecedence: {
							copyPrecedenceApplicable: true,
							copyPrecedence: self.data.cloneEnv.copyPrec
						}
					}
				};

				if (self.isOracleClone) {
					browseOption.timeRange.fromTime = 0;
					browseOption.timeRange.toTime = 0;
					if (self.data.cloneEnv.pitType === PIT) {
						var unixTime = getUnixTimestamp(self.data.cloneEnv.toTime);
						browseOption.timeRange.toTime = unixTime;
					}
				}

				var destination = composeDestination();

				var commonOptions = new Object();
				commonOptions.prePostOpts = {
					postRecoveryCommand: self.data.commondFilePath
				};

				var composeDataMaskingOptions = function() {
					if (self.showDataMasking()) {
						return self.data.dataMaskingOptions;
					}
					return undefined;
				};
				var dataMaskingOptions = composeDataMaskingOptions();

				idaService
					.submitCloneJob({
						entityType: entityType,
						genericEntity: angular.toJson(genericEntity),
						browseOption: angular.toJson(browseOption),
						destination: angular.toJson(destination),
						commonOptions: angular.toJson(commonOptions),
						sourceItemsToRestore: angular.toJson(sourceItemsToRestore),
						agentSpecificOptions: angular.toJson(agentSpecificOptions),
						dmOptions: angular.toJson(dataMaskingOptions),
						passwordsInfo: null
					})
					.success(function(successData) {
						if (successData) {
							var jobUrl = '#/jobs/' + successData;
							var responseContent =
								' <a target="_blank" href="' +
								jobUrl +
								'">' +
								cvLoc('label.cloneRedirectMsg') +
								' ' +
								successData +
								'</a>';
							cvToaster.showSuccessMessage({
								ttl: '15000',
								message: responseContent
							});
							gotoSourceSelection();
						}
					})
					.error(function(err) {
						cvToaster.showErrorMessage({
							message: err
						});
					});
				return;
			}
		};
	}
]);

export default app;
