(function() {
	'use strict';

	/**
	 * A controller for handling the functionality on the page to view all global parameters.
	 */
	angular.module('common.globalParams', []).controller('globalParamsController', [
		'serverService',
		'cvToaster',
		function(serverService, cvToaster) {
			var self = this;

			self.globalParams = angular.copy(cvApp.globalParams);

			/**
			 * Sets a global parameter to a given value.
			 *
			 * @param {string}
			 *            param - The parameter to set.
			 * @param {string}
			 *            value - The value to set the parameter to.
			 */
			self.setGlobalParam = function(param, value) {
				serverService.setGlobalParam(param, value).then(function() {
					self.globalParams = angular.copy(cvApp.globalParams);
					cvToaster.showSuccessMessage({
						message: 'Your changes have been saved.'
					});
				});
			};
		}
	]);
})();
