<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div class="panel-body" data-ng-init="cvFirewallOptions.populatProxyClients()"> 
	<div class="form-group">
		<input type="checkbox" data-ng-model="cvFirewallOptions.firewallConfig.enableFirewallConfig" 
				id="enableFirewall" name="enableFirewall" />
		<label class="col-xs-12 col-lg-12" for="enableFirewall">
			<cv:msg key="label.firewallEnable" bundle="oracle"/> 
		</label>
	</div>
	<div data-ng-hide="!cvFirewallOptions.firewallConfig.enableFirewallConfig" data-ng-init="cvFirewallOptions.updateTunnerlPortSelection(cvFirewallOptions.firewallConfig.firewallConnectionType)">
			<div data-ng-hide="cvFirewallOptions.hideConnectionType.includes(0)" class="form-group">
				<label class="col-xs-12 col-lg-12" for="commServTunnel">
					<input type="radio" data-ng-model="cvFirewallOptions.firewallConfig.firewallConnectionType" 
						value="0" id="commServTunnel" name="commServTunnel" data-ng-change="cvFirewallOptions.updateTunnerlPortSelection(cvFirewallOptions.firewallConfig.firewallConnectionType)" />
					<cv:msg key="label.csTunnelPort" bundle="oracle"/>					 
				</label>
			</div>
		<div data-ng-hide="cvFirewallOptions.hideConnectionType.includes(1)" class="form-group">
				<label class="col-xs-12 col-lg-12" for="commServTowardsClient" >
					<input type="radio" data-ng-model="cvFirewallOptions.firewallConfig.firewallConnectionType"
						value="1" id="commServTowardsClient" name="commServTowardsClient" data-ng-change="cvFirewallOptions.updateTunnerlPortSelection(cvFirewallOptions.firewallConfig.firewallConnectionType)" /> 
					<cv:msg key="label.towardsClinetMachin" bundle="oracle"/>
				</label>
		</div> 
		<div data-ng-hide="cvFirewallOptions.hideConnectionType.includes(2)"class="form-group">
			<label class="col-xs-12 col-lg-12" for="throughProxy" >
				<input type="radio" data-ng-model="cvFirewallOptions.firewallConfig.firewallConnectionType"
					value="2" id="throughProxy" name="throughProxy" data-ng-change="cvFirewallOptions.updateTunnerlPortSelection(cvFirewallOptions.firewallConfig.firewallConnectionType)" /> 
				<cv:msg key="label.commserveProxy" bundle="oracle"/>
			</label>
		</div>
		<div class="form-group" data-ng-hide="cvFirewallOptions.firewallConfig.firewallConnectionType == 2">
			<label class="col-xs-2 col-lg-2" data-ng-if="!cvFirewallOptions.modalStyle">
			</label>
			<label class="col-xs-8 col-lg-8" >
				<cv:msg key="label.httpsPort" bundle="oracle"/> 
				<cv-help-component help-text="{{cvFirewallOptions.firewallConnetionLabel}}"></cv-help-component>
			</label>
			<div class="col-xs-4 col-lg-4">
			 	<input type="number" name="httpsTunnelPort" id="httpsTunnelPort" data-ng-model="cvFirewallOptions.firewallConfig.portNumber" min="0" max="65535"
			 	data-ng-required="(cvFirewallOptions.firewallConfig.enableFirewallConfig && cvFirewallOptions.firewallConfig.firewallConnectionType != 2)" />
			 	<span class="help-block" data-ng-show="submitController.needsAttention(formController.httpsTunnelPort)">
					 <cv:msg key="error.httpsPort" bundle="oracle"/> 
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-hide="cvFirewallOptions.firewallConfig.firewallConnectionType != 2">
			<label class="col-xs-2 col-lg-2" data-ng-if="!cvFirewallOptions.modalStyle">
			</label>
			<label class="col-xs-6 col-lg-6" for="proxyClients" >
				<cv:msg key="label.clientProxy" bundle="oracle"/> 
			</label>
			<label data-ng-class='{"col-xs-4": !cvFirewallOptions.modalStyle, "col-xs-6":cvFirewallOptions.modalStyle}'>
				<select name="proxyClient" id="proxyClient" data-ng-required="cvFirewallOptions.firewallConfig.enableFirewallConfig && cvFirewallOptions.firewallConfig.firewallConnectionType == 2"
					data-ng-options="pClient.clientName as pClient.clientName for pClient in cvFirewallOptions.proxyClients"
					data-ng-model="cvFirewallOptions.firewallConfig.proxyClientName" >
					<option value=""><cv:msg key="options.clientProxy" bundle="oracle"/> </option>
				</select>
				<span class="help-block" data-ng-show="submitController.needsAttention(formController.proxyClient)">
					 <cv:msg key="error.clientProxy" bundle="oracle"/> 
				</span>
			</label>
		</div>
		<div class="form-group" data-ng-if="!cvFirewallOptions.modalStyle">
		</div>
		<div class="form-group" data-ng-if="!cvFirewallOptions.modalStyle">
		</div>
		<div class="form-group" data-ng-if="!cvFirewallOptions.modalStyle">
			<label class="col-xs-12 col-lg-12">
				<cv:msg key="label.firewallNote" bundle="oracle"/> 
			</label>
		</div>
	</div>
</div>
