<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div data-ng-class="{'panel-body':!computeNode.modalStyle}" >
	<div class="form-group" data-ng-if="computeNode.migrationType !== 'appMigration'">
		<label class="col-xs-12 col-sm-5" for="hostName">
			<cv:msg key="label.nodeName" bundle="ebsApp"/>
		</label>
		<div class="col-xs-12 col-sm-7">
			<input type="text" data-ng-model="computeNode.nodeData.hostName" data-ng-required="true"
				id="hostName" name="hostName" />
			<span class="help-block" data-ng-show="submitController.needsAttention(formController.hostName)">
				<cv:msg key="error.nodeName" bundle="ebsApp"/>
			</span>
		</div>
	</div>
	
	<div data-ng-if="computeNode.migrationType !== 'appMigration' || !computeNode.isVmSelected">
		<div class="form-group">
			<div class="serverMessage error" data-ng-if="computeNode.isAzurePolicy && !computeNode.vmsTempList.length">
				<span>
					<cv:msg key="error.TemplateNotFound" bundle="restore"/>
				</span>
			</div>
			<label class="col-xs-12 col-sm-5" for="amiName">
				<span data-ng-if="computeNode.isAmazonPolicy">
					<cv:msg key="label.ami" bundle="oracle"/>
				</span>
				<span data-ng-if="computeNode.isOracleCloudPolicy || computeNode.isOCIPolicy">
					<cv:msg key="label.image" bundle="oracle"/>
				</span>
				<span data-ng-if="computeNode.isAzurePolicy">
					<cv:msg key="label.vmTemplate" bundle="restore"/>
				</span>
			</label>
			<div class="col-xs-12 col-sm-7" data-ng-disabled="computeNode.isVmSelected">
				<%-- <select name="amiName" id="amiName"  data-ng-required="true"
					data-ng-options="vmTemp as vmTemp.vmName for vmTemp in computeNode.vmsTempList"
					data-ng-model="computeNode.nodeData.machineConfig.vmTemplate.vm" >
					<option value="">{{computeNode.selectAmiLabel}}</option>
				</select>
				<span class="help-block" data-ng-show="submitController.needsAttention(formController.amiName)">
					<span data-ng-hide="computeNode.isOracleCloudPolicy"> <cv:msg key="error.ami" bundle="oracle"/> </span>
					<span data-ng-show="computeNode.isOracleCloudPolicy"> <cv:msg key="error.image" bundle="oracle"/> </span>
				</span> --%>
					<cv-isteven-single-select id-name="amiName"
						input-model="computeNode.vmsTempList"
						binding-model="computeNode.nodeData.machineConfig.vmTemplate.vm"
						label="vmDisplayName"
						track-field="vmDisplayName"
						tick-property="selected"
						place-holder='{{computeNode.selectAmiLabel}}'
						help-text='{{  computeNode.isAmazonPolicy ? "<cv:msg key="error.ami" bundle="oracle"/>" :"<cv:msg key="error.image" bundle="oracle"/>"}}'
						required='true'>
					</cv-isteven-single-select>
			</div>
		</div>
	<div class="form-group">
		<label class="col-xs-12 col-sm-5" for="instanceType">
			 <span data-ng-show="computeNode.isAmazonPolicy">
                <cv:msg key="label.instanceType" bundle="oracle"/>
            </span>
            <span data-ng-show="computeNode.isAzurePolicy">
                <cv:msg key="label.size" bundle="job"/>
            </span>
            <span data-ng-show="computeNode.isOracleCloudPolicy">
                <cv:msg key="label.Shape" bundle="oracle"/>
            </span>
		</label>
		<div class="col-xs-12 col-sm-7" data-ng-disabled="computeNode.isVmSelected">
			<%-- <select name="instanceType" id="instanceType"  data-ng-required="true"
				data-ng-options="instanceType as instanceType.instanceType.vmInstanceTypeName for instanceType in computeNode.instanceTypeList"
				data-ng-model="computeNode.nodeData.machineConfig.vmInstType" >
				<option value="">{{computeNode.selectInstanceTypeLabel}}</option>
			</select>
			<span class="help-block" data-ng-show="submitController.needsAttention(formController.instanceType)">
				<span data-ng-hide="computeNode.isOracleCloudPolicy"> <cv:msg key="error.instanceType" bundle="oracle"/> </span>
        		<span data-ng-show="computeNode.isOracleCloudPolicy"> <cv:msg key="error.shape" bundle="oracle"/> </span>
			</span> --%>
			
			<cv-isteven-single-select id-name="instanceType" 
				input-model="computeNode.instanceTypeList"
				binding-model="computeNode.nodeData.machineConfig.vmInstType"
				label="flatLabel"
				track-field="instanceType.vmInstanceTypeName"
				tick-property="selected"
				place-holder='{{computeNode.selectInstanceTypeLabel}}'
				help-text='{{computeNode.isOracleCloudPolicy?"<cv:msg key="error.shape" bundle="oracle"/>" :"<cv:msg key="error.instanceType" bundle="oracle"/>"}}'
				required='true'>
			</cv-isteven-single-select>
			
		</div>
	</div>
	<div class="form-group" data-ng-show="computeNode.isOracleCloudPolicy || computeNode.isOCIPolicy">
		<label class="col-xs-12 col-sm-5" for="networkList">
			<cv:msg key="label.networkSettings" bundle="restore" />
		</label>
		<div class="col-xs-12 col-sm-7">
			
			<%-- <select name="networkList" id="networkList" 
				data-ng-options="networkSetting.networkName for networkSetting in computeNode.networkSettingsList"
				data-ng-change="computeNode.networkNameSelection()"
				data-ng-model="computeNode.nodeData.machineConfig.advVMProperties.networkCards[0]" >
				<option value=""><cv:msg key="option.selectNetwork" bundle="oracle"/></option>
			</select> --%>
			
			<cv-isteven-single-select 
				id-name="networkList"
				input-model="computeNode.networkSettingsList"
				binding-model="computeNode.nodeData.machineConfig.advVMProperties.networkCards[0]"
				label="networkName"
				track-field="networkName"
				tick-property="selected"
				place-holder='<cv:msg key="option.selectNetwork" bundle="oracle"/>'
				required='false'>
			</cv-isteven-single-select>
			<!--  
			<isteven-multi-select
  				  input-model="computeNode.networkSettingsList"
  				  output-model="computeNode.nodeData.machineConfig.advVMProperties.networkCards"
 				  button-label="networkName"
 				  item-label="networkName"
 				  selection-mode="single"
  				  tick-property="ticked"
  				  class="isteven-multi-select user-group-select"
  				  id="networkList"
  				  name="networkList"
  				  helper-elements="filter"
  				  max-labels="1"
  				  translation="computeNode.localLang"
  				  on-item-click="funcClick()"
   				  on-select-none="funcClick()"
   				  on-select-all="funcClick()"
   				  on-reset="funcClick()"
  				  on-close="computeNode.networkNameSelection()">
			</isteven-multi-select>
			-->
			<!-- <span class="help-block" data-ng-show="cv.configOptions.getAttempted() && !isNetworkSettingsListAvailable()">Please select networks</span> -->
		</div>
	</div>
	<div class="form-group" data-ng-show="computeNode.isOCIPolicy">
		<label class="col-xs-12 col-sm-5" for="subnetList">
			<cv:msg key="label.subnet" bundle="oracle" />
		</label>
		<div class="col-xs-12 col-sm-7">
		
			<%-- <select name="subnetList" id="subnetList" 
				data-ng-options="subnet.name for subnet in computeNode.subnetList"
				data-ng-model="computeNode.nodeData.machineConfig.advVMProperties.subnetList[0]" >
				<option value=""><cv:msg key="option.selectSubnet" bundle="oracle"/></option>
			</select> --%>
			<cv-isteven-single-select 
				id-name="subnetList"
				input-model="computeNode.subnetList"
				binding-model="computeNode.nodeData.machineConfig.advVMProperties.subnetList[0]"
				label="name"
				track-field="name"
				tick-property="selected"
				place-holder='<cv:msg key="option.selectSubnet" bundle="oracle"/>'
				required='false'>
			</cv-isteven-single-select>
			<!--  
			<isteven-multi-select
  				  input-model="computeNode.subnetList"
  				  output-model="computeNode.nodeData.machineConfig.advVMProperties.subnetList"
 				  button-label="name"
 				  item-label="name"
  				  tick-property="ticked"
  				  class="isteven-multi-select user-group-select"
  				  id="subnetList"
  				  name="subnetList"
  				  helper-elements="all none reset filter"
  				  max-labels="1"
  				  translation="computeNode.localLang"
  				  on-item-click="funcClick()"
   				  on-select-none="funcClick()"
   				  on-select-all="funcClick()"
   				  on-reset="funcClick()"
  				  on-close="funcClick()">
		</isteven-multi-select>
		-->
		<!-- <span class="help-block" data-ng-show="cv.configOptions.getAttempted() && !isNetworkSettingsListAvailable()">Please select networks</span> -->
		</div>
	</div>
	<div class="form-group" data-ng-show="computeNode.migrationType === 'appMigration' && !computeNode.isOCIPolicy">
		<label class="col-xs-12 col-sm-5" >
			<cv:msg key="label.noOfCpus" bundle="oracle"/>
		</label>
		<label class="col-xs-12 col-sm-7" >
			 {{computeNode.nodeData.machineConfig.vmInstType.cpuCores}}
		</label>
	</div>
	<div class="form-group" data-ng-show="computeNode.migrationType === 'appMigration' && !computeNode.isOCIPolicy">
		<label class="col-xs-12 col-sm-5" >
			<cv:msg key="label.memoryGB" bundle="oracle"/>
		</label>
		<label class="col-xs-12 col-sm-7" >
			 {{computeNode.nodeData.machineConfig.vmInstType.memory}}
		</label>
	</div>
	</div>
	<div class="form-group" data-ng-show="computeNode.migrationType === 'ebsApp'">
		<label class="col-xs-12 col-sm-5" >
			<cv:msg key="label.nodeType" bundle="ebsApp"/>
		</label>
		<div class="col-xs-12 col-sm-3">
			<input type="checkbox" data-ng-model="computeNode.nodeData.database" id="ebsNodeTypeDB" name="ebsNodeTypeDB" />
			<label for="ebsNodeTypeDB" >
				<cv:msg key="label.dbName" bundle="ebsApp"/>
			</label>
		</div>
		<div class="col-xs-12 col-sm-4">
			<input type="checkbox" data-ng-model="computeNode.nodeData.application" id="ebsNodeTypeApp" name="ebsNodeTypeApp" />
				<label for="ebsNodeTypeApp">
					<cv:msg key="label.appName" bundle="ebsApp"/>
				</label>
		</div>
	</div>
	<div data-ng-class="{'panel-body':computeNode.modalStyle}" data-ng-if="computeNode.migrationType !== 'appMigration'">
		<div class="form-group">
			<data-cv-storage-config sorage-model="computeNode.nodeData.machineConfig.storageVol_list" config-type="computeNode.configType" ></data-cv-storage-config>
		</div>
	</div>
</div>