import { ebsAppServerModule } from 'common/js/modules';

var genAppModule = ebsAppServerModule;

genAppModule.service('genAppService', [
	'$http',
	function($http) {
		this.getGenApps = function() {
			return $http.get('genApps.do');
		};

		this.genAppOperations = function(params) {
			return $http.post('genAppOperations.do', params);
		};

		this.getEBSAppWithStorage = function(ebsAppId) {
			return $http.get('ebsAppWithStorage.do?ebsAppId=' + ebsAppId);
		};

		this.saveGenApp = function(params) {
			return $http.post('saveGenApp.do', params);
		};

		this.addServerToGenApp = function(params) {
			return $http.post('addServerToGenApp.do', params);
		};

		this.getGenAppIvhTreeViewData = function(params) {
			return $http.post('getGenAppIvhTreeViewData.do', params);
		};
	}
]);

export default genAppModule;
