import 'adminConsole/js/services/clientGroups.svc.js';
import 'modules/genApp/js/services/genApp.svc.js';
import 'modules/genApp/js/controllers/restoreGenApp.ctrl.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.controller('restoreGenAppComponentCtrl', [
	'$dialogs',
	'clientGroupService',
	'AppTypesUtil',
	'$log',
	'cvLoc',
	'cvToaster',
	'$uibModal',
	'cvTableOptions',
	'cvUtil',
	'genAppService',
	function(
		$dialogs,
		clientGroupService,
		AppTypesUtil,
		$log,
		cvLoc,
		cvToaster,
		$modal,
		cvTableOptions,
		cvUtil,
		genAppService
	) {
		var self = this;
		this.$onInit = function() {
			self.sourceClientList = [];

			var updateNodeType = function(genAppNode) {
				var nodeType = cvLoc('nodeType.app');
				if (
					genAppNode &&
					genAppNode.appContent &&
					genAppNode.dbContent &&
					genAppNode.dbContent[0].dbSubclients &&
					genAppNode.dbContent[0].dbSubclients.length > 0
				) {
					nodeType = cvLoc('nodeType.appDB');
				} else if (
					genAppNode &&
					genAppNode.dbContent &&
					genAppNode.dbContent[0].dbSubclients &&
					genAppNode.dbContent[0].dbSubclients.length > 0
				) {
					nodeType = cvLoc('nodeType.db');
				}
				genAppNode.nodeType = nodeType;
			};

			self.initData = function(vmTeplPolicy, genAppData, migrationType, editing) {
				self.vmTeplPolicy = vmTeplPolicy;
				self.genAppData = genAppData;
				self.migrationType = migrationType;
				self.editing = editing;

				if (self.genAppData) {
					self.genAppData.genAppName = self.genAppData.name;
					self.genAppData.serverList = self.genAppData.enterpriseNodes;
					if (self.genAppData.serverList) {
						self.genAppData.serverList.forEach(function(entity) {
							if (!entity.srcClient) {
								entity.srcClient = angular.copy(entity.cvClient);
							}
							self.sourceClientList.push(entity.cvClient);
							updateNodeType(entity);
						});
					} else {
						self.genAppData.serverList = [];
					}
					self.genAppData.tags = self.genAppData.tags;
					if (!self.genAppData.tags) {
						self.genAppData.tags = [];
					}
				} else {
					self.genAppData.serverList = [];
					self.genAppData.tags = [];
				}

				createServersTable();
				createConfigTable();
				self.populatClients();
			};

			self.clientSelectionChanged = function(rowEntity, tarClient) {
				if (rowEntity.dbContent && rowEntity.dbContent.length > 0) {
					rowEntity.dbContent.forEach(function(dbContent) {
						var rstContent = [];
						if (dbContent && dbContent.dbSubclients) {
							dbContent.dbSubclients.forEach(function(dbSubclient) {
								var content = {
									client: rowEntity.srcClient,
									instance: dbContent.instance,
									content: dbSubclient.content
								};
								rstContent.push(content);
							});
							dbContent.rstContent = rstContent;
						}
					});
				}
				if (rowEntity.appContent && rowEntity.appContent.length > 0) {
					rowEntity.appContent.forEach(function(appContent) {
						var rstContent = [];
						if (appContent && appContent.subclients) {
							appContent.subclients.forEach(function(subclients) {
								var content = {
									client: rowEntity.srcClient,
									content: subclients.content
								};
								rstContent.push(content);
							});
							appContent.rstContent = rstContent;
						}
					});
				}
			};

			self.selectSourceClient = function(rowEntity) {
				if (rowEntity && rowEntity.srcClient && rowEntity.srcClient.clientId) {
					self.clientList.forEach(function(clientEntity) {
						if (clientEntity.clientId == rowEntity.srcClient.clientId) {
							rowEntity.cvClient = clientEntity;
						}
					});
				}
			};
			var createServersTable = function() {
				var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
				var columnDefs = [];
				columnDefs.push({
					field: 'SourceServerName',
					displayName: cvLoc('label.srcServerName'),
					cellTemplate: '<span title="{{row.entity.srcClient.clientName}}" >{{row.entity.srcClient.clientName}}</span>',
					enableHiding: false,
					cellTooltip: true,
					width: '25%'
				});

				columnDefs.push({
					field: 'TargetServerName',
					displayName: cvLoc('label.trgServerName'),
					cellTemplate:
						'<select name="clientName" id="clientName" data-ng-options="client as client.clientName for client in grid.appScope.clientList | orderBy:\'clientName\'" ' +
						'	data-ng-model="row.entity.cvClient" data-ng-change="grid.appScope.clientSelectionChanged(row.entity,row.entity.cvClient)" > <option value="">' +
						cvLoc('option.trgServerName') +
						'</option></select>',
					enableHiding: false,
					cellTooltip: true,
					width: '35%'
				});

				columnDefs.push({
					field: 'volumeTag',
					displayName: cvLoc('label.serverType'),
					cellTemplate: '<span title="{{row.entity.nodeType}}">{{row.entity.nodeType}}</span>',
					width: '28%'
				});

				columnDefs.push({
					field: 'edit',
					displayName: '',
					cellTemplate:
						'<span title="' +
						cvLoc('label.editServer') +
						'" data-ng-click="grid.appScope.editServer(row.entity)" ><i class="fa fa-pencil"></i></span>',
					width: '5%'
				});
				columnDefs.push({
					field: 'delete',
					displayName: '',
					cellTemplate:
						'<span data-ng-show=" grid.appScope.genAppData.serverList.length > 1 " title="' +
						cvLoc('label.deleteServer') +
						'"  class="delete-row" data-ng-click="grid.appScope.deleteServer(row.entity)" > × </span>',
					width: '5%'
				});

				angular.extend(globalGridOptions, {
					data: 'genAppData.serverList',
					columnDefs: columnDefs,
					enableGridMenu: false
				});

				self.serverGridOptions = {
					cvAppScope: self,
					cvIsSearchable: false,
					cvTableName: 'genGenAddServersTable',
					cvOnGridEmpty: {
						message: cvLoc('label.addGenAppSerEmptyMsg')
					},
					gridOptions: globalGridOptions
				};
			};

			self.deleteServer = function(epNode) {
				var clientName = epNode.cvClient.clientName;
				for (var i = 0; i < self.genAppData.serverList.length; i++) {
					if (self.genAppData.serverList[i].cvClient.clientName == clientName) {
						self.genAppData.serverList.splice(i, 1);
						return;
					}
				}
			};

			self.editServer = function(volumeObj) {
				self.addServer(volumeObj);
			};

			self.addServer = function() {
				self.addServer(null);
			};
			self.addServer = function(epNode) {
				var templateUrl = 'modules/genApp/partials/addGenAppServer.jsp';
				var controller = 'addGenAppServerCtrl';
				var opts = new Object();

				var dataObject = {
					epNode: epNode,
					genAppOppType: 'RESTORE',
					clientList: self.clientList,
					serverList: self.serverList
				};

				var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataObject, opts);
				modelInsta.result.then(function(dataObject) {
					if (dataObject) {
						//In Edit case volumeObj will not be null, so remove it and add new one.
						if (epNode) {
							self.deleteServer(epNode);
						}
						//dataObject.nodeType = 'App';
						updateNodeType(dataObject);
						self.selectSourceClient(dataObject);
						self.serverList.push(dataObject);
					}
				});
			};

			//createServersTable();

			var createConfigTable = function() {
				var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
				var columnDefs = [];
				columnDefs.push({
					field: 'tagName',
					displayName: cvLoc('label.tagName'),
					cellTemplate: '<span title="{{row.entity.name}}" >{{row.entity.name}}</span>',
					enableHiding: false,
					cellTooltip: true,
					width: '25%'
				});
				columnDefs.push({
					field: 'tagValue',
					displayName: cvLoc('label.tagValue'),
					cellTemplate: '<span title="{{row.entity.value}}" >{{row.entity.value}}</span>',
					width: '63%'
				});

				columnDefs.push({
					field: 'edit',
					displayName: '',
					cellTemplate:
						'<span title="' +
						cvLoc('label.editTag') +
						'" data-ng-click="grid.appScope.editTag(row.entity)" > <i class="fa fa-pencil"></span>',
					width: '5%'
				});
				columnDefs.push({
					field: 'delete',
					displayName: '',
					cellTemplate:
						'<span title="' +
						cvLoc('label.deleteTag') +
						'"  class="delete-row" data-ng-click="grid.appScope.deleteTag(row.entity)" > × </span>',
					width: '5%'
				});

				angular.extend(globalGridOptions, {
					data: 'genAppData.tags',
					columnDefs: columnDefs,
					enableGridMenu: false
				});

				self.configGridOptions = {
					cvAppScope: self,
					cvIsSearchable: false,
					cvTableName: 'genGenAddServersTable',
					cvOnGridEmpty: {
						message: cvLoc('label.addGenAppTagsEmptyMsg')
					},
					gridOptions: globalGridOptions
				};
			};

			self.deleteTag = function(tagData) {
				var tagName = tagData.name;
				for (var i = 0; i < self.genAppData.tags.length; i++) {
					if (self.genAppData.tags[i].name == tagName) {
						self.genAppData.tags.splice(i, 1);
						return;
					}
				}
			};

			self.editTag = function(volumeObj) {
				self.addTag(volumeObj);
			};

			self.addTag = function() {
				self.addTag(null);
			};
			self.addTag = function(tagData) {
				var templateUrl = 'modules/genApp/partials/addGenAppTagConfig.jsp';
				var controller = 'updateGenAppTagsCtrl';
				var opts = new Object();
				var tagDatas = null;
				if (tagData) {
					tagDatas = [];
					tagDatas.push(tagData);
				}
				var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, tagDatas, opts);
				modelInsta.result.then(function(dataObject) {
					if (dataObject) {
						//In Edit case volumeObj will not be null, so remove it and add new one.
						if (tagData) {
							self.deleteTag(tagData);
						}
						dataObject.forEach(function(entry) {
							self.genAppData.tags.push(entry);
						});
					}
				});
			};

			var loadClientsList = function() {
				clientGroupService
					.getClientsForClientGroup(0)
					.success(function(data) {
						self.serverMessage = cvUtil.emptyMsg();
						if (data.length) {
							var clientList = [];
							/**
							 * Validation method to return true for supporting agent types
							 * only(Ex :- FS and Oracle)
							 */
							var isClientValid = function(clientNode) {
								var returnValue = false;
								if (
									clientNode &&
									clientNode.clientProps &&
									clientNode.client &&
									clientNode.client.idaList &&
									clientNode.client.idaList.length > 0 &&
									!clientNode.clientProps.IsDeletedClient &&
									clientNode.clientProps.clientStatus != 2
								) {
									clientNode.client.idaList.forEach(function(idaInfo) {
										if (
											AppTypesUtil.isFileSystemAgent(idaInfo.idaEntity.applicationId) ||
											idaInfo.idaEntity.applicationId === 22 ||
											idaInfo.idaEntity.applicationId === 81
										) {
											returnValue = true;
											return;
										}
									});
								}
								return returnValue;
							};

							data.forEach(function(entry) {
								if (isClientValid(entry)) {
									clientList.push(entry.client.clientEntity);
								}
							});
							self.clientList = cvUtil.sortAscending(clientList, 'clientName');
							self.genAppData.serverList.forEach(function(entity) {
								self.selectSourceClient(entity);
							});
						}
					})
					.error(function(data) {
						self.serverMessage = cvUtil.errMsgLoc('error.getServers');
					});
			};
			self.clientList = null;
			self.populatClients = function() {
				if (self.clientList == null) {
					if (self.migrationType == 'genApp') {
						self.clientList = self.sourceClientList;
					} else {
						loadClientsList();
					}
				}
			};

			self.showError = function(formController) {
				self.serverListMessage = cvUtil.emptyMsg();
				if (formController.$submitted && (!self.genAppData.serverList || self.genAppData.serverList.length <= 0)) {
					self.serverListMessage = cvUtil.errMsg(cvLoc('error.addServers'));
					return true;
				}
				return false;
			};

			self.initData(self.policyData, self.nodeData, self.migrationType, self.editing);
		};
	}
]);

genAppModule.directive('cvRestoreGenAppComponent', [
	'cvUtil',
	function(cvUtil) {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form'],
			templateUrl: appUtil.appRoot + 'modules/genApp/partials/restoreGenAppTemplate.jsp',
			scope: {},
			bindToController: {
				firewallConfig: '=',
				policyData: '=',
				migrationType: '=',
				nodeData: '=',
				editing: '='
			},
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];
			},
			controllerAs: 'cvRestoreGenAppComp',
			controller: 'restoreGenAppComponentCtrl'
		};
	}
]);
export default genAppModule;
