import 'dlo/js/services/nameServers.svc.js';

import { acAppDirectivesModule } from 'common/js/modules';

//import "common/js/directives/cvDirectives.js"

var directiveModule = acAppDirectivesModule;

directiveModule.controller('firewallOptionsCtrl', [
	'cvUtil',
	'cvLoc',
	'nameServersService',
	function(cvUtil, cvLoc, nameServersService) {
		var self = this;
		this.$onInit = function() {
			self.initData = function() {
				updateValues();
			};

			var updateValues = function() {
				if (!self.firewallConfig) {
					self.firewallConfig = {
						enableFirewallConfig: false,
						firewallConnectionType: 0,
						httpProxyConfigurationType: 0,
						proxyClientName: '',
						portNumber: 8603
					};
				}

				//Loading of the proxy servers list
				nameServersService
					.getActiveProxyList()
					.success(function(data) {
						var proxyClientList = [];
						if (data && data.length > 0) {
							angular.forEach(data, function(clientInfo) {
								if (clientInfo && clientInfo.client) {
									proxyClientList.push(clientInfo.client);
								}
							});
						}
						self.proxyClients = cvUtil.sortAscending(proxyClientList, 'clientName');
						if (self.proxyClients.length > 0) {
							self.firewallConfig.proxyClientName = self.proxyClients[0].clientName;
						}
					})
					.error(function(data) {
						self.proxyClients = [];
						self.nameServerWindowMessage = cvUtil.errMsgLoc('error.failedLoadingServers');
					});

				self.updateTunnerlPortSelection = function(connectionType) {
					var labelString = cvLoc('label.noteFirewallConnectionType2');
					var portNumber = 0;
					if (connectionType == 0) {
						labelString = cvLoc('label.noteFirewallConnectionType0');
						portNumber = 8603;
					} else if (connectionType == 1) {
						labelString = cvLoc('label.noteFirewallConnectionType1');
						portNumber = 8403;
					}
					self.firewallConfig.portNumber = portNumber;
					self.firewallConnetionLabel = labelString;
				};
			};
			updateValues();
		};
	}
]);

directiveModule.directive('cvFirewallOptions', [
	'cvUtil',
	function(cvUtil) {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form'],
			templateUrl: appUtil.appRoot + 'modules/genApp/partials/firewallOptionsTemplate.jsp',
			scope: {},
			bindToController: {
				firewallConfig: '=',
				//For directive to fit in modal
				modalStyle: '@',
				hideConnectionType: '='
			},
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];
			},
			controllerAs: 'cvFirewallOptions',
			controller: 'firewallOptionsCtrl'
		};
	}
]);
export default directiveModule;
