import 'adminConsole/js/services/clientGroups.svc.js';
import 'modules/genApp/js/services/genApp.svc.js';
import 'modules/genApp/js/directives/cvIvhTreeView.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.controller('restoreGenAppSourceServerCtrl', [
	'$scope',
	'cvUtil',
	'AppTypesUtil',
	'clientGroupService',
	'genAppService',
	'data',
	'$uibModalInstance',
	function($scope, cvUtil, AppTypesUtil, clientGroupService, genAppService, data, $modalInstance) {
		$scope.selectedClientList = [];
		$scope.cvClient = null;
		$scope.clientList = data.sourceClientList;

		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.validateClientSelection = function() {
			var isValid = $scope.clientList.some(function(curr) {
				return curr['ticked'] === true;
			});

			$scope.showAddServerErrorMessage = !isValid;
			return isValid;
		};

		$scope.parseIStevenOutput = function() {
			if ($scope.selectedClientList.length) {
				$scope.cvClient = $scope.selectedClientList[0];
			} else {
				$scope.cvClient = undefined;
			}
		};

		$scope.closeModal = function() {
			$modalInstance.close(null);
		};
		$scope.saveServer = function() {
			if ($scope.validateClientSelection()) {
				$modalInstance.close($scope.cvClient);
			}
		};
	}
]);

genAppModule.controller('restoreUpdateGenAppCtrl', [
	'$scope',
	'cvUtil',
	'cvLoc',
	'AppTypesUtil',
	'clientGroupService',
	'genAppService',
	'data',
	'$uibModalInstance',
	function($scope, cvUtil, cvLoc, AppTypesUtil, clientGroupService, genAppService, data, $modalInstance) {
		$scope.selectedClientList = [];
		if (!data.epNode) {
			$scope.isEditing = false;
			$scope.restoreGenAppServer = {
				cvClient: null,
				entitySelectionTree: [],
				selectedEntitiesAsReceived: [],
				treeData: null
			};
		} else {
			$scope.isEditing = true;
			$scope.restoreGenAppServer = angular.copy(data.epNode);
			$scope.sourceClientId = data.sourceClientId;

			$scope.restoreGenAppServer.entitySelectionTree = [];
			$scope.restoreGenAppServer.selectedEntitiesAsReceived = [];
			if (
				$scope.restoreGenAppServer.appContent &&
				$scope.restoreGenAppServer.appContent.length &&
				$scope.restoreGenAppServer.appContent[0]
			) {
				$scope.restoreGenAppServer.appContent.forEach(function(appCont) {
					if (appCont && appCont.subclients) {
						appCont.subclients.forEach(function(subClientNode) {
							subClientNode.subclient.entityTypeName = 'SUBCLIENT_ENTITY';
							$scope.restoreGenAppServer.selectedEntitiesAsReceived.push(subClientNode.subclient);
						});
					}
				});
			}
			$scope.restoreGenAppServer.fsTreeData = null;
			$scope.restoreGenAppServer.oraEntitySelectionTree = [];
			$scope.restoreGenAppServer.oraSelectedEntitiesAsReceived = [];
			if (
				$scope.restoreGenAppServer.dbContent &&
				$scope.restoreGenAppServer.dbContent.length &&
				$scope.restoreGenAppServer.dbContent[0]
			) {
				$scope.restoreGenAppServer.dbContent.forEach(function(dbCont) {
					if (dbCont && dbCont.dbSubclients) {
						dbCont.dbSubclients.forEach(function(subClientNode) {
							subClientNode.subclient.entityTypeName = 'SUBCLIENT_ENTITY';
							$scope.restoreGenAppServer.selectedEntitiesAsReceived.push(subClientNode.subclient);
						});
					}
				});
			}
			$scope.restoreGenAppServer.oraTreeData = null;
		}

		$scope.populatClients = function() {
			if ($scope.clientList == null) {
				clientGroupService
					.getClientsForClientGroup(0)
					.success(function(data) {
						self.serverMessage = cvUtil.emptyMsg();
						if (data.length) {
							var clientList = [];
							data.forEach(function(entry) {
								if (!entry.clientProps.IsDeletedClient && entry.clientProps.clientStatus != 2) {
									clientList.push(entry.client.clientEntity);
								}
							});
							var clientId;
							$scope.clientList = cvUtil.sortAscending(clientList, 'clientName');
							if (!$scope.isEditing) {
								$scope.clientList[0].ticked = true;
								clientId = $scope.clientList[0].clientId;
							} else {
								clientId = $scope.restoreGenAppServer.cvClient.clientId;
								$scope.clientList.forEach(function(client) {
									if (client.clientId == clientId) {
										client.ticked = true;
									}
								});
							}
							//loadTreeData(clientId);
						}
					})
					.error(function(data) {
						self.serverMessage = cvUtil.errMsgLoc('error.getServers');
					});
			}
		};

		var loadTreeData = function(clientId) {
			var genEntity = {
				clientId: clientId
			};
			var parsObject = {
				genericEntity: JSON.stringify(genEntity),
				criteria: 'RestoreEditServer',
				loadChildren: true
			};

			genAppService.getGenAppIvhTreeViewData(parsObject).success(function(entityTree) {
				if (entityTree && entityTree[0]) {
					var treeData = {
						children: entityTree,
						childrenLoaded: true,
						entity: { entityTypeName: 'APPTYPE_ENTITY' },
						id: clientId,
						isNodeSelectable: false,
						label: cvLoc('label.content'),
						selected: false
					};
					$scope.restoreGenAppServer.treeData = treeData;
					$scope.restoreGenAppServer.entitySelectionTree.initTree(
						$scope.restoreGenAppServer.treeData,
						$scope.restoreGenAppServer.selectedEntitiesAsReceived
					);
					$scope.restoreGenAppServer.entitySelectionTree.setGenAppOppType('RESTORE');
					if (data.sourceClientList) {
						$scope.restoreGenAppServer.entitySelectionTree.setSoureceClientList(data.sourceClientList);
					}
				}
			});
		};
		if (
			$scope.restoreGenAppServer &&
			$scope.restoreGenAppServer.srcClient &&
			$scope.restoreGenAppServer.srcClient.clientId
		) {
			loadTreeData($scope.restoreGenAppServer.srcClient.clientId);
		}

		if (data.clientList && data.clientList.length > 0) {
			$scope.clientList = angular.copy(data.clientList);
			$scope.clientList.forEach(function(client) {
				if (client.clientId == $scope.restoreGenAppServer.cvClient.clientId) {
					client.ticked = true;
				} else {
					client.ticked = false;
				}
			});
		} else {
			$scope.populatClients();
		}

		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.validateClientSelection = function() {
			var isValid = $scope.clientList.some(function(curr) {
				return curr['ticked'] === true;
			});

			$scope.showAddServerErrorMessage = !isValid;
			return isValid;
		};

		$scope.parseIStevenOutput = function() {
			if ($scope.selectedClientList.length) {
				$scope.restoreGenAppServer.cvClient = $scope.selectedClientList[0];
			} else {
				$scope.restoreGenAppServer.cvClient = undefined;
			}

			if ($scope.restoreGenAppServer.cvClient) {
				loadTreeData($scope.restoreGenAppServer.cvClient.clientId);
			}
		};

		$scope.closeModal = function() {
			$modalInstance.close(null);
		};
		$scope.saveServer = function() {
			if ($scope.validateClientSelection()) {
				var dbContents = [];
				var dbSubClients = [];

				var appContent = [];
				var appSubClients = [];
				var instanceEntity = null;

				var fsSelectedNodes = $scope.restoreGenAppServer.entitySelectionTree.getSelectedNodes();
				if (fsSelectedNodes) {
					fsSelectedNodes.forEach(function(subclientNode) {
						var contentList = [];
						var subEntity = {
							subclient: subclientNode.entity
						};
						if (AppTypesUtil.isFileSystemAgent(subclientNode.entity.applicationId)) {
							subEntity.content = [
								{
									name: 'SUBCLIENTCONTENT',
									value: subclientNode.label,
									type: 1
								}
							];
							appSubClients.push(subEntity);
						} else {
							instanceEntity = subclientNode.entity;
							subEntity.content = [
								{
									name: 'SUBCLIENTCONTENT',
									value: subclientNode.label,
									type: 7
								}
							];
							dbSubClients.push(subEntity);
						}
					});
					var appCont = {
						subclients: appSubClients
					};
					appContent.push(appCont);
					var dbCont = {
						instance: instanceEntity,
						dbSubclients: dbSubClients
					};
					dbContents.push(dbCont);
				}

				var genAppNode = {
					cvClient: $scope.restoreGenAppServer.cvClient,
					srcClient: $scope.restoreGenAppServer.srcClient,
					dbContent: dbContents,
					appContent: appContent
				};
				$modalInstance.close(genAppNode);
			}
		};
	}
]);

genAppModule.controller('restoreGenAppCtrl', [
	'$dialogs',
	'drCRUDFactory',
	'cvBreadcrumbsTabsFactory',
	'clientGroupService',
	'$log',
	'cvLoc',
	'cvToaster',
	'$uibModal',
	'cvTableOptions',
	'cvUtil',
	'genAppService',
	'$stateParams',
	'$state',
	function(
		$dialogs,
		drCRUDFactory,
		cvBreadcrumbsTabsFactory,
		clientGroupService,
		$log,
		cvLoc,
		cvToaster,
		$modal,
		cvTableOptions,
		cvUtil,
		genAppService,
		$stateParams,
		$state
	) {
		var self = this;
		self.genAppId = $stateParams.genAppId;
		self.editApp = false;
		if (self.genAppId) {
			self.editApp = true;
		}
		var breadCrumbs = [];
		breadCrumbs.push({
			title: cvLoc('header.applications'),
			link: '#genApps'
		});
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		self.genAppData = {};
		self.genAppName = '';
		self.preScriptPath = null;
		self.postScriptPath = null;
		self.postDBScriptPath = null;
		self.serverList = null;
		self.tagList = null;
		self.clientSelectionChanged = function(rowEntity, tarClient) {
			if (rowEntity.dbContent && rowEntity.dbContent.length > 0) {
				rowEntity.dbContent.forEach(function(dbContent) {
					var rstContent = [];
					if (dbContent && dbContent.dbSubclients) {
						dbContent.dbSubclients.forEach(function(dbSubclient) {
							var content = {
								client: rowEntity.srcClient,
								instance: dbContent.instance,
								content: dbSubclient.content
							};
							rstContent.push(content);
						});
						dbContent.rstContent = rstContent;
					}
				});
			}
			if (rowEntity.appContent && rowEntity.appContent.length > 0) {
				rowEntity.appContent.forEach(function(appContent) {
					var rstContent = [];
					if (appContent && appContent.subclients) {
						appContent.subclients.forEach(function(subclients) {
							var content = {
								client: rowEntity.srcClient,
								content: subclients.content
							};
							rstContent.push(content);
						});
						appContent.rstContent = rstContent;
					}
				});
			}
		};
		self.selectSourceClient = function(rowEntity) {
			if (rowEntity && rowEntity.srcClient && rowEntity.srcClient.clientId) {
				self.clientList.forEach(function(clientEntity) {
					if (clientEntity.clientId == rowEntity.srcClient.clientId) {
						rowEntity.cvClient = clientEntity;
					}
				});
			}
		};
		var createServersTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];
			columnDefs.push({
				field: 'SourceServerName',
				displayName: cvLoc('label.srcServerName'),
				cellTemplate: '<span title="{{row.entity.srcClient.clientName}}" >{{row.entity.srcClient.clientName}}</span>',
				enableHiding: false,
				cellTooltip: true,
				width: '25%'
			});

			columnDefs.push({
				field: 'TargetServerName',
				displayName: cvLoc('label.trgServerName'),
				cellTemplate:
					'<div ><select name="clientName" id="clientName" data-ng-options="client as client.clientName for client in grid.appScope.clientList | orderBy:\'clientName\'" ' +
					'	data-ng-model="row.entity.cvClient" data-ng-change="grid.appScope.clientSelectionChanged(row.entity,row.entity.cvClient)" > <option value="">' +
					cvLoc('option.trgServerName') +
					'</option></select></div>',
				enableHiding: false,
				cellTooltip: true,
				width: '25%'
			});

			columnDefs.push({
				field: 'volumeTag',
				displayName: cvLoc('label.serverType'),
				cellTemplate: '<span title="{{row.entity.nodeType}}">{{row.entity.nodeType}}</span>',
				width: '38%'
			});

			columnDefs.push({
				field: 'edit',
				displayName: '',
				cellTemplate:
					'<span title="' +
					cvLoc('label.editServer') +
					'" data-ng-click="grid.appScope.editServer(row.entity)" ><i class="fa fa-pencil"></i></span>',
				width: '5%'
			});
			columnDefs.push({
				field: 'delete',
				displayName: '',
				cellTemplate:
					'<span data-ng-show=" grid.appScope.serverList.length > 1 " title="' +
					cvLoc('label.deleteServer') +
					'"  class="delete-row" data-ng-click="grid.appScope.deleteServer(row.entity)" > × </span>',
				width: '5%'
			});

			angular.extend(globalGridOptions, {
				data: 'serverList',
				columnDefs: columnDefs,
				enableGridMenu: false
			});

			self.serverGridOptions = {
				cvAppScope: self,
				cvIsSearchable: false,
				cvTableName: 'genGenAddServersTable',
				cvOnGridEmpty: {
					message: cvLoc('label.addGenAppSerEmptyMsg')
				},
				gridOptions: globalGridOptions
			};
		};

		self.deleteServer = function(epNode) {
			var clientName = epNode.cvClient.clientName;
			for (var i = 0; i < self.serverList.length; i++) {
				if (self.serverList[i].cvClient.clientName == clientName) {
					self.serverList.splice(i, 1);
					return;
				}
			}
		};

		self.editServer = function(volumeObj) {
			self.addServer(volumeObj);
		};

		self.addServer = function() {
			self.addServer(null);
		};
		self.addServer = function(epNode) {
			var templateUrl = 'modules/genApp/partials/addGenAppServer.jsp';
			var controller = 'addGenAppServerCtrl';
			var opts = new Object();

			var dataObject = {
				epNode: epNode,
				genAppOppType: 'RESTORE',
				clientList: self.clientList,
				serverList: self.serverList
			};

			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataObject, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					//In Edit case volumeObj will not be null, so remove it and add new one.
					if (epNode) {
						self.deleteServer(epNode);
					}
					//dataObject.nodeType = 'App';
					updateNodeType(dataObject);
					self.selectSourceClient(dataObject);
					self.serverList.push(dataObject);
				}
			});
		};

		createServersTable();

		var createConfigTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];
			columnDefs.push({
				field: 'tagName',
				displayName: cvLoc('label.tagName'),
				cellTemplate: '<span title="{{row.entity.name}}" >{{row.entity.name}}</span>',
				enableHiding: false,
				cellTooltip: true,
				width: '25%'
			});
			columnDefs.push({
				field: 'tagValue',
				displayName: cvLoc('label.tagValue'),
				cellTemplate: '<span title="{{row.entity.value}}" >{{row.entity.value}}</span>',
				width: '63%'
			});

			columnDefs.push({
				field: 'edit',
				displayName: '',
				cellTemplate:
					'<span title="' +
					cvLoc('label.editTag') +
					'" data-ng-click="grid.appScope.editTag(row.entity)" > <i class="fa fa-pencil"></span>',
				width: '5%'
			});
			columnDefs.push({
				field: 'delete',
				displayName: '',
				cellTemplate:
					'<span title="' +
					cvLoc('label.deleteTag') +
					'"  class="delete-row" data-ng-click="grid.appScope.deleteTag(row.entity)" > × </span>',
				width: '5%'
			});

			angular.extend(globalGridOptions, {
				data: 'tagList',
				columnDefs: columnDefs,
				enableGridMenu: false
			});

			self.configGridOptions = {
				cvAppScope: self,
				cvIsSearchable: false,
				cvTableName: 'genGenAddServersTable',
				cvOnGridEmpty: {
					message: cvLoc('label.addGenAppTagsEmptyMsg')
				},
				gridOptions: globalGridOptions
			};
		};

		self.deleteTag = function(tagData) {
			var tagName = tagData.name;
			for (var i = 0; i < self.tagList.length; i++) {
				if (self.tagList[i].name == tagName) {
					self.tagList.splice(i, 1);
					return;
				}
			}
		};

		self.editTag = function(volumeObj) {
			self.addTag(volumeObj);
		};

		self.addTag = function() {
			self.addTag(null);
		};
		self.addTag = function(tagData) {
			var templateUrl = 'modules/genApp/partials/addGenAppTagConfig.jsp';
			var controller = 'updateGenAppTagsCtrl';
			var opts = new Object();

			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, tagData, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					//In Edit case volumeObj will not be null, so remove it and add new one.
					if (tagData) {
						self.deleteTag(tagData);
					}
					dataObject.forEach(function(entry) {
						self.tagList.push(entry);
					});
				}
			});
		};

		createConfigTable();
		self.tagList = [];

		self.clientList = null;
		self.populatClients = function() {
			if (self.clientList == null) {
				clientGroupService
					.getClientsForClientGroup(0)
					.success(function(data) {
						self.serverMessage = cvUtil.emptyMsg();
						if (data.length) {
							var clientList = [];
							data.forEach(function(entry) {
								if (!entry.clientProps.IsDeletedClient && entry.clientProps.clientStatus != 2) {
									clientList.push(entry.client.clientEntity);
								}
							});
							self.clientList = cvUtil.sortAscending(clientList, 'clientName');
							self.serverList.forEach(function(entity) {
								self.selectSourceClient(entity);
							});
						}
					})
					.error(function(data) {
						self.serverMessage = cvUtil.errMsgLoc('error.getServers');
					});
			}
		};
		self.populatClients();

		var updateNodeType = function(genAppNode) {
			var nodeType = cvLoc('nodeType.app');
			if (genAppNode && genAppNode.appContent && genAppNode.dbContent && genAppNode.dbContent[0].dbSubclients) {
				nodeType = cvLoc('nodeType.appDB');
			} else if (genAppNode && genAppNode.dbContent && genAppNode.dbContent[0].dbSubclients) {
				nodeType = cvLoc('nodeType.db');
			}
			genAppNode.nodeType = nodeType;
		};
		self.loadAppDetails = function(genAppId) {
			self.sourceClientList = [];
			drCRUDFactory.getFailoverGroupDetails(genAppId).then(function() {
				self.serverMessage = cvUtil.emptyMsg();
				self.genAppDetails = drCRUDFactory.failoverGroupDetails.genericApp;
				if (self.genAppDetails) {
					self.genAppName = self.genAppDetails.name;
					self.serverList = self.genAppDetails.enterpriseNodes;
					if (self.serverList) {
						self.serverList.forEach(function(entity) {
							entity.srcClient = entity.cvClient;
							self.sourceClientList.push(entity.cvClient);
							updateNodeType(entity);
						});
					} else {
						self.serverList = [];
					}
					self.tagList = self.genAppDetails.tags;
					if (!self.tagList) {
						self.tagList = [];
					}
				} else {
					self.serverList = [];
					self.tagList = [];
				}
			});
		};
		if (self.editApp) {
			self.loadAppDetails(self.genAppId);
		} else {
			self.serverList = [];
			self.tagList = [];
		}

		var restoreGenAppNode = function() {
			if (self.serverList) {
				self.serverList.forEach(function(entity) {
					self.clientSelectionChanged(entity, null);
				});
			}
			var genAppDataModel = {
				enterpriseNodes: self.serverList,
				tags: self.tagList,
				name: self.genAppName,
				ID: self.genAppId,
				appType: 3
			};
			genAppDataModel.config = [];
			if (self.preScriptPath) {
				var metaData = {
					type: 12,
					name: 'PRERSTSCRIPTPATH',
					value: self.preScriptPath
				};
				genAppDataModel.config.push(metaData);
			}
			if (self.postScriptPath) {
				var metaData = {
					type: 13,
					name: 'POSTRESTORESCRIPTPATH',
					value: self.postScriptPath
				};
				genAppDataModel.config.push(metaData);
			}
			if (self.postDBScriptPath) {
				genAppDataModel.config.push({
					type: 13,
					name: 'POSTDBRSTSCRIPTPATH',
					value: self.postDBScriptPath
				});
			}
			var parms = {
				operationType: 'RESTORE',
				operationJSON: JSON.stringify(genAppDataModel)
			};
			genAppService
				.genAppOperations(parms)
				.success(function(data) {
					if (data) {
						var msg = cvLoc('notification.restoreRequested', data);
						var viewMsg = cvLoc('notification.viewJobs');
						cvToaster.showInfoMessage({
							ttl: '10000', //10 sec
							message: msg + ' <br><a href="#/jobs/' + data + '">' + viewMsg + '</a>'
						});
						$state.go('genApps');
					}
				})
				.error(function(errorMessage) {
					cvToaster.showErrorMessage({
						message: errorMessage
					});
				});
		};

		var validateServers = function() {
			return true;
		};
		self.saveGenApp = function() {
			if (!validateServers()) {
				self.serverMessage = {
					message: cvLoc('error.cvClientMapping'),
					type: 'error'
				};
				return;
			}
			restoreGenAppNode();
		};
	}
]);

export default genAppModule;
