import 'modules/ida/js/services/appMigration.svc.js';
import 'modules/genApp/js/services/genApp.svc.js';
import 'modules/genApp/js/directives/cv-compute-node.js';
import 'modules/genApp/js/directives/cv-restore-gen-app-component.js';
import 'modules/genApp/js/directives/cv-firewall-options.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.controller('migrateGenAppCtrl', [
	'cvLoc',
	'cvUtil',
	'$stateParams',
	'$state',
	'cvToaster',
	'$uibModal',
	'$dialogs',
	'drCRUDFactory',
	'appMigrationService',
	'cvTableOptions',
	'cvBreadcrumbsTabsFactory',
	'genAppService',
	function(
		cvLoc,
		cvUtil,
		$stateParams,
		$state,
		cvToaster,
		$modal,
		$dialogs,
		drCRUDFactory,
		appMigrationService,
		cvTableOptions,
		cvBreadcrumbsTabsFactory,
		genAppService
	) {
		var self = this;
		var genAppId = $stateParams.genAppId;
		cvBreadcrumbsTabsFactory.addBreadCrumbs({
			title: cvLoc('header.applications'),
			link: '#genApps'
		});

		self.title = cvLoc('pageHeader.migrateToCloud');
		self.clientList = [];
		self.data = {
			policyId: 0,
			cloudType: 'AMAZON',
			firewallConfig: {
				enableFirewallConfig: false,
				firewallConnectionType: 0,
				httpProxyConfigurationType: 0,
				proxyClientName: '',
				portNumber: 8603
			},
			preScript: {},
			postScript: {
				client: {}
			},
			preRegistore: false,
			copyPrec: 0,
			copyPreceDencSect: false
		};
		var clientPreFix = 'Target - ';

		self.computeStorage = function(genAppNode) {
			var storageSize = 0;
			if (genAppNode && genAppNode.machineConfig && genAppNode.machineConfig.storageVol_list) {
				genAppNode.machineConfig.storageVol_list.forEach(function(storage) {
					if (storage.volumeSize) {
						storageSize = storageSize + storage.volumeSize;
					}
				});
			}
			genAppNode.storageSize = storageSize;
		};

		var getGenAppDetails = function(genAppId) {
			drCRUDFactory.getFailoverGroupDetails(genAppId).then(function() {
				self.serverMessage = cvUtil.emptyMsg();
				self.genAppDetails = drCRUDFactory.failoverGroupDetails.genericApp;
				self.migrationType = 'genApp';
				self.isEditing = true;
				if (self.genAppDetails) {
					self.computeNodeList = self.genAppDetails.enterpriseNodes;
					self.computeNodeList.forEach(function(entity) {
						entity.srcClient = angular.copy(entity.cvClient);
						entity.cvClient = {
							clientName: clientPreFix + entity.srcClient.clientName
						};
						self.clientList.push(entity.cvClient);
						self.computeStorage(entity);
					});
				} else {
					self.computeNodeList = [];
				}
			});
		};
		getGenAppDetails(genAppId);

		var computeNodeValidation = function() {
			var valideData = false;
			var storageInvalid = true;
			var templateInvalid = true;
			angular.forEach(self.computeNodeList, function(computeNode) {
				if (self.data.preRegistore) {
					var serverLable = cvLoc('label.selectServer');
					if (!computeNode || !computeNode.hostName || computeNode.hostName === serverLable) {
						templateInvalid = false;
					}
				} else {
					if (!computeNode.machineConfig || !computeNode.machineConfig.storageVol_list) {
						storageInvalid = false;
					}

					if (
						!computeNode.machineConfig ||
						!computeNode.machineConfig.vmInstType ||
						!computeNode.machineConfig.vmInstType.instanceType ||
						!computeNode.machineConfig ||
						!computeNode.machineConfig.vmTemplate ||
						!computeNode.machineConfig.vmTemplate.vm
					) {
						templateInvalid = false;
					}
				}
			});

			if (!templateInvalid || !storageInvalid) {
				return cvLoc('error.computeNodeValues');
			}
		};

		var sourceNodeValidation = function() {
			angular.forEach(self.computeNodeList, function(nodeEntry) {
				if (self.data.destEBSAppName) {
					if (self.data.preRegistore) {
						nodeEntry.hostName = cvLoc('label.selectServer');
					} else {
						nodeEntry.hostName = self.data.destEBSAppName + '-' + nodeEntry.nodeName;
					}
				}
			});
			loadPolicy(self.data.policyId.entity.vmAllocPolicyId);
		};

		var restoreOptionsValidation = function() {};

		var cloudAccountPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/genApp/partials/migrateGenAppCloudAccountPage.jsp',
			name: 'Cloud account details',
			validateMethod: sourceNodeValidation
		};

		var computeNodePage = {
			completed: false,
			template: appUtil.appRoot + 'modules/genApp/partials/migrateGenAppComputeNodePage.jsp',
			name: cvLoc('label.cloudCompute'),
			validateMethod: computeNodeValidation
		};

		var restoreOptionsPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/genApp/partials/migrateGenAppRestoreOptionsPage.jsp',
			name: 'Restore options',
			validateMethod: restoreOptionsValidation
		};

		var firewallOptionsPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/genApp/partials/migrateGenAppFirewallOptionsPage.jsp',
			name: cvLoc('label.firewallConfg')
		};
		var steps = [];

		steps.push(cloudAccountPage);
		steps.push(computeNodePage);
		steps.push(restoreOptionsPage);
		steps.push(firewallOptionsPage);

		self.steps = steps;

		var cloudTypes = [];
		cloudTypes.push({
			name: cvLoc('label.amazon'),
			cloudId: 'AMAZON'
		});
		cloudTypes.push({
			name: cvLoc('label.oralceCloud'),
			cloudId: 'ORACLE_CLOUD'
		});

		cloudTypes.push({
			name: cvLoc('label.oracleCI'),
			cloudId: 'ORACLE_CLOUD_INFRASTRUCTURE'
		});

		self.cloudTypes = cloudTypes;

		self.policyList = [];
		var loadPolicies = function() {
			//load Policies
			appMigrationService
				.getPolicies({
					vender: 'vender'
				})
				.success(function(data) {
					if (data.length > 0) {
						self.policyData = data;
						self.cloudTypechange('AMAZON');
					}
				})
				.error(function(e) {
					self.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		loadPolicies();

		self.selectSourceClient = function(rowEntity) {
			if (rowEntity && rowEntity.srcClient && rowEntity.srcClient.clientName) {
				self.clientList.forEach(function(clientEntity) {
					if (clientEntity.clientName == clientPreFix + rowEntity.srcClient.clientName) {
						rowEntity.cvClient = clientEntity;
					}
				});
			}
		};

		self.updateTunnerlPortSelection = function(connectionType) {
			var labelString = cvLoc('label.noteFirewallConnectionType2');
			var portNumber = 0;
			if (connectionType == 0) {
				labelString = cvLoc('label.noteFirewallConnectionType0');
				portNumber = 8603;
			} else if (connectionType == 1) {
				labelString = cvLoc('label.noteFirewallConnectionType1');
				portNumber = 8403;
			}
			self.data.firewallConfig.portNumber = portNumber;
			self.firewallConnetionLabel = labelString;
		};

		self.cloudTypechange = function(cloudType) {
			var policyList = [];
			angular.forEach(self.policyData, function(policy) {
				if (policy.entity.policyType == cloudType) {
					policyList.push(policy);
				}
			});
			self.policyList = policyList;
			if (self.policyList.length > 0) {
				self.data.policyId = self.policyList[0];
			}
		};

		var loadPolicy = function(policyId) {
			appMigrationService
				.getPolicyDetails({
					policyId: policyId
				})
				.success(function(data) {
					self.vmsTempList = [];
					self.instanceTypeList = [];
					if (data) {
						var vmTeplPolicy = data;
						self.vmTeplPolicy = vmTeplPolicy;
						if (vmTeplPolicy.templates && vmTeplPolicy.templates.length > 0) {
							var temps = vmTeplPolicy.templates;
							self.vmsTempList = cvUtil.sortAscending(temps, 'vmName');
						}

						if (
							vmTeplPolicy.amazonPolicy &&
							vmTeplPolicy.amazonPolicy.instanceType &&
							vmTeplPolicy.amazonPolicy.instanceType.length > 0
						) {
							var instanceTypeList = vmTeplPolicy.amazonPolicy.instanceType;
							self.instanceTypeList = cvUtil.sortAscending(instanceTypeList, 'instanceType.vmInstanceTypeName');
						}
					}

					var defaultTemp = null;
					if (self.vmsTempList && self.vmsTempList.length > 0) {
						defaultTemp = self.vmsTempList[0];
					}

					var defaultInstanceType = null;
					if (self.instanceTypeList && self.instanceTypeList.length > 0) {
						defaultInstanceType = self.instanceTypeList[0];
					}

					angular.forEach(self.computeNodeList, function(nodeEntry) {
						if (!nodeEntry.machineConfig) {
							nodeEntry.machineConfig = {};
						}
						if (defaultTemp && nodeEntry.machineConfig) {
							if (!nodeEntry.machineConfig.vmTemplate) {
								nodeEntry.machineConfig.vmTemplate = {
									vm: defaultTemp
								};
							}
						}
						if (defaultInstanceType && nodeEntry.machineConfig) {
							if (!nodeEntry.machineConfig.vmInstType) {
								nodeEntry.machineConfig.vmInstType = defaultInstanceType;
							}
						}
					});
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		self.addComputeNode = function(sourceEBSComputNode) {
			var templateUrl = 'ebs/partials/addEBSComputeNode.jsp';
			var controller = [
				'$scope',
				'cvUtil',
				'$rootScope',
				'$uibModalInstance',
				'data',
				function($scope, cvUtil, $rootScope, $modalInstance, data) {
					$scope.nodeData = data.nodeData;
					self.migrationType = 'genApp';
					$scope.vmTeplPolicy = data.vmTeplPolicy;
					$scope.isEditing = false;
					if ($scope.nodeData) {
						$scope.isEditing = true;
					} else {
						$scope.nodeData = {
							noOfNodes: 1,
							database: true,
							machineConfig: {
								storageVol_list: [],
								vmTemplate: {
									vm: ''
								}
							}
						};
					}

					$scope.cancelModel = function() {
						$modalInstance.close(null);
					};
					$scope.saveModel = function() {
						if ($scope.preRegistore && $scope.nodeData.cvClient) {
							$scope.nodeData.hostName = $scope.nodeData.cvClient.clientName;
						}
						$modalInstance.close($scope.nodeData);
					};
				}
			];
			var opts = new Object();
			var dataNode = null;
			if (sourceEBSComputNode) {
				dataNode = angular.copy(sourceEBSComputNode);
				dataNode.hostName = dataNode.cvClient.clientName;
			}

			var dataResolve = function() {
				return {
					nodeData: dataNode,
					clientList: self.clientList,
					vmTeplPolicy: self.vmTeplPolicy,
					cloudType: self.data.cloudType
				};
			};
			var modalData = {
				controller: controller,
				controllerAs: 'addNode',
				backdrop: 'static',
				templateUrl: appUtil.appRoot + templateUrl
			};
			modalData.resolve = {
				data: dataResolve
			};

			var modelInsta = $modal.open(modalData);
			modelInsta.result.then(function(genAppNode) {
				if (!genAppNode) {
					//on pressing cancel button ebsnodeData will be null
					return;
				}

				if (sourceEBSComputNode) {
					//In edit case
					var index = self.computeNodeList.indexOf(sourceEBSComputNode);
					if (index > -1) {
						self.computeNodeList.splice(index, 1);
					}
				}
				var nodeType = '';
				self.computeStorage(genAppNode);

				var addNode = function(genAppNode) {
					if (!genAppNode.cvClient) {
						genAppNode.cvClient = {};
					}
					genAppNode.cvClient.clientName = genAppNode.hostName;
					self.computeNodeList.push(genAppNode);
				};
				if (genAppNode.database && genAppNode.application) {
					var appNode = angular.copy(genAppNode);
					addNode(ebsComputeNode);
					appNode.database = false;
					appNode.hostName = appNode.hostName + 'AppNode';
					addNode(appNode);
				} else {
					addNode(genAppNode);
				}
			});
		};

		self.deleteComputeNode = function(ebsComputName) {
			if (ebsComputName) {
				var index = self.computeNodeList.indexOf(ebsComputName);
				if (index > -1) {
					self.computeNodeList.splice(index, 1);
				}
			}
		};

		self.postScriptResuleFunction = function(result) {
			if (result && result.path) {
				self.data.postScript.scriptPath = result.path;
			}
		};

		self.preScriptResuleFunction = function(result) {
			if (result && result.path) {
				self.data.preScript.scriptPath = result.path;
			}
		};

		var computeNodeTable = function() {
			var columnDefs = [];

			var nodeNameLabel = cvLoc('label.nodeName');
			var nodeTypeSize = '20%';

			columnDefs.push({
				field: 'hostName',
				displayName: nodeNameLabel,
				cellTemplate: '<div class="crop" >{{row.entity.cvClient.clientName}}</div>',
				sort: {
					direction: 'asc',
					priority: 0
				},
				width: '35%',
				enableHiding: false,
				cellTooltip: true
			});

			columnDefs.push({
				field: 'instanceType',
				width: '35%',
				displayName: cvLoc('label.instanceType'),
				cellTemplate:
					'<div class="crop" title="{{row.entity.machineConfig.vmInstType.instanceType.vmInstanceTypeName}}">{{row.entity.machineConfig.vmInstType.instanceType.vmInstanceTypeName}}</div>'
			});
			columnDefs.push({
				field: 'storageSize',
				displayName: cvLoc('label.storageSizeGB'),
				width: '20%',
				cellTemplate: '<div class="crop" >{{row.entity.storageSize | volumeSize}}</div>'
			});

			columnDefs.push({
				field: 'edit',
				displayName: '',
				cellTemplate:
					'<span title="Edit volume"  class="edit-volume" data-ng-click="grid.appScope.addComputeNode(row.entity)" >&nbsp;</span>',
				width: '5%'
			});
			columnDefs.push({
				field: 'delete',
				displayName: '',
				cellTemplate:
					'<span title="Delete volume"  class="delete-row" data-ng-click="grid.appScope.deleteComputeNode(row.entity)" > x </span>',
				width: '5%'
			});

			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			angular.extend(globalGridOptions, {
				data: 'computeNodeList',
				enableGridMenu: false,
				paginationPageSize: 5,
				paginationPageSizes: [5, 10, 20, 50],
				columnDefs: columnDefs
			});

			self.computeNodeGridOptions = {
				cvHasTitle: true,
				cvTableName: 'computeNodeTable',
				cvPageLinks: [
					{
						label: cvLoc('label.addComputNode'),
						id: 'tour_add_dbServer',
						onclick: self.addComputeNode
					}
				],
				cvIsSearchable: false,
				cvHasViews: false,
				cvAppScope: self,
				gridOptions: globalGridOptions
			};
		};

		computeNodeTable();

		self.updateRestoreContent = function(rowEntity) {
			if (rowEntity.dbContent && rowEntity.dbContent.length > 0) {
				rowEntity.dbContent.forEach(function(dbContent) {
					var rstContent = [];
					if (dbContent && dbContent.dbSubclients) {
						dbContent.dbSubclients.forEach(function(dbSubclient) {
							var content = {
								client: rowEntity.srcClient,
								instance: dbContent.instance,
								content: dbSubclient.content
							};
							rstContent.push(content);
						});
					}
					dbContent.rstContent = rstContent;
				});
			}
			if (rowEntity.appContent && rowEntity.appContent.length > 0) {
				rowEntity.appContent.forEach(function(appContent) {
					var rstContent = [];
					if (appContent && appContent.subclients) {
						appContent.subclients.forEach(function(subclients) {
							var content = {
								client: rowEntity.srcClient,
								content: subclients.content
							};
							rstContent.push(content);
						});
					}
					appContent.rstContent = rstContent;
				});
			}
		};

		self.submitJob = function() {
			var appMgrconfig = {
				cloudAllocationPolicy: self.data.policyId,
				cloudType: self.data.cloudType
			};

			var job = {
				options: {
					restoreOptions: {}
				},
				pattern: {}
			};

			self.genAppDetails.serverList.forEach(function(serverNode) {
				self.updateRestoreContent(serverNode);
			});
			var genAppDataModel = {
				enterpriseNodes: self.genAppDetails.serverList,
				tags: self.genAppDetails.tagList,
				name: self.genAppDetails.genAppName,
				appType: 3
			};
			genAppDataModel.config = [];
			if (self.genAppDetails.preScriptPath) {
				var metaData = {
					type: 12,
					name: 'PRERSTSCRIPTPATH',
					value: self.genAppDetails.preScriptPath
				};
				genAppDataModel.config.push(metaData);
			}
			if (self.genAppDetails.postScriptPath) {
				var metaData = {
					type: 13,
					name: 'POSTRESTORESCRIPTPATH',
					value: self.genAppDetails.postScriptPath
				};
				genAppDataModel.config.push(metaData);
			}
			if (self.genAppDetails.postDBScriptPath) {
				genAppDataModel.config.push({
					type: 13,
					name: 'POSTDBRSTSCRIPTPATH',
					value: self.genAppDetails.postDBScriptPath
				});
			}
			appMgrconfig.genericAppRstTask = {
				targetInst: genAppDataModel,
				sourceID: genAppId
			};
			var parms = {
				operationType: 'MIGRATE',
				operationJSON: JSON.stringify(appMgrconfig),
				firewallConfig: JSON.stringify(self.data.firewallConfig)
			};
			genAppService
				.genAppOperations(parms)
				.success(function(successData) {
					if (successData) {
						var jobUrl = '#/jobs/' + successData;
						var responseContent =
							' <a href="' + jobUrl + '">' + cvLoc('label.redirectMsg') + ' ' + successData + '</a>';
						cvToaster.showSuccessMessage({
							ttl: '15000',
							message: responseContent
						});
						$state.go('genApps');
					}
				})
				.error(function(errorReason) {
					self.serverMessage = {
						message: errorReason,
						type: 'error'
					};
				});
		};
	}
]);

export default genAppModule;
