import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/genApp/js/services/genApp.svc.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.controller('genAppNodeContentCtrl', [
	'$dialogs',
	'cvBreadcrumbsTabsFactory',
	'drCRUDFactory',
	'cvLoc',
	'cvToaster',
	'$uibModal',
	'cvTableOptions',
	'cvUtil',
	'genAppService',
	'$stateParams',
	'$state',
	function(
		$dialogs,
		cvBreadcrumbsTabsFactory,
		drCRUDFactory,
		cvLoc,
		cvToaster,
		$modal,
		cvTableOptions,
		cvUtil,
		genAppService,
		$stateParams,
		$state
	) {
		var self = this;
		self.genAppId = $stateParams.genAppId;
		self.clientId = $stateParams.clientId;
		self.genAppNode = null;
		self.genAppDBContent = null;
		self.genAppFSContent = null;

		var breadCrumbs = [];
		breadCrumbs.push({
			title: cvLoc('header.applications'),
			link: '#genApps'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		var loadGenAppNodeContent = function() {
			drCRUDFactory.getFailoverGroupDetails(self.genAppId).then(function() {
				self.serverMessage = cvUtil.emptyMsg();
				self.genAppDetails = drCRUDFactory.failoverGroupDetails.genericApp;
				if (self.genAppDetails) {
					cvBreadcrumbsTabsFactory.addBreadCrumbs({
						title: self.genAppDetails.name,
						link: '#genAppDetails/' + self.genAppId
					});
					self.genAppDetails.enterpriseNodes.forEach(function(epNode) {
						if (epNode.cvClient.clientId == self.clientId) {
							self.genAppNode = epNode;
						}
					});
					if (self.genAppNode) {
						if (self.genAppNode.dbContent && self.genAppNode.dbContent[0].dbSubclients) {
							self.genAppDBContent = self.genAppNode.dbContent[0].dbSubclients[0].content;
							self.dbAgentName = self.genAppNode.dbContent[0].dbSubclients[0].subclient.appName;
						}
						if (self.genAppNode.appContent && self.genAppNode.appContent[0].subclients) {
							self.genAppFSContent = self.genAppNode.appContent[0].subclients[0].content;
							self.fsAgentName = self.genAppNode.dbContent[0].dbSubclients[0].subclient.appName;
						}
					}
				}
			});
		};
		loadGenAppNodeContent();
	}
]);

export default genAppModule;
