import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';
import 'modules/genApp/js/services/genApp.svc.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.controller('genAppsCtrl', [
	'$dialogs',
	'failoverService',
	'cvLoc',
	'cvToaster',
	'cvTableOptions',
	'cvUtil',
	'genAppService',
	'$state',
	function($dialogs, failoverService, cvLoc, cvToaster, cvTableOptions, cvUtil, genAppService, $state) {
		var self = this;
		self.genAppsList = null;
		self.loadGenAppList = function() {
			self.genAppsList = null;
			self.serverMessage = cvUtil.infoMsgLoc('Loading');
			genAppService
				.getGenApps()
				.success(function(data) {
					self.genAppsList = data;
					self.genAppsList.forEach(function(entry) {
						if (entry && entry.genericApp && entry.genericApp.enterpriseNodes) {
							entry.nodeCount = entry.genericApp.enterpriseNodes.length;
						}
					});
					self.serverMessage = cvUtil.emptyMsg();
				})
				.error(function(errorMessage) {
					self.serverMessage = {
						message: errorMessage,
						type: 'error'
					};
				});
		};

		self.loadGenAppList();

		self.openGenAppPage = function() {
			$state.go('addGenApp');
		};

		self.backupGenApp = function(genAppId) {
			var parms = {
				operationType: 'BACKUP',
				operationJSON: genAppId
			};
			genAppService
				.genAppOperations(parms)
				.success(function(data) {
					if (data) {
						var msg = cvLoc('notification.backupRequested', data);
						var viewMsg = cvLoc('notification.viewJobs');
						cvToaster.showInfoMessage({
							ttl: '10000', //10 sec
							message: msg + ' <br><a href="#/jobs/' + data + '">' + viewMsg + '</a>'
						});
					}
				})
				.error(function(errorMessage) {
					cvToaster.showErrorMessage({
						message: errorMessage
					});
				});
		};
		self.deleteGenApp = function(vApp) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					var vAppId = vApp.vAppEntity.vAppId;
					if (!vAppId) return;

					failoverService
						.deleteFailoverGroup(JSON.stringify(vAppId))
						.success(function(data) {
							cvToaster.showSuccessMessage({
								ttl: '15000',
								message: cvLoc('label.genAppDeleted')
							});
							self.loadGenAppList();
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: '15000',
								message: e ? e : cvLoc('generic_error')
							});
						});
				}
			};

			$dialogs.confirm(
				cvLoc('label.deleteGenApp'),
				cvLoc('label.deleteGenAppConfirmation', '<b>' + vApp.vAppEntity.vAppName + '</b>'),
				callBackFunctions
			);
		};

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'genAppsList',
			columnDefs: [
				{
					field: 'vAppName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false,
					cellTooltip: true,
					displayName: cvLoc('label.appName'),
					cellTemplate:
						'<a class="crop" href="#/genAppDetails/{{row.entity.vAppEntity.vAppId}}">{{row.entity.vAppEntity.vAppName}}</a>'
				},
				{
					field: 'nodeCount',
					displayName: cvLoc('label.noOfNodes'),
					cellTemplate: '<span>{{row.entity.nodeCount}}</span>'
				},
				{
					field: 'restoreGenApp',
					displayName: cvLoc('header.restore'),
					cellTemplate: '<a href="#/restoreGenApp/{{row.entity.vAppEntity.vAppId}}">' + cvLoc('header.restore') + '</a>'
				},
				{
					field: 'actions',
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false,
					cellTooltip: true,
					displayName: cvLoc('header.actions'),
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
						'<li><a href="#/addGenApp?genAppId={{row.entity.vAppEntity.vAppId}}">' +
						cvLoc('label.edit') +
						'</a></li>' +
						'<li><a data-ng-click="grid.appScope.backupGenApp(row.entity.vAppEntity.vAppId)">' +
						cvLoc('action.backup') +
						'</a></li>' +
						'<li><a href="#/migrateGenApp/{{row.entity.vAppEntity.vAppId}}">' +
						cvLoc('pageHeader.migrateToCloud') +
						'</a></li>' +
						'<li><a data-ng-click="grid.appScope.deleteGenApp(row.entity)">' +
						cvLoc('Delete') +
						'</a></li>' +
						'</ul></div>',
					width: '20%'
				}
			]
		});

		var cvPageLinks = [
			{
				label: cvLoc('label.addNewApp'),
				id: 'tour_add_GenApps',
				onclick: self.openGenAppPage
			}
		];

		self.gridOptions = {
			cvPageLinks: cvPageLinks,
			cvGridTitle: cvLoc('header.applications'),
			cvIsPageTitle: true,
			cvAppScope: self,
			cvTableName: 'genAppsTable',
			cvSearchFields: ['vAppEntity.vAppName'],
			cvOnGridEmpty: {
				message: cvLoc('label.genAppsemptyMsg')
			},
			gridOptions: globalGridOptions
		};

		self.gridOptions.cvOnGridEmpty.links = cvPageLinks;
	}
]);

export default genAppModule;
