import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/genApp/js/services/genApp.svc.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.controller('addGenDetailsCtrl', [
	'$dialogs',
	'drCRUDFactory',
	'failoverService',
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'cvToaster',
	'$uibModal',
	'cvTableOptions',
	'cvUtil',
	'genAppService',
	'$stateParams',
	'$state',
	function(
		$dialogs,
		drCRUDFactory,
		failoverService,
		cvBreadcrumbsTabsFactory,
		cvLoc,
		cvToaster,
		$modal,
		cvTableOptions,
		cvUtil,
		genAppService,
		$stateParams,
		$state
	) {
		var genAppId = $stateParams.genAppId;
		var self = this;
		self.genAppId = genAppId;
		var breadCrumbs = [];
		breadCrumbs.push({
			title: cvLoc('header.applications'),
			link: '#genApps'
		});
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		var updateNodeType = function(genAppNode) {
			var nodeType = cvLoc('nodeType.app');
			if (
				genAppNode &&
				genAppNode.appContent &&
				genAppNode.dbContent &&
				genAppNode.dbContent[0].dbSubclients &&
				genAppNode.dbContent[0].dbSubclients.length > 0
			) {
				nodeType = cvLoc('nodeType.appDB');
			} else if (
				genAppNode &&
				genAppNode.dbContent &&
				genAppNode.dbContent[0].dbSubclients &&
				genAppNode.dbContent[0].dbSubclients.length > 0
			) {
				nodeType = cvLoc('nodeType.db');
			}
			genAppNode.nodeType = nodeType;
		};
		var loadGenAppDetails = function() {
			drCRUDFactory.getFailoverGroupDetails(genAppId).then(function() {
				self.serverMessage = cvUtil.emptyMsg();
				self.genAppDetails = drCRUDFactory.failoverGroupDetails.genericApp;
				self.genAppName = self.genAppDetails.name;
				self.serverList = self.genAppDetails.enterpriseNodes;
				if (self.serverList) {
					self.serverList.forEach(function(entry) {
						updateNodeType(entry);
					});
				} else {
					self.serverList = [];
				}
				self.tagList = self.genAppDetails.tags;
				if (!self.tagList) {
					self.tagList = [];
				}
			});
		};
		loadGenAppDetails();

		self.backupGenApp = function(genAppId) {
			var parms = {
				operationType: 'BACKUP',
				operationJSON: genAppId
			};
			genAppService
				.genAppOperations(parms)
				.success(function(data) {
					if (data) {
						var msg = cvLoc('notification.backupRequested', data);
						var viewMsg = cvLoc('notification.viewJobs');
						cvToaster.showInfoMessage({
							ttl: '10000', //10 sec
							message: msg + ' <br><a href="#/jobs/' + data + '">' + viewMsg + '</a>'
						});
					}
				})
				.error(function(errorMessage) {
					cvToaster.showErrorMessage({
						message: errorMessage
					});
				});
		};
		self.deleteGenApp = function() {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					failoverService
						.deleteFailoverGroup(self.genAppId)
						.success(function(data) {
							cvToaster.showSuccessMessage({
								ttl: '15000',
								message: cvLoc('label.genAppDeleted')
							});
							$state.go('genApps');
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: '15000',
								message: e ? e : cvLoc('generic_error')
							});
						});
				}
			};

			$dialogs.confirm(
				cvLoc('label.deleteGenApp'),
				cvLoc('label.deleteGenAppConfirmation', '<b>' + self.genAppName + '</b>'),
				callBackFunctions
			);
		};

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		var columnDefs = [];
		columnDefs.push({
			field: 'genAppServerName',
			displayName: cvLoc('label.clientName'),
			cellTemplate:
				'<a title="{{row.entity.cvClient.clientName}}" href="#/genAppNodeContent/{{grid.appScope.genAppId}}/{{row.entity.cvClient.clientId}}">{{row.entity.cvClient.clientName}}</a>',
			enableHiding: false,
			cellTooltip: true,
			width: '45%'
		});

		columnDefs.push({
			field: 'nodeType',
			displayName: cvLoc('label.nodeType'),
			cellTemplate: '<span title="{{row.entity.nodeType}}" class="crop" >{{row.entity.nodeType}}</span>',
			width: '30%'
		});

		angular.extend(globalGridOptions, {
			data: 'serverList',
			columnDefs: columnDefs
		});

		var updateGenAppNode = function(genAppData) {
			var vApp = {
				operationType: 128,
				genericApp: genAppData,
				vAppEntity: {
					vAppId: genAppId,
					vAppName: self.genAppName
				}
			};
			failoverService
				.updateFailoverGroup({
					virtualApp: JSON.stringify(vApp)
				})
				.success(function(data) {
					cvToaster.showSuccessMessage({
						ttl: '10000',
						message: 'Updated app successfuly'
					});
					loadGenAppDetails();
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e ? e : cvLoc('generic_error')
					});
				});
		};

		self.updateTags = function(tagData) {
			var templateUrl = 'modules/genApp/partials/addGenAppTagConfig.jsp';
			var controller = 'updateGenAppTagsCtrl';
			var opts = new Object();

			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, tagData, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					var genAppData = angular.copy(self.genAppDetails);
					genAppData.tags = dataObject;
					updateGenAppNode(genAppData);
				}
			});
		};

		self.addServer = function() {
			var templateUrl = 'modules/genApp/partials/addGenAppServer.jsp';
			var controller = 'addGenAppServerCtrl';
			var opts = new Object();

			var dataObject = {
				epNode: null,
				clientList: null
			};

			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataObject, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					var genAppData = angular.copy(self.genAppDetails);
					genAppData.enterpriseNodes.push(dataObject);
					updateGenAppNode(genAppData);
				}
			});
		};

		self.gridOptions = {
			cvAppScope: self,
			cvGridTitle: cvLoc('All_Clients'),
			cvIsPageTitle: false,
			cvIsSearchable: true,
			cvSearchFields: ['cvClient.clientName', 'nodeType'],
			cvTableName: 'genGenServersTable',
			cvOnGridEmpty: {
				message: cvLoc('label.addGenAppSerEmptyMsg')
			},
			gridOptions: globalGridOptions
		};
	}
]);

export default genAppModule;
