import { formsModule } from 'common/js/modules';

var app = formsModule;

app.directive('formTile', [
	function() {
		return {
			restrict: 'E',
			transclude: true,
			scope: {
				form: '=form',
				openWorkflow: '=openWorkflow'
			},
			templateUrl: appUtil.appRoot + 'modules/forms/partials/formTile.jsp',
			link: function(scope, elm, attrs) {
				scope.hide = true;
				scope.height = 100;
				scope.formURL =
					'#/forms?workflowName=' + scope.form.entity.workflowName + '&workflowId=' + scope.form.entity.workflowId;
				let origHeight;

				scope.toggleHide = function() {
					scope.hide = !scope.hide;
				};

				origHeight = scope.form.description.length;
				if (origHeight > scope.height) {
					scope.showSection = true;
				}
			}
		};
	}
]);

app.directive('formTag', [
	function() {
		return {
			restrict: 'E',
			transclude: true,
			scope: {
				tagInfo: '=tagInfo',
				keyword: '=keyword',
				openWorkflow: '=openWorkflow'
			},
			templateUrl: appUtil.appRoot + 'modules/forms/partials/tagTemplate.jsp'
		};
	}
]);

export default app;
