import 'modules/emailTemplates/js/controllers/emailPreviewModal.ctrl.js';

import { emailTemplatesModule } from 'common/js/modules';

// dependencies injected by Angular
import '../controllers/emailPreviewModal.ctrl';

emailTemplatesModule.service('EmailPreviewModalService', [
	'cvLoc',
	'$uibModal',
	'cvToaster',
	function EmailPreviewModalService(cvLoc, $modal, cvToaster) {
		this.openModal = function openModal(emailTemplate, emailTokens) {
			if (emailTemplate === undefined) {
				throw new Error('EmailTemplate instance required');
			}

			let modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/emailTemplates/partials/emailPreviewModal.jsp',
				backdrop: 'static',
				controllerAs: 'vm',
				controller: 'EmailPreviewModalCtrl',
				resolve: {
					emailTemplate: function() {
						return emailTemplate;
					},
					emailTokens: function() {
						return emailTokens;
					}
				}
			});
			modalInstance.result.then(onSave, onCancel);

			function onSave(emailTemplate) {
				cvToaster.showSuccessMessage({
					message: cvLoc('emailTemplates.msg.saveSuccessful', '<b>' + emailTemplate.name + '</b>')
				});
			}

			function onCancel(err) {
				if (err) {
					// TODO: [email-templates] improve this
					// cvToaster.showErrorMessage({
					//     message: cvLoc('emailTemplates.msg.saveFailure', '<b>' + err + '</b>')
					// });
				}
			}

			return modalInstance.result;
		};
	}
]);

export default emailTemplatesModule;
