import 'modules/emailTemplates/js/services/emailTemplates.svc.js';

import { emailTemplatesModule } from 'common/js/modules';

import {
	//CKEDITOR_TOOLBAR_WITH_TOKENS_CONFIG,
	CURRENT_COMPANY_ID
} from './../constants';

// temporary localization Email Template strings
//import './../temp.localization';

// dependencies injected/need by Angular
import '../services/emailTemplates.svc';
import Editor from '../../../../common/js/directives/editor.js';
import * as uploadImage from '../../../../common/js/directives/editor-uploadImage.js';
//import '../directives/cvCkeditorTokens.directive';

// list of emails sent by Admin Console which are configurable
emailTemplatesModule.controller('EmailHeaderFooterConfigCtrl', [
	'$q',
	'EmailTemplatesService',
	'cvLoc',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'$dialogs',
	'$scope',
	'$window',
	function EmailHeaderFooterConfigCtrl(
		$q,
		EmailTemplatesService,
		cvLoc,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		$dialogs,
		$scope,
		$window
	) {
		let vm = this;

		vm.isLoading = true;
		//vm.headerEditorFrameSrc = "emailHeaderEditorWrapper.do?companyId=" + CURRENT_COMPANY_ID;
		//vm.footerEditorFrameSrc = "emailFooterEditorWrapper.do?companyId=" + CURRENT_COMPANY_ID;

		cvBreadcrumbsTabsFactory.addTabs([
			{
				title: cvLoc('label.nav.emailTemplates'),
				link: '#emailTemplates'
			},
			{
				title: cvLoc('label.nav.emailHeaderFooterConfig'),
				link: '#emailHeaderFooterConfig',
				selected: true
			}
		]);

		// Add breadcrumbs

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.masterCustomization'),
			link: '#nav/masterCustomization'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		//vm.emailTokens = [];
		vm.emailHeaderFooter = {};

		controllerInit();

		vm.handleSave = function() {
			const saveName = cvLoc('emailTemplates.label.emailHeaderFooter');
			var isHeaderFooterTextSecure = true;
			if (editors.header) {
				if (editors.header.isTextSecure() === false) {
					isHeaderFooterTextSecure = false;
					cvToaster.showErrorMessage({
						message:
							cvLoc('emailTemplates.msg.saveFailure', `<b>${saveName}</b><br />`) +
							cvLoc('editor.msg.error.unsecureEditorText')
					});
				} else {
					vm.emailHeaderFooter.header = editors.header.getText();
				}
			}
			if (editors.footer) {
				if (editors.footer.isTextSecure() === false) {
					isHeaderFooterTextSecure = false;
					cvToaster.showErrorMessage({
						message:
							cvLoc('emailTemplates.msg.saveFailure', `<b>${saveName}</b><br />`) +
							cvLoc('editor.msg.error.unsecureEditorText')
					});
				} else {
					vm.emailHeaderFooter.footer = editors.footer.getText();
				}
			}
			if (isHeaderFooterTextSecure === true) {
				vm.emailHeaderFooter.save().then(onSaveSuccess, onSaveFailure);
			}

			function onSaveSuccess() {
				//once saved, originalText should be updated hence passing second param as true
				editors.header.setText(vm.emailHeaderFooter.header, true);
				editors.footer.setText(vm.emailHeaderFooter.footer, true);
				cvToaster.showSuccessMessage({
					message: cvLoc('emailTemplates.msg.saveSuccessful', `<b>${saveName}</b>`)
				});
			}

			function onSaveFailure(err) {
				if (err) {
					cvToaster.showErrorMessage({
						message: cvLoc('emailTemplates.msg.saveFailure', `<b>${saveName}</b>`)
					});
				}
			}
		};

		// in the absence of using route resolvers, this is probably the best approach
		// to "pre-fetch" the data required for this page
		function controllerInit() {
			$q.all([
				// fetchEmailTokens(),
				fetchHeaderFooter()
			]).then(res => {
				vm.isLoading = false;
				startEditors(res[0].header, res[0].footer);
			});
		}

		//    function fetchEmailTokens() {
		//        let emailTokens = EmailTemplatesService.getEmailTokens();
		//
		//        emailTokens.then(onRequestSuccess, onRequestFailure);
		//
		//        function onRequestSuccess(res) {
		//            vm.emailTokens = res.map(token => {
		//                let name = cvLoc(`emailTemplates.token.${token.name}`);
		//                return [`$${token.name}$`, name, name];
		//            });
		//        }
		//
		//        function onRequestFailure(err) {
		//            // TODO: [email-templates] handle error
		//        }
		//
		//        return emailTokens;
		//    }
		var isLeaving = false; //this is required because after confirm dialog is clicked yes, locationchangestart is fired again
		$scope.$on('$locationChangeStart', function(event, next, current) {
			var isEmailBodyModified =
				(editors.header && editors.header.isModified()) || (editors.footer && editors.footer.isModified());

			if (!isLeaving && isEmailBodyModified) {
				$dialogs.confirm(cvLoc('label.confirmNavigationTitle'), cvLoc('emailTemplates.msg.confirmNavigation'), {
					yesFunction: function() {
						isLeaving = true;
						$window.location.href = next;
					},
					noFunction: function() {
						event.preventDefault();
					}
				});
				event.preventDefault();
				return;
			}
		});

		function fetchHeaderFooter() {
			let emailHeaderFooter = EmailTemplatesService.getEmailHeaderFooter();

			emailHeaderFooter.then(onRequestSuccess, onRequestFailure);

			function onRequestSuccess(res) {
				vm.emailHeaderFooter = res;
			}

			function onRequestFailure(err) {
				// TODO: [email-templates] handle error
			}

			return emailHeaderFooter;
		}

		vm.handleHeaderRestore = function() {
			$dialogs.confirm(
				cvLoc('emailTemplates.label.confirmHeaderRestore'),
				cvLoc('emailTemplates.msg.confirmHeaderRestore'),
				{
					noFunction: function() {},
					yesFunction: function() {
						vm.emailHeaderFooter.getCompanyEmailSettings().then(companyEmailSettings => {
							vm.emailHeaderFooter.header = companyEmailSettings.defaultHeader;
							var headerEditorFrame = document.getElementById('headerEditorFrame');
							if (headerEditorFrame && headerEditorFrame.contentWindow) {
								headerEditorFrame.contentWindow.setCkEditorData(companyEmailSettings.defaultHeader);
							}
							vm.handleDismissNotice();
						});
					}
				}
			);
		};

		vm.handleFooterRestore = function() {
			$dialogs.confirm(
				cvLoc('emailTemplates.label.confirmFooterRestore'),
				cvLoc('emailTemplates.msg.confirmFooterRestore'),
				{
					noFunction: function() {},
					yesFunction: function() {
						vm.emailHeaderFooter.getCompanyEmailSettings().then(companyEmailSettings => {
							vm.emailHeaderFooter.footer = companyEmailSettings.defaultFooter;
							var footerEditorFrame = document.getElementById('footerEditorFrame');
							if (footerEditorFrame && footerEditorFrame.contentWindow) {
								footerEditorFrame.contentWindow.setCkEditorData(companyEmailSettings.defaultFooter);
							}
							vm.handleDismissNotice();
						});
					}
				}
			);
		};

		var editors = {};
		var editorParams = {
			maxFileSize: 500000,
			tools: [
				'bold',
				'italic',
				'underline',
				'strikethrough',
				'subscript',
				'superscript',
				'cleanFormatting',
				'insertUnorderedList',
				'insertOrderedList',
				'indent',
				'outdent',
				'justifyLeft',
				'justifyCenter',
				'justifyRight',
				'justifyFull',
				'createLink',
				'unlink',
				'uploadImage',
				'formatting',
				'fontName',
				'fontSize',
				'foreColor',
				'backColor',
				'viewHtml'
			],
			editorContent: '' // for setting a value when the editor first loads, equivalent effect to using setText()
		};

		function startEditors(headerTemplate, footerTemplate) {
			// starts the editor after the end of the digest cycle
			var textEditorTemplate;
			EmailTemplatesService.getTemplate().then(function(editorTemplate) {
				textEditorTemplate = editorTemplate.data;
				watchAndStart($('#header-editor'), 'header', headerTemplate);
				watchAndStart($('#footer-editor'), 'footer', footerTemplate);
			});

			function watchAndStart(selector, editor, text) {
				if (selector[0]) {
					// make sure the element exists on the page
					editors[editor] = new Editor(editorParams, selector, textEditorTemplate, cvLoc, { uploadImage: uploadImage });
					if (text) {
						editors[editor].setText(text, true);
					} else {
						editors[editor].setText('', true);
					}
				} else {
					// element not found
				}
			}
		}
	}
]);

export default emailTemplatesModule;
