export const ADMIN_CONSOLE_PROXY_ENDPOINT = `${appUtil.appRoot}proxy`;
export const EMAIL_TEMPLATES_API_ENDPOINT = `${ADMIN_CONSOLE_PROXY_ENDPOINT}/EmailTemplates`;
export const ORGANIZATION_API_ENDPOINT = `${ADMIN_CONSOLE_PROXY_ENDPOINT}/Organization`;
export const CURRENT_COMPANY_ID = cv.orgId;
export const CURRENT_LOCALE = cv.locale;
export const IS_ADMIN = cv.isAdmin;
export const IS_TENANT_ADMIN = cv.isTenantAdmin;
export const COMPANY_COMCELL = `CommCell`;
export const COMPANY_COMCELL_ID = 0;

export const DEFAULT_HEADERS = {
	'Content-Type': 'application/json',
	Accept: 'application/json'
};

export const EMAIL_TYPE_VM_TO_DATA = {
	id: 'emailTypeId',
	label: 'localizedName',
	name: 'name',
	description: 'description',
	defaultBody: 'defaultTemplateContent.emailBody', // defaultTemplate.emailBody
	defaultSubject: 'defaultTemplateContent.subject', // defaultTemplate.subject
	isMSPAdminOnly: 'isMSPAdminOnly'
};

// from vaultcx/Source/Common/XmlMessage/Api.x
// Message EmailTemplateInfo
// {
//     int                     emailTemplateId
//     string                  name
//     string                  description
//     int                     emailTemplateTypeId
//     LocaleEntity            locale
//     boolean                 isDefault
//     ulong                   modifiedTime
//     string                  subject
//     string                  emailBody
//     OrgContactInfo          from
//     ProviderEntity          ownerCompany
//     UserEntity              creator
//     string                  cc
//     string                  bcc
// }

export const EMAIL_TEMPLATE_VM_TO_DATA = {
	id: 'emailTemplateId',
	name: 'name',
	description: 'description',
	typeId: 'emailTemplateTypeId',
	locale: 'locale.localeId',
	isDefault: 'isDefault',
	subject: 'subject',
	emailBody: 'emailBody',
	modified: 'modifiedTime',
	fromName: 'from.fullName',
	fromEmail: 'from.email',
	// ownerCompany: 'ownerCompany', // object, come back and refactor
	companyId: 'ownerCompany.providerId',
	companyName: 'ownerCompany.providerDomainName',
	creator: 'creator', // object, come back and refactor
	cc: 'cc',
	bcc: 'bcc'
};

export const EMAIL_HEADER_FOOTER_VM_TO_DATA = {
	header: 'companySettings.headerTemplate',
	footer: 'companySettings.footerTemplate',
	defaultHeader: 'defaultSettings.headerTemplate',
	defaultFooter: 'defaultSettings.footerTemplate',
	masterEmailTemplate: 'masterEmailTemplate'
};

//export const CKEDITOR_TOOLBAR_CONFIG = [
//    { name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' ] },
//    { name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'CopyFormatting', 'RemoveFormat' ] },
//    '/',
//    { name: 'paragraph', items: [ 'NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl' ] },
//    { name: 'links', items: [ 'Link', 'Unlink', '_', 'base64image' ] },
//    '/',
//    { name: 'styles', items: [ 'Format', 'Font', 'FontSize' ] },
//    { name: 'colors', items: [ 'TextColor', 'BGColor' ] }
//    ,{ name: 'document', items: [ 'Source' ] }
//];

//let tollbarConfigWithTokens = CKEDITOR_TOOLBAR_CONFIG.concat();
//tollbarConfigWithTokens.splice(3, 0, { name: 'tokens', items: [ 'tokens' ] });

//export const CKEDITOR_TOOLBAR_WITH_TOKENS_CONFIG = tollbarConfigWithTokens;
