(function(ckeditor) {
	if (ckeditor === undefined) {
		throw new Error('CKEDITOR is not included on the page');
		return;
	}

	ckeditor.plugins.add('tokens', {
		requires: ['richcombo'],
		init: function(editor) {
			let config = editor.config;
			let style = new ckeditor.style({
				element: 'span',
				styles: {
					'font-weight': 'bold'
				}
			});
			let lang = editor.lang.format;

			editor.ui.addRichCombo('tokens', {
				label: 'Token',
				title: 'Token',
				voiceLabel: 'Token',
				toolbar: 'links,100',
				allowedContent: style,
				requiredContent: style,

				panel: {
					css: [ckeditor.skin.getPath('editor')].concat(config.contentsCss),
					voiceLabel: lang.panelVoiceLabel
				},

				init: function() {
					var self = this;
					loadTokens(self);
					//editor.fire('tokensInit', this);
				},

				onClick: function(value) {
					editor.focus();
					editor.fire('saveSnapshot');
					editor.insertHtml(value);
					editor.fire('saveSnapshot');
				}

				// fires once
				// onRender: function() {

				// },

				// refresh fires multiple times when the user interacts with the editor
				// refresh: function() {

				// }
			});
		}
	});
})(CKEDITOR);
