<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1 data-ng-if = "registerCtrl.mode !== 'edit'"> <cv:msg key="title.registerCluster" bundle="servers"/></h1>
	<h1 data-ng-if = "registerCtrl.mode === 'edit'"> <cv:msg key="title.editCluster" bundle="servers"/></h1>
</div>
<div class="setup-content remove-top-padding smaller-inputs">
	<form name="clusterRegisterEditForm" data-cv-submit="registerCtrl.submit()" autocomplete="off">
		<p data-ng-if="registerCtrl.serverMessage.message" class="{{registerCtrl.serverMessage.type}} serverMessage" data-ng-bind="registerCtrl.serverMessage.message"></p>
		<p data-ng-if="clusterRegisterEditForm.clusterURL.$dirty && clusterRegisterEditForm.clusterURL.$error.pattern" class="error serverMessage"><cv:msg key="error.enterValidUrl" bundle="servers"/></p>
		<label for="clusterName" data-ng-if="registerCtrl.mode !== 'edit'">
			<cv:msg key="label.distributedStorageName" bundle="servers" />
			<input class="margin-right-20" type="text" name="clusterName" id="clusterName" data-ng-model="registerCtrl.entityName" required>
		</label>
		<label for="clusterURL">
			<cv-help-text help-label="label.clusterUrl" help-text="helpText.clusterUrl" bundle="servers"></cv-help-text>
			<input class="margin-right-20" type="text" name="clusterURL" id="clusterURL" data-ng-model="registerCtrl.url" data-ng-pattern="/^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/" required>
		</label>
		<label for="clusterUserName">
			<cv-help-text help-label="label.username" help-text="helpText.userName" bundle="servers"></cv-help-text>
			<input class="margin-right-20" type="text" name="clusterUserName" id="clusterUserName" data-ng-model="registerCtrl.userName" required>
		</label>
		<label for="clusterPassword"><cv:msg key="label.password" bundle="servers"/>
			<input placeholder="{{registerCtrl.passwordPlaceHolder}}" class="margin-right-20" type="password" name="clusterPassword" id="clusterPassword" data-ng-model="registerCtrl.password">
		</label>
		<div class="button-container">
	  		<button id="clusterCancel_button_#4295" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="registerCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
	  		<button id="clusterRegister_button_#0080" data-ng-if="registerCtrl.mode !== 'edit'" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.register" bundle="servers"/></button> 
	  		<button id="clusterSave_button_#0080" data-ng-if="registerCtrl.mode === 'edit'" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="servers"/></button> 
		</div>
	</form>
</div>