import { acAppDistributedStorageModule } from 'common/js/modules';
import 'modules/settings/js/factories/cvPermissions.factory.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'modules/settings/js/directives/cvPermittedActions.directives.js';
import 'modules/settings/js/factories/cvActionsEvent.factory.js';
import 'modules/distributedStorage/js/distributedStorage.svc.js';
import 'modules/distributedStorage/js/distributedStorage.factory.js';
import * as distStorageTemplates from 'modules/distributedStorage/js/distributedStorage.column.template.js';

class distributedStorageListController {
	constructor(
		$scope,
		cvLoc,
		distributedStorageFactory,
		distributedStorageService,
		settingsService,
		cvPermissionFactory,
		cvToaster,
		ENTITY_TYPES,
		$compile,
		$filter,
		cvActionsEventFactory,
		PERMISSIONS
	) {
		this.$scope = $scope;
		this.cvLoc = cvLoc;
		this.distributedStorageFactory = distributedStorageFactory;
		this.distributedStorageService = distributedStorageService;
		this.settingsService = settingsService;
		this.cvPermissionFactory = cvPermissionFactory;
		this.cvToaster = cvToaster;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.$compile = $compile;
		this.$filter = $filter;
		this.cvActionsEventFactory = cvActionsEventFactory;
		this.PERMISSIONS = PERMISSIONS;
		this.associationTypes = [];
		this.initializeGrid();
	}

	initializeGrid() {
		this.gridOptions = {
			gridTitle: this.cvLoc('label.nav.hedvig'),
			tableName: 'distributedStorageList',
			enablePaging: true,
			pageSize: 20,
			searchable: true,
			url: this._getDistributedStorageList.bind(this),
			usePageToolbar: true,
			gridEmptyMessage: this.cvLoc('label.emptyClusterGrid'),
			columns: this._getColumns(),
			onGridDataBound: this._onGridDataBound.bind(this),
			showCompanyColumnAndFilter: true,
			beforeGridInitialize: ({ grid }) => {
				this.grid = grid;
			},
			gridToolbarMenu: [
				{
					id: 'registerCluster',
					label: this.cvLoc('action.registerCluster'),
					onSelect: this.distributedStorageFactory.registerOrEditCluster.bind(this, undefined, undefined),
					hidden: !cv.userPermissions.includes(this.PERMISSIONS.REGISTER_DISTRIBUTED_STORAGE)
				}
			]
		};

		this.$scope.gridOptions = this.gridOptions;
	}

	_getDistributedStorageList(options) {
		let self = this;
		this.distributedStorageService
			.getDistributedStorageList()
			.success(distributedStorageObj => {
				let infoList = _.get(distributedStorageObj, 'distributedStorageInfo', []);
				if (distributedStorageObj.error && distributedStorageObj.error.errorCode !== 0) {
					let errorMessage = distributedStorageObj.error.errorMessage
						? distributedStorageObj.error.errorMessage
						: self.cvLoc('error.clusterOperationFailed');
					self.cvToaster.showErrorMessage({
						message: errorMessage,
						ttl: '5000'
					});
					self.gridOptions.gridEmptyMessage = errorMessage;
					options.success([]);
				} else {
					infoList.forEach(function(obj) {
						obj.permittedOptions = {
							entityType: self.ENTITY_TYPES.DISTRIBUTED_STORAGE_ENTITY,
							entity: {
								clientId: self.distributedStorageFactory.getDistributedStorageId(obj),
								clientName: self.distributedStorageFactory.getDistributedStorageId(obj)
							},
							entityId: self.distributedStorageFactory.getDistributedStorageId(obj),
							entityName: self.distributedStorageFactory.getDistributedStorageId(obj),
							entityListPageState: 'distributedStorages',
							appendToBody: true,
							permittedActionList: self.distributedStorageFactory.getActions(obj)
						};
						obj.canManage = _.get(obj, 'canManage', false);
						obj.detailsUrl = '#/distributedStorages/' + self.distributedStorageFactory.getDistributedStorageId(obj);
					});
					options.success(infoList);
				}
			})
			.error(err => {
				options.error(err);
				self.cvToaster.showErrorMessage({
					message: err,
					ttl: '5000'
				});
			});
	}

	_getColumns() {
		return distStorageTemplates.getColumns({ cvLoc: this.cvLoc, $filter: this.$filter });
	}

	_onGridDataBound(dataItem, row) {
		let self = this;
		let permittedOptions = dataItem.permittedOptions;
		let entityId = permittedOptions.entityId;
		let actionsTemplate = `<cv-permitted-actions cv-permitted-options="permittedOptions${entityId}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${entityId}`] = permittedOptions;
		row.find('.permittedActions').html(this.$compile(actionsTemplate)(this.$scope));

		const distStorageLink = row.find('.k-grid-distStorageUrl');
		distStorageLink.click(function() {
			self.distributedStorageFactory.openClusterInNewTab(dataItem);
		});
	}

	_refreshGrid() {
		if (this.grid) {
			this.grid.refreshData();
		}
	}
}

distributedStorageListController.$inject = [
	'$scope',
	'cvLoc',
	'distributedStorageFactory',
	'distributedStorageService',
	'settingsService',
	'cvPermissionFactory',
	'cvToaster',
	'ENTITY_TYPES',
	'$compile',
	'$filter',
	'cvActionsEventFactory',
	'PERMISSIONS'
];

acAppDistributedStorageModule.controller('distributedStorageListController', distributedStorageListController);

export default acAppDistributedStorageModule;
