import { acAppDistributedStorageModule } from 'common/js/modules';
import 'adminConsole/js/controllers/activityControl.ctrl.js';

class distributedStorageDetailsController {
	constructor(
		$scope,
		cvLoc,
		distributedStorageFactory,
		distributedStorageService,
		cvPermissionFactory,
		cvToaster,
		ENTITY_TYPES,
		$compile,
		$filter,
		$q,
		PERMISSIONS,
		$stateParams,
		securityFactory,
		cvBreadcrumbsTabsFactory
	) {
		this.$scope = $scope;
		this.cvLoc = cvLoc;
		this.distributedStorageFactory = distributedStorageFactory;
		this.distributedStorageService = distributedStorageService;
		this.cvPermissionFactory = cvPermissionFactory;
		this.cvToaster = cvToaster;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.$compile = $compile;
		this.$filter = $filter;
		this.$q = $q;
		this.PERMISSIONS = PERMISSIONS;
		this.$stateParams = $stateParams;
		this.securityFactory = securityFactory;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.initializeSecurityAssociations();
		this.getDistributedStorageDetails($stateParams.distributedStorageId);

		this.$scope.editGeneralTile = function() {
			distributedStorageFactory.registerOrEditCluster($scope.distributedStorageObject);
		};

		this.$scope.openClusterInNewTab = function() {
			distributedStorageFactory.openClusterInNewTab($scope.distributedStorageObject);
		};

		this.$scope.changeDistributedStorageNameCallback = function(errorParam, successParam) {};

		this.cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.nav.hedvig'),
				link: '#distributedStorages'
			}
		]);
	}

	initializeSecurityAssociations() {
		const self = this;
		self.$scope.genericEntity = {
			distributedStorageId: self.$stateParams.distributedStorageId
		};
		self.$scope.securityAssociations = {
			entityType: self.ENTITY_TYPES.DISTRIBUTED_STORAGE_ENTITY,
			genericEntity: self.$scope.genericEntity,
			loadSecurityAssociations: false
		};
	}

	getDistributedStorageDetails(id) {
		const self = this;
		self.distributedStorageService
			.getDistributedStorageDetails(id)
			.success(function(distributedStorageObj) {
				if (distributedStorageObj.error && distributedStorageObj.error.errorCode !== 0) {
					let errorMessage = distributedStorageObj.error.errorMessage
						? distributedStorageObj.error.errorMessage
						: self.cvLoc('error.clusterOperationFailed');
					self.cvToaster.showErrorMessage({
						message: errorMessage,
						ttl: '5000'
					});
				}
				let info = _.get(distributedStorageObj, 'distributedStorageInfo[0]', {});
				self.$scope.distributedStorageObject = info;
				//info.canManage = _.get(info,'canManage',true);
				info.canManage = _.get(info, 'canManage', false);
				const id = self.distributedStorageFactory.getDistributedStorageId(info);
				const name = self.distributedStorageFactory.getDistributedStorageName(info);

				self.$scope.distributedStorageObjectWrapper = {
					id: id,
					name: name
				};
				// Set Security associations from response
				self.$scope.securityAssociations.securityObject = self.securityFactory.formatSecurityAssociationsObject(
					info.securityAssociations
				);
				self.$scope.securityAssociations.loadSecurityAssociations = true;

				const entitySecurityData = _.get(info, 'metaInfo', { permissionIds: [] });
				// Set permitted options for capability links
				self.$scope.permittedOptions = {
					entitySecurityData: entitySecurityData,
					entityType: self.ENTITY_TYPES.DISTRIBUTED_STORAGE_ENTITY,
					entity: {
						clientId: id,
						clientName: name
					},
					entityId: id,
					entityName: name,
					entityListPageState: 'distributedStorages',
					appendToBody: true,
					permittedActionsList: self.distributedStorageFactory.getActions(info),
					permittedMoreActionsList: []
				};
				self.$scope.dataLoaded = true;
			})
			.error(function(err) {
				self.cvToaster.showErrorMessage({
					message: err,
					ttl: '5000'
				});
			});
	}
}

distributedStorageDetailsController.$inject = [
	'$scope',
	'cvLoc',
	'distributedStorageFactory',
	'distributedStorageService',
	'cvPermissionFactory',
	'cvToaster',
	'ENTITY_TYPES',
	'$compile',
	'$filter',
	'$q',
	'PERMISSIONS',
	'$stateParams',
	'securityFactory',
	'cvBreadcrumbsTabsFactory'
];

acAppDistributedStorageModule.controller('distributedStorageDetailsController', distributedStorageDetailsController);
export default acAppDistributedStorageModule;
