import { acAppDistributedStorageModule } from 'common/js/modules';

var distStorageModule = acAppDistributedStorageModule;

distStorageModule.service('distributedStorageService', [
	'$http',
	'globalCacheFactory',
	'$httpParamSerializer',
	'cvUtil',
	function($http, globalCacheFactory, $httpParamSerializer, cvUtil) {
		this.getDistributedStorageList = function(permissionType) {
			let url = cv.contextPath + '/proxy/DistributedStorages';
			//let url = 'https://f921b379-adb9-40be-bb40-15b4d2355d1c.mock.pstmn.io/DistributedStorages';
			if (!!permissionType) {
				url += '?permissionType=' + permissionType;
			}
			return $http({
				method: 'GET',
				url: url
			});
		};

		this.getDistributedStorageDetails = function(id) {
			let url = cv.contextPath + '/proxy/DistributedStorages/' + id;
			return $http({
				method: 'GET',
				url: url
			});
		};

		this.loginCluster = function(url, samlResponse) {
			if (url) {
				url = url.trim();
			}
			if (samlResponse) {
				samlResponse = samlResponse.trim();
			}
			let body = {
				baseUrl: url,
				request: "{type:ValidateSAMLToken,category:UserManagement,SamlToken:'" + samlResponse + "'}"
			};
			return $http({
				method: 'POST',
				url: cv.contextPath + '/proxy/hedvig/rest/',
				headers: {
					'Content-Type': 'application/json'
				},
				data: JSON.stringify(body)
			});
		};

		this.registerCluster = function(distributedStorageInfo) {
			let url = cv.contextPath + '/proxy/DistributedStorages';
			//let url = 'https://f921b379-adb9-40be-bb40-15b4d2355d1c.mock.pstmn.io/DistributedStorages';
			let body = { distributedStorageInfo: distributedStorageInfo };
			return $http({
				url: url,
				//dataType: 'json',
				method: 'POST',
				data: JSON.stringify(body),
				headers: {
					'Content-Type': 'application/json',
					Accept: 'application/json'
				}
			});
		};

		this.updateCluster = function(distributedStorageId, distributedStorageInfo) {
			let url = cv.contextPath + '/proxy/DistributedStorages/' + distributedStorageId;
			//let url = 'https://f921b379-adb9-40be-bb40-15b4d2355d1c.mock.pstmn.io/DistributedStorages/102';
			let body = { distributedStorageInfo: distributedStorageInfo };
			return $http({
				url: url,
				dataType: 'json',
				method: 'PUT',
				data: JSON.stringify(body),
				headers: {
					'Content-Type': 'application/json'
				}
			});
		};

		this.deleteCluster = function(distributedStorageId) {
			let url = cv.contextPath + '/proxy/DistributedStorages/' + distributedStorageId;
			//let url = 'https://f921b379-adb9-40be-bb40-15b4d2355d1c.mock.pstmn.io/DistributedStorages/102';

			return $http({
				url: url,
				dataType: 'json',
				method: 'DELETE'
			});
		};

		this.sync = function(distributedStorageId) {
			let url = cv.contextPath + '/proxy/DistributedStorages/' + distributedStorageId + '/Sync';
			return $http({
				url: url,
				dataType: 'json',
				method: 'PUT',
				data: JSON.stringify({}),
				headers: {
					'Content-Type': 'application/json'
				}
			});
		};
	}
]);

export default distStorageModule;
