let getDistributedStorageNameColumn = cvLoc => ({
	name: {
		title: cvLoc('header.name'),
		type: 'string',
		width: '50%',
		template: getDistributedStorageNameTemplate()
	}
});

let getDistributedStorageURLColumn = cvLoc => ({
	url: {
		title: cvLoc('label.clusterUrl'),
		type: 'string',
		width: '40%',
		template: getDistributedURLTemplate()
	}
});

let getUserNameColumn = cvLoc => ({
	userName: {
		title: cvLoc('label.username'),
		type: 'string',
		width: '40%',
		template: getUserNameTemplate()
	}
});

let getActionsColumn = cvLoc => ({
	actions: {
		title: cvLoc('header.actions'),
		type: 'string',
		template: getActionsTemplate(),
		excludeFromExport: true,
		disableViewFiltering: true,
		disableColumnFilter: true,
		sortable: false,
		disableColumnMenu: true,
		attributes: {
			class: 'permitted-actions'
		}
	}
});

let getDistributedStorageNameTemplate = () => {
	return `<a class="crop" href="#:detailsUrl#">#:distributedStorage.distributedStorageName#</a>`;
};

let getDistributedURLTemplate = () =>
	`#if(canManage){
		#<a class="crop k-grid-distStorageUrl">#:url#</a>#
	}else {
		#<span class="crop">#:url#</span>#
	}#`;

let getUserNameTemplate = () => `<span class="crop">#:credential.record.userName#</span>`;

let getActionsTemplate = () => `<div class="permittedActions action-btn"></div>`;

export const getColumns = function(angularLibs) {
	const columnList = [
		getDistributedStorageNameColumn(angularLibs.cvLoc),
		getDistributedStorageURLColumn(angularLibs.cvLoc),
		getUserNameColumn(angularLibs.cvLoc),
		getActionsColumn(angularLibs.cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};
