<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="panel panel-default setup-panel">
		<div class="panel-body setup-content">
			<div class="row">
				<div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
					<form class="form-horizontal edit-users-grid-form" id="selectContentForm" name="selectContentForm" autocomplete="off" cv-submit="goToTarget()" cv-hide-api>
						<span class="col-xs-12 text-center server-message {{repGrpContentCtrl.serverMessage.type}}" data-ng-bind="repGrpContentCtrl.serverMessage.message"></span>
						<span data-ng-if="noAccessNodes" class="col-xs-12 text-center server-message error">
							<cv:msg key="error.repgroup.noaccessnodes" bundle="replicationGroups"/>
							<a href="" data-ng-click="createAccessNode()"><cv:msg key="label.here" bundle="messagesJs"/></a>
							<cv:msg key="error.repgroup.beforeproceed" bundle="replicationGroups"/>
						</span>
						
						
						<div class="form-group">
							<label class="col-xs-12 col-sm-5"> <cv:msg
								key="label.name" bundle="vmsJs"></cv:msg>
							</label>
							<div class="col-xs-12 col-sm-7">
								<input type="text" id="name" name="name" placeholder="<cv:msg key="placeholder.enterGroupName" bundle="replicationGroups"></cv:msg>" data-ng-model="replicationGroup.name" data-ng-change="replicationGroupNameChanged(replicationGroup.name)" data-ng-required novalidate/>
								<div class="help-block" data-ng-if="cv.selectContentForm.getAttempted() && !replicationGroup.name">
									<cv:msg key="msg.enterGroupName" bundle="replicationGroups" />
								</div>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-sm-5"><cv:msg key="label.sourceHypervisor" bundle="dr"></cv:msg></label>
							<div class="col-xs-12 col-sm-7">
								<cv-select-hypervisors
									model="replicationGroup"
									vendor-list="sourceVendors"
									ctrl="ctrl"
									show-create="true">
								</cv-select-hypervisors>
							</div>
						</div>

						<div class="form-group" data-ng-if="repGrpContentCtrl.showSelectedVMs && !enableAddRuleReplicationGroup" id="selectedVMs">
							<label class="col-xs-12 col-sm-5"><cv:msg key="label.selectedVMs" bundle="replicationGroups" /></label>
							<div class="col-xs-12 col-sm-7">
								<div class="overflow-auto" id="selectedVMsList">
			                        <ul data-ng-repeat="ce in replicationGroup.selectedVMs" class="general-list list-style__row group viewContentList margin-left-5">
			                 			<li class="vsaColumnIcon vsaIcon{{ce.icon}}"><span data-ng-bind="ce.name" /></li>
			                        </ul>
			                    </div>
			                </div>
						</div>
						
<%-- 						<div class="form-group" data-ng-if="replicationGroup.selectedHypervisor.clientId && !repGrpContentCtrl.showSelectedVMs">
							<label class="col-xs-12"><cv:msg key="label.virtualMachines" bundle="dr"/></label>
						</div>
 --%>					<div class="form-group" data-ng-if="replicationGroup.selectedHypervisor.clientId && !repGrpContentCtrl.showSelectedVMs">
							<div class="col-xs-12" data-ng-if="!enableAddRuleReplicationGroup">
								<cv-browse-collection-content
									selected-content='repGrpContentCtrl.collectionInfo.selectedContent'
									server-id="replicationGroup.selectedHypervisor.clientId"
									server-type="{{repGrpContentCtrl.selectedSrcVendor}}"
									vm-selected='vmSelected'
									initial-content-browse-view-path='\NONE:VMs'
									hide-grouping="true"
									ctrl="ctrl" 
									wizard-layout="true"
									class="modal-content"
									select-content-warning-fn='cv.selectContentForm.getAttempted()'>
								</cv-browse-collection-content>
							</div>
						</div>
						
						<div class="form-group" data-ng-if="replicationGroup.selectedHypervisor.clientId">
							<!-- New add virtual machine UI -->
							<div class="col-xs-12" data-ng-if="enableAddRuleReplicationGroup">
								<cv-add-vm-content-directive vendor="repGrpContentCtrl.selectedSrcVendor" client-id="replicationGroup.selectedHypervisor.clientId" ctrl="ctrl"
									selected-content="replicationGroup.selectedContent"
									show-add-rules="repGrpContentCtrl.showAddRulesButton"></cv-add-vm-content-directive>
							</div>
						</div>
						
						<div class="form-group">
							<div class="col-xs-12">
								<div class="button-container">
									<div class="float-left">
										<button id="repGrpSelectContentCancelButton" type="button" class="btn btn-default margin-left-0" data-ng-click="repGrpContentCtrl.cancel()">
											<cv:msg key="Cancel" bundle="messages"></cv:msg>
										</button>
									</div>
									<div class="float-right">
										<button id="repGrpSelectContentNextButton" data-ng-disabled="noAccessNodes" class="btn btn-primary cvBusyOnAjax margin-right-0" type="submit">
											<cv:msg key="Next" bundle="messages"></cv:msg>
										</button>
									</div>
								</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
