import 'dlo/js/services/profile.svc.js';
import 'modules/disasterRecovery/repGrp/js/controllers/repGrpParent.ctrl.js';
import 'modules/plan/js/controllers/createVsaProfile.ctrl.js';
import 'modules/plan/js/directives/planDirectives.js';
import 'modules/servers/js/services/servers.svc.js';
import 'storage/js/services/storage.svc.js';
import 'vsa/js/directives/cv-recovery-options-directive.js';
import 'vsa/js/directives/cv-select-hypervisors-directive.js';
import 'vsa/js/services/restore.svc.js';

import { vsaAppServerModule } from 'common/js/modules';

var mod = vsaAppServerModule;

/**
 * A controller for handling the functionality on the page for selecting a target for the replication
 * group being configured.
 */
mod.controller('replicationGroupTargetController', [
	'$q',
	'$filter',
	'vsaProfileFactory',
	'profileService',
	'storageService',
	'cvUtil',
	'$scope',
	'$state',
	'restoreService',
	'serverService',
	'collectionFactory',
	'replicationGroupFactory',
	'$log',
	'cvLoc',
	'REPLICATION_TYPES',
	'REPLICATION_SOLUTIONS',
	'cvBreadcrumbsTabsFactory',
	'VENDORS',
	'REP_TYPES',
	function(
		$q,
		$filter,
		vsaProfileFactory,
		profileService,
		storageService,
		cvUtil,
		$scope,
		$state,
		restoreService,
		serverService,
		collectionFactory,
		replicationGroupFactory,
		$log,
		cvLoc,
		REPLICATION_TYPES,
		REPLICATION_SOLUTIONS,
		cvBreadcrumbsTabsFactory,
		VENDORS,
		REP_TYPES
	) {
		if ($scope.replicationGroup.attributes.refreshBrowser()) {
			return;
		}

		var self = this;
		$scope.ctrl = {};
		cvBreadcrumbsTabsFactory.addBreadCrumbs($scope.replicationGroup.breadCrumbs);
		$scope.replicationGroup.replicationType = $scope.replicationGroup.replicationType || REP_TYPES.PERIODIC;

		const isAmazonProxySelected = (proxyServer, amazonProxyServers) => {
			// Automatic/ Distibute workload proxy is treated as Amazon proxy
			if (proxyServer && (proxyServer.autoProxy || !proxyServer.clientId)) {
				return true;
			}
			//check if the proxySever is present in the vendorSpecificProxyServers
			if (amazonProxyServers && proxyServer) {
				for (let amazonProxyServer of amazonProxyServers) {
					if (amazonProxyServer.clientId === proxyServer.clientId) {
						//selected proxy is Amazon specific
						return true;
					}
				}
			}
			return false; //if there are no amazon proxies in the setup then it is non-amazon anyway
		};

		/*
		 * Checking if the replication source and targets are valid to show guest credentials
		 */
		const validVendorsForAWSCrossRestore = () => {
			if (!$scope.replicationGroup) {
				return false;
			}

			/*
			 * AWS is the only valid replicationTargetType
			 */
			const validReplicationTargetType =
				$scope.replicationGroup.target &&
				$scope.replicationGroup.target.target &&
				$scope.replicationGroup.target.target.entity &&
				$scope.replicationGroup.target.target.entity.vmAllocPolicyType === VENDORS.AMAZON.type;

			const sourceHypervisorType =
				$scope.replicationGroup.selectedHypervisor && $scope.replicationGroup.selectedHypervisor.type;

			let validSourceHypervisorType = false;

			switch (sourceHypervisorType) {
				case 'VMW':
					validSourceHypervisorType = true;
					break;
				default:
					validSourceHypervisorType = false;
			}

			return validReplicationTargetType && validSourceHypervisorType;
		};
		/*
		 * This method is used to determine if amazon proxy information message should be shown. Required
		 * conditions: VMW->AWS replication with an AWS proxy selected
		 */
		const showAmazonProxyInfo = () => {
			if (
				$scope.replicationGroup &&
				$scope.replicationGroup.selectedProxy &&
				isAmazonProxySelected($scope.replicationGroup.selectedProxy[0], $scope.replicationGroup.amazonProxyServers)
			) {
				$scope.replicationGroup.isAmazonProxy = true;
			} else {
				$scope.replicationGroup.isAmazonProxy = false;
			}
		};

		$scope.ctrl.newTargetSelected = function(selectedTarget) {
			if (
				!$scope.replicationGroup.preSelectTarget ||
				(selectedTarget &&
					$scope.replicationGroup.target.target &&
					selectedTarget.entity.vmAllocPolicyId != $scope.replicationGroup.preSelectTarget.entity.vmAllocPolicyId)
			) {
				$scope.replicationGroup.preSelectTarget = selectedTarget;
				$scope.replicationGroup.modifiedVmsList = null;
				$scope.replicationGroup.modifiedVms = null;
				$scope.replicationGroup.enableOverrideOptions = false;

				if (validVendorsForAWSCrossRestore()) {
					$scope.replicationGroup.isAWSCrossRestore = true;
				} else {
					$scope.replicationGroup.isAWSCrossRestore = false;
				}
			}
		};

		/*
		 * This hook is called when the selected proxy is changed
		 */
		$scope.ctrl.refreshProxy = () => {
			showAmazonProxyInfo();
		};

		self.loadSchedules = function() {
			var promises = [];
			promises.push(profileService.getMasterProfile('VSA', 'VSAReplication'));
			$q.all(promises).then(function(responses) {
				var masterProfile = responses[0].data;
				masterProfile.profile.schedule.subTasks[0].options.backupOpts.collectMetaInfo = false;
				$scope.replicationGroup.globalTemplate = vsaProfileFactory.getGlobalTemplate();
				$scope.replicationGroup.globalTemplate.masterTemplate = masterProfile;
				$scope.replicationGroup.globalTemplate.schedules = masterProfile.profile.schedule.subTasks.slice();
				$scope.replicationGroup.globalTemplate.replicationSchedules = masterProfile.profile.replicationTargets.taskInfo[0].subTasks.slice();
				vsaProfileFactory.setGlobalTemplate($scope.replicationGroup.globalTemplate);
				//console.log($scope.replicationGroup.globalTemplate);
			});
		};

		var setCopyPrecedence = function(storage) {
			$scope.replicationGroup.copyDetails = {
				storage: storage,
				showCopyPrecedence: true,
				copyPrecedenceLabel: cvLoc('label.copyPrecedence'),
				defaultCopyPrecedenceLabel: cvLoc('label.defaultCopyPrecedence'),
				copyPrecedenceIdLabel: cvLoc('label.copyPrecedenceId')
			};
		};

		self.loadCopyDetails = function() {
			if (!$scope.replicationGroup.copyDetails.showCopyPrecedence) {
				// Only call when this is first time on Target screen.
				if (!$scope.replicationGroup.copyDetails || !$scope.replicationGroup.copyDetails.storage) {
					profileService
						.getProfileDetails($scope.planId)
						.success(function(data) {
							if (data.profile && data.profile.storage && data.profile.storage.copy) {
								setCopyPrecedence(data.profile.storage);
								$scope.ctrl.refreshCopyPrecedence($scope.replicationGroup.copyDetails);
							} else {
								$log.debug('no storage information returned');
							}
						})
						.error(function(data) {
							//no plan for collection so don't show the storage copy
							$log.error('unable to get profile details for the plan:' + $scope.planId);
						});
				}
			}
		};

		self.checkForNewVm = function() {
			if (!$scope.replicationGroup.selectedVMs) {
				return;
			}

			return $scope.replicationGroup.selectedVMs.some(function(vm) {
				return !vm.existedVm;
			});
		};

		/** Start of initialize * */
		self.initialize = function() {
			$scope.replicationGroup.currentStep = 1;
			$scope.errorMsg = cvUtil.emptyMsg();
			if (!$scope.replicationGroup.globalTemplate) {
				self.loadSchedules();
			}
			var breadCrumbs = [];
			breadCrumbs.push({
				title: cvLoc('label.nav.replication.groups'),
				link: '#replicationGroups'
			});

			$scope.replicationGroup.setSelectedVMs = setSelectedVMs.bind(this);

			if (!$scope.replicationGroup.editMode) {
				$scope.replicationGroup.targetDisabled = false;
			}

			if ($scope.replicationGroup.editMode && $scope.replicationGroup.task) {
				// set init model as empty
				$scope.replicationGroup.targetDisabled = true;
				var vsRstOptions = $scope.replicationGroup.task.subTasks[0].options.restoreOptions.virtualServerRstOption;
				var destinationVendor;
				var restoreOptions = $scope.replicationGroup.task.subTasks['0'].options.restoreOptions;

				$scope.replicationGroup.targetModel = {
					diskRestoreOption: vsRstOptions.diskLevelVMRestoreOption,
					showVMWareAdvanceOptions: vsRstOptions.allocationPolicy
						? vsRstOptions.allocationPolicy.policyType === VENDORS.VMW.policyType
						: true,
					allocationPolicy:
						$scope.replicationGroup.task.subTasks['0'].options.restoreOptions.virtualServerRstOption.allocationPolicy,
					editMode: true,
					replicationSchedule: $scope.replicationGroup.task.subTasks[0]
				};

				var restoreDestVendor = restoreOptions.volumeRstOption.destinationVendor;
				$scope.replicationGroup.targetModel.showVMWareAdvanceOptions = destinationVendor === VENDORS.VMW.type;
				destinationVendor = VENDORS[restoreDestVendor] ? VENDORS[restoreDestVendor].policyType : 'VMWARE';

				if ($scope.replicationGroup.target) {
					$scope.replicationGroup.targetModel.copyPrecedence =
						$scope.replicationGroup.target.diskRestoreOption.copyPrecedence;
				} else {
					$scope.replicationGroup.targetModel.copyPrecedence =
						$scope.replicationGroup.task.subTasks[0].options.restoreOptions.browseOption.mediaOption.copyPrecedence.copyPrecedence;
				}

				// Set destination vendor for the target
				$scope.replicationGroup.targetModel.destinationVendor = destinationVendor;
				$scope.replicationGroup.targetModel.destinationHypervisor = vsRstOptions.vCenterInstance; // Set destination Hypervisor for the target
				$scope.replicationGroup.targetModel.targetId =
					$scope.replicationGroup.target && $scope.replicationGroup.target.target
						? $scope.replicationGroup.target.target.entity.vmAllocPolicyId
						: undefined;
				$scope.replicationGroup.selectedProxy = $scope.replicationGroup.selectedProxy
					? $scope.replicationGroup.selectedProxy
					: [restoreOptions.destination.destClient];

				//don't use buckets for AWS targets
				//	              if (destinationVendor === VENDORS.AMAZON.policyType) {
				//	            	// pick up amazon bucket that already set from the group (from advancedRestoreOptions)
				//	            	  var selectedAmazonBucket = "";
				//	                if (restoreOptions.virtualServerRstOption.diskLevelVMRestoreOption.advancedRestoreOptions && restoreOptions.virtualServerRstOption.diskLevelVMRestoreOption.advancedRestoreOptions.length && restoreOptions.virtualServerRstOption.diskLevelVMRestoreOption.advancedRestoreOptions[0]) {
				//	                	selectedAmazonBucket = restoreOptions.virtualServerRstOption.diskLevelVMRestoreOption.advancedRestoreOptions[0].Datastore;
				//	                }
				//	                if (!$scope.replicationGroup.selectedAmazonBucket) {
				//	                	$scope.replicationGroup.selectedAmazonBucket = {
				//	                			dataStoreName: ""
				//	                	};
				//	                }
				//	                var dataStoreName = $scope.replicationGroup.selectedAmazonBucket.dataStoreName
				//	                $scope.replicationGroup.selectedAmazonBucket.dataStoreName = dataStoreName ? dataStoreName : selectedAmazonBucket;
				//	              }
				//  If there are no new vm added
				if (!self.checkForNewVm()) {
					if (
						$scope.replicationGroup.targetModel.allocationPolicy &&
						$scope.replicationGroup.targetModel.allocationPolicy.vmAllocPolicyId
					) {
						// If target is present, then show the dropdown as disabled
						$scope.replicationGroup.targetDisabled = true;
						$scope.replicationGroup.targetModel.showTarget = true;
					} else {
						// If target is not present, not showing select target
						$scope.replicationGroup.targetModel.showTarget = false;
					}

					$scope.targetRequired = false;
					//  If there are Vms added
				} else {
					if (
						$scope.replicationGroup.targetModel.allocationPolicy &&
						$scope.replicationGroup.targetModel.allocationPolicy.vmAllocPolicyId
					) {
						// If target is present, then show the target drop-down as disabled
						$scope.replicationGroup.targetDisabled = true;
						$scope.replicationGroup.targetModel.showTarget = true;
						$scope.targetRequired = false;
					} else {
						// If target is not present, then show target to select depending on vendor and Hypervisor
						$scope.replicationGroup.targetModel.showTarget = true;
						$scope.replicationGroup.targetDisabled = false;
						$scope.targetRequired = true;
					}
				}
				$scope.replicationGroup.showVMWareAdvanceOptions = $scope.replicationGroup.targetModel.showVMWareAdvanceOptions;
			} else {
				// check for prepopulated data
				if ($scope.replicationGroup.target) {
					$scope.replicationGroup.targetModel = $scope.replicationGroup.target;
					$scope.replicationGroup.targetModel.targetId = $scope.replicationGroup.target.target
						? $scope.replicationGroup.target.target.entity.vmAllocPolicyId
						: undefined;
					$scope.replicationGroup.targetModel.showVMWareAdvanceOptions =
						$scope.replicationGroup.showVMWareAdvanceOptions;
					$scope.replicationGroup.targetModel.allocationPolicy = $scope.replicationGroup.allocationPolicy;

					// Set select target to be available to be selected
					$scope.replicationGroup.targetModel.showTarget = true;
					$scope.replicationGroup.targetDisabled = false;

					if ($scope.replicationGroup.target.diskRestoreOption) {
						$scope.replicationGroup.targetModel.copyPrecedence =
							$scope.replicationGroup.target.diskRestoreOption.copyPrecedence;
					}
				}

				$scope.targetRequired = true;
			}
			/** End of initialize * */
			var getAmazonProxyLists = function() {
				serverService
					.getProxyServers(VENDORS.AMAZON.policyType)
					.success(function(data) {
						$scope.replicationGroup.amazonProxyServers = data;
					})
					.error(function(err) {
						$scope.replicationGroup.amazonProxyServers = null;
						$log.error('No amazon proxies');
					});
			};

			if (!$scope.replicationGroup.amazonProxyServers) {
				getAmazonProxyLists();
			}

			$scope.goBackToContent = function() {
				$scope.replicationGroup.currentStep--;
				$state.go('replicationGroup.selectContent');
			};
			// Check if target is missing, show error
			$scope.goToNextStep = function() {
				var errorExists = false;
				if (!$scope.replicationGroup.target) {
					// This is to prevent if user pressing button too fast and before the target is completely loaded!
					return;
				}

				if (!$scope.replicationGroup.selectedProxy || !$scope.replicationGroup.selectedProxy.length) {
					if ($scope.ctrl.displayProxyErrorMsg) {
						$scope.ctrl.displayProxyErrorMsg(cvUtil.errMsg(cvLoc('error.proxyClient')));
					}
					errorExists = true;
				} else {
					$scope.replicationGroup.targetModel.targetErrorMessage = cvUtil.emptyMsg();
					if (
						$scope.replicationGroup.target &&
						$scope.replicationGroup.target.target &&
						$scope.replicationGroup.target.target.entity &&
						$scope.replicationGroup.target.target.entity.vmAllocPolicyType
					) {
						$scope.replicationGroup.destinationVendor = $scope.replicationGroup.target.target.entity.vmAllocPolicyType;
					} else {
						$scope.replicationGroup.destinationVendor =
							$scope.replicationGroup.targetModel && $scope.replicationGroup.targetModel.destinationVendor
								? $scope.replicationGroup.targetModel.destinationVendor
								: 'VMWARE';
					}

					//remove validations for buckets
					if ($scope.replicationGroup.destinationVendor === VENDORS.AMAZON.policyType) {
						$scope.replicationGroup.isAmazonProxy = isAmazonProxySelected(
							$scope.replicationGroup.selectedProxy[0],
							$scope.replicationGroup.amazonProxyServers
						);
						//	        			if(!$scope.replicationGroup.isAmazonProxy && $scope.replicationGroup.target && $scope.replicationGroup.target.target && $scope.replicationGroup.target.target.entity && (!$scope.replicationGroup.target.target.entity.selectedAmazonBucket  || ($scope.replicationGroup.target.target.entity.selectedAmazonBucket && !$scope.replicationGroup.target.target.entity.selectedAmazonBucket.dataStoreName))){
						//		        			$scope.noBucketSelected = cvUtil.errMsg(cvLoc("error.missingAmazonBucket"));
						//		        			errorExists = true;
						//		        		}
					}
				}

				if (
					($scope.targetRequired && !$scope.replicationGroup.target.target) ||
					($scope.targetRequired &&
						$scope.replicationGroup.target.target &&
						!angular.isDefined($scope.replicationGroup.target.target.entity.vmAllocPolicyId))
				) {
					$scope.replicationGroup.targetModel.targetErrorMessage = cvUtil.errMsg(cvLoc('error.noTargetSelected'));
					errorExists = true;
				} else if (
					$scope.replicationGroup.attributes.replicationType === 'LiveSyncIO' &&
					$scope.replicationGroup.target.target.isDestinationSameAsSource
				) {
					errorExists = true;
				} else if ($scope.replicationGroup.attributes.replicationType === 'LiveSyncIO') {
					if ($scope.replicationGroup.blrRecoveryOpts.recoveryType == 4) {
						//show error when rpstore is not set for granular recovery
						if (!$scope.replicationGroup.blrRecoveryOpts.granularV2.rpStoreId) {
							$scope.replicationGroup.blrRecoveryOpts.rpStoreErrorMessage = cvLoc('error.noRPStoreSelected');
							errorExists = true;
						} else if ($scope.replicationGroup.blrRecoveryOpts.recoveryOptionsError) {
							errorExists = true;
						}
					}
				}

				// if other directive has any error and prevent going to next step
				if ($scope.replicationGroup.targetStepNotReady) {
					errorExists = true;
				} else if (
					$scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS &&
					$scope.replicationGroup.duplicateContinuousSourceMachines &&
					!$scope.replicationGroup.useAllocationPolicyForRestore
				) {
					$scope.errorMsg = cvUtil.errMsg(
						cvLoc('error.intersectingVms', $scope.replicationGroup.duplicateContinuousSourceMachines)
					);
					errorExists = true;
				}

				if ($scope.replicationGroup.rpo.errorMessage) {
					errorExists = true;
				}

				if (!errorExists) {
					/* For continuous, the rules have to be expanded */
					if ($scope.replicationGroup.useAllocationPolicyForRestore) {
						if (
							$scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS ||
							_.get($scope, 'replicationGroup.recoveryOptions.isSnapbackupEnabled', false)
						) {
							setSelectedVMs().then(function(success) {
								if (!areContinuousVMsValid()) {
									return;
								}
								if (success === true) {
									$scope.replicationGroup.vsa.filteredSteps = $scope.replicationGroup.vsa.allSteps;
									goToOverrideOptionsTab();
								} else {
									$scope.errorMsg = cvUtil.errMsgLoc('error.noVMsMatchingRule');
									return;
								}
							});
						} else if ($scope.replicationGroup.replicationType === REP_TYPES.PERIODIC) {
							setRuleRelatedChanges();
							goToOverrideOptionsTab();
						}
					} else {
						goToOverrideOptionsTab();
					}
				}
			};

			function goToOverrideOptionsTab() {
				$state.go('replicationGroup.recoveryOptions');
				$scope.replicationGroup.currentStep++;
			}

			function filterStep(state) {
				return $scope.replicationGroup.vsa.allSteps.filter(function(step) {
					return step.state !== state;
				});
			}

			function areContinuousVMsValid() {
				if ($scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS) {
					$scope.replicationGroup.duplicateContinuousSourceMachines = replicationGroupFactory.getDuplicateContinuousSourceMachines(
						$scope.replicationGroup.selectedVMs,
						$scope.replicationGroup.blr.pairs
					);
					if ($scope.replicationGroup.duplicateContinuousSourceMachines) {
						$scope.errorMsg = cvUtil.errMsg(
							cvLoc('error.intersectingVms', $scope.replicationGroup.duplicateContinuousSourceMachines)
						);
						return false;
					}
				}

				return true;
			}

			function setRuleRelatedChanges() {
				$scope.replicationGroup.vsa.filteredSteps = filterStep('replicationGroup.overrideOptions');
				$scope.replicationGroup.vmAdvRestOptions = null;
				$scope.replicationGroup.modifiedVms = null;
				$scope.replicationGroup.selectedContent = _.cloneDeep(collectionFactory.getCollectionContent());
			}

			function setSelectedVMs() {
				return serverService
					.previewCollectionContent({
						collectionContentJson: JSON.stringify(collectionFactory.getCollectionContent()),
						collectionId: 0,
						serverId: $scope.replicationGroup.selectedHypervisor.clientId,
						backupsetId: 0,
						instanceId: $scope.replicationGroup.selectedHypervisor.instanceId,
						applicationId: 106
					})
					.then(
						function(data) {
							let selectedVMs = _.get(data, 'data.scList', []);
							if (_.isEmpty(selectedVMs)) {
								$scope.errorMsg = cvUtil.errMsgLoc('msg.noVMsAvailable');
								return;
							}

							selectedVMs.forEach(vm => {
								vm.strGUID = vm.guid;
								vm.poweredOff = vm.poweredStatus === 0;
								vm.type = 'VM';
							});

							$scope.replicationGroup.selectedVMs = replicationGroupFactory.sortByName(
								_.uniqBy(selectedVMs, 'strGUID')
							);
							$scope.replicationGroup.selectedContent = {
								content: []
							};
							for (var i = 0; i < $scope.replicationGroup.selectedVMs.length; i++) {
								var item = $scope.replicationGroup.selectedVMs[i];
								var converted = {
									displayName: item.name || item.displayName,
									name: item.guid,
									path: '',
									type: item.type,
									allOrAnyChildren: true,
									equalsOrNotEquals: true
								};
								$scope.replicationGroup.selectedContent.content.push(converted);
							}

							return true;
						},
						function(err) {
							return false;
						}
					);
			}

			if (!$scope.replicationGroup.copyDetails) {
				// this is to load copyPrecedence options
				$scope.replicationGroup.copyDetails = {};
			}

			// if it is direct replication then planId will be readily available
			switch ($scope.replicationGroup.attributes.replicationType) {
				case REPLICATION_TYPES.STREAMING_REPLICATION: {
					// if yes get the planId from there
					if ($scope.replicationGroup.selectedVMGroup) {
						$scope.scId = $scope.replicationGroup.selectedVMGroup.subclientId;
						// check copy precedence if applicable (only if subclientId is defined) i.e. for pages where source is defined
						serverService
							.getCollectionDetails($scope.scId)
							.success(function(data) {
								if (data.planEntity && data.planEntity.planId) {
									$scope.planId = data.planEntity.planId;
									self.loadCopyDetails();
								} else {
									// get storage policy associated to the subclient
									var storagePolicyId = data.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId;
									storageService
										.getStoragePolicyDetails(storagePolicyId)
										.success(function(data) {
											setCopyPrecedence(data);
											$scope.ctrl.refreshCopyPrecedence($scope.replicationGroup.copyDetails);
										})
										.error(function(e) {
											//no plan for collection so don't show the storage copy
											$log.error('unable to get storage policy details for policyId:' + storagePolicyId);
										});
								}
							})
							.error(function(data) {
								$log.error('unable to get collection details for collectionid:' + $scope.scId);
							});
						break;
					} else {
						if ($scope.replicationGroup.selectedPlanList && $scope.replicationGroup.selectedPlanList.length) {
							var selectedPlan = $scope.replicationGroup.selectedPlanList[0];
							$scope.planId = selectedPlan.planId;
							self.loadCopyDetails();
						}

						break;
					}
				}
				case REPLICATION_TYPES.DIRECT_REPLICATION: {
					// there is no support to save plan information in taskInfo yet
					if (
						!$scope.replicationGroup.task &&
						$scope.replicationGroup.selectedPlanList &&
						$scope.replicationGroup.selectedPlanList.length
					) {
						$scope.planId = $scope.replicationGroup.selectedPlanList[0].planId;
						// since it is always a snap copy, no need to select copy precedence
						//self.loadCopyDetails();
					}
					break;
				}
				default:
					break;
			}
		};

		self.initialize();
	}
]);

export default mod;
