import 'modules/disasterRecovery/repGrp/js/controllers/repGrpParent.ctrl.js';
import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/controllers/replication.ctrl.js';
import 'vsa/js/controllers/restoreFullHyperV.ctrl.js';
import 'vsa/js/directives/cv-replication-groups-summary-directive.js';
import 'vsa/js/directives/cv-restore-options-amazon-directive.js';
import 'vsa/js/directives/cv-restore-options-oci-directive.js';
import 'vsa/js/directives/cv-restore-options-openstack-directive.js';
import 'vsa/js/directives/cv-restore-options-vmware-directive.js';
import 'vsa/js/factories/vmActions.factory.js';
import 'vsa/js/services/restore.svc.js';

import { vsaAppServerModule } from 'common/js/modules';

var mod = vsaAppServerModule;

/**
 * A controller for handling the functionality on the Configure Replication Group setup page.
 */
mod.controller('replicationGroupOverridesController', [
	'$scope',
	'restoreService',
	'$state',
	'vmFactory',
	'replicationFactory',
	'cvLoc',
	'RESTORE_OPTIONS_MODE_AWS',
	'cvToaster',
	'cvUtil',
	'serverService',
	'$dialogs',
	'REPLICATION_SOLUTIONS',
	'serverUIFactory',
	'cvBreadcrumbsTabsFactory',
	'VENDORS',
	'REPLICATION_TYPES',
	'REP_TYPES',
	'REGEX',
	'AWS_REPLICATION_METHOD',
	'replicationGroupFactory',
	function(
		$scope,
		restoreService,
		$state,
		vmFactory,
		replicationFactory,
		cvLoc,
		RESTORE_OPTIONS_MODE_AWS,
		cvToaster,
		cvUtil,
		serverService,
		$dialogs,
		REPLICATION_SOLUTIONS,
		serverUIFactory,
		cvBreadcrumbsTabsFactory,
		VENDORS,
		REPLICATION_TYPES,
		REP_TYPES,
		REGEX,
		AWS_REPLICATION_METHOD,
		replicationGroupFactory
	) {
		if ($scope.replicationGroup.attributes.refreshBrowser()) {
			return;
		}

		var self = this;
		$scope.ctrl = {};
		cvBreadcrumbsTabsFactory.addBreadCrumbs($scope.replicationGroup.breadCrumbs);

		self.azureVmNamePattern = REGEX.AZURE_VM_NAME;
		$scope.serverMessage = null;
		$scope.error = {};
		$scope.VMsDataLoaded = false;
		$scope.autoSelect = '--Auto select--';

		$scope.ctrl.populateVMsData = function(modifiedVms) {
			if (!$scope.replicationGroup.modifiedVms) {
				$scope.replicationGroup.modifiedVms = {};
			}

			var copyModifiedVms = $scope.replicationGroup.modifiedVms;
			if (modifiedVms) {
				copyModifiedVms = modifiedVms;
			}
			$scope.replicationGroup.modifiedVms = {};

			angular.forEach($scope.replicationGroup.selectedVMs, function(vm) {
				vm.checked = false;
				vm.selected = false;

				// At Override
				if (copyModifiedVms[vm.strGUID] && copyModifiedVms) {
					var modifiedVM = copyModifiedVms[vm.strGUID];

					// Keep the modified override options value
					vm.vmOptions = modifiedVM.vmOptions;
					//For AWS targets the VMs part of the replication group should not contain the datastore/buckets information.
					vm.displayNamePrefixSuffix = modifiedVM.displayNamePrefixSuffix;
					vm.vmNameEditString = modifiedVM.vmNameEditString;
					vm.isModified = modifiedVM.isModified;
					if ($scope.replicationGroup.target.target) {
						if ($scope.replicationGroup.target.target.dataStores && $scope.vendor !== VENDORS.AMAZON.type) {
							vm.vmOptions.Datastore = $scope.replicationGroup.target.target.dataStores[0].dataStoreName;
						}
					}
					setCredentialsInVMOptions(vm.vmOptions);
					$scope.replicationGroup.modifiedVms[vm.strGUID] = vm;
					return;
				}

				var targetDetail;
				// populate the target data to all VMs
				if (
					$scope.replicationGroup.target &&
					$scope.replicationGroup.target.target &&
					$scope.replicationGroup.target.target.entity &&
					$scope.replicationGroup.target.target.entity.targetDetail
				) {
					targetDetail = $scope.replicationGroup.target.target.entity.targetDetail.targetDetail;
				}

				if ($scope.replicationGroup.target && $scope.replicationGroup.target.target && !targetDetail) {
					targetDetail = $scope.replicationGroup.target.target;
				}

				if (!_.has(vm, 'client.clientName')) {
					vm.client = {
						clientName: vm.name
					};
				}

				if (vm.existedVm) {
					var vmGuid;
					if (vm.strGUID) {
						vmGuid = angular.copy(vm.strGUID);
						if (!self.existingAdvRestOptionsMap[vmGuid]) {
							vmGuid = angular.copy(vm.strGUID).toLowerCase();
						}
					} else {
						vmGuid = vm.guid;
					}

					vmFactory.setDefaultRestoreOptions(vm, self.existingAdvRestOptionsMap[vmGuid], null, $scope.vendor);
				} else {
					vmFactory.setDefaultRestoreOptions(vm, null, targetDetail ? targetDetail : undefined, $scope.vendor);
				}

				vm.vmOptions.vmGuid = vm.strGUID;
				vm.vmOptions.sourceClientId = _.get($scope.replicationGroup, 'selectedHypervisor.clientId');
				setCredentialsInVMOptions(vm.vmOptions);

				$scope.replicationGroup.modifiedVms[vm.strGUID] = vm;
			});

			$scope.VMsDataLoaded = true;
		};

		var setVendor = function() {
			$scope.vendor = $scope.replicationGroup.target.target
				? $scope.replicationGroup.target.target.entity.policyType
				: 'VMW';
			//For all the VMWare policy types, show the vendor as 'VMWare'
			if (VENDORS['VMW'].policyTypes.includes($scope.vendor)) {
				$scope.vendor = 'VMW';
			}
			$scope.vendor = serverUIFactory.setVendorName($scope.vendor);
			$scope.replicationGroup.vendor = $scope.vendor;
		};

		self.loadTargetDetail = function() {
			var vmAllocationPolicyId;

			// retrieve the destinationServerId first using vmAllocationPolicyId
			if ($scope.replicationGroup.target && $scope.replicationGroup.target.target) {
				vmAllocationPolicyId = $scope.replicationGroup.target.target.entity.vmAllocPolicyId;
				var loadedTarget = $scope.replicationGroup.loadedTargetsDetail[vmAllocationPolicyId];
				if (loadedTarget) {
					// If the target detail is previously loaded, merge it with current one;
					$scope.replicationGroup.target.target = angular.merge(
						{},
						loadedTarget,
						$scope.replicationGroup.target.target
					);
					$scope.replicationGroup.destinationHyperV = $scope.replicationGroup.target.target.destinationHyperV;
					$scope.replicationGroup.amazonProxyClientForVMList = $scope.replicationGroup.target.target.proxyClientEntity;
					//get data from target and put in vmOptions for each VM
					setVendor();
					$scope.ctrl.populateVMsData();
					afterLoadTarget();
				} else {
					// If the target detail is not previously loaded, call API to load
					restoreService.getReplicationTarget(vmAllocationPolicyId).then(
						function(data) {
							var proxyClientEntity = $scope.replicationGroup.selectedProxy;
							var existingDataStore;
							if (
								$scope.replicationGroup.target.target.entity &&
								$scope.replicationGroup.target.target.entity.selectedAmazonBucket
							) {
								existingDataStore = $scope.replicationGroup.target.target.entity.selectedAmazonBucket;
							} else {
								if ($scope.replicationGroup.target.target.dataStores) {
									existingDataStore = $scope.replicationGroup.target.target.dataStores[0];
								}
							}
							$scope.replicationGroup.target.target = data.data;
							var destinationHyperV = $scope.replicationGroup.target.target.destinationHyperV;
							var policyType = $scope.replicationGroup.target.target.entity.policyType;
							$scope.replicationGroup.target.target.entity.vmAllocPolicyType = policyType;
							if (proxyClientEntity && proxyClientEntity[0]) {
								$scope.replicationGroup.target.target.proxyClientEntity = proxyClientEntity[0];
							}

							if (existingDataStore) {
								if (!$scope.replicationGroup.target.target.dataStores) {
									$scope.replicationGroup.target.target['dataStores'] = [
										{
											dataStoreName: existingDataStore.dataStoreName
										}
									];
								} else {
									$scope.replicationGroup.target.target.dataStores[0].dataStoreName = existingDataStore.dataStoreName;
								}
							}
							$scope.replicationGroup.amazonProxyClientForVMList =
								$scope.replicationGroup.target.target.proxyClientEntity;
							$scope.replicationGroup.loadedTargetsDetail[vmAllocationPolicyId] = $scope.replicationGroup.target.target;
							setVendor();
							$scope.replicationGroup.destinationHyperV = destinationHyperV;
							//get data from target and put in vmOptions for each VM
							$scope.ctrl.populateVMsData();
							afterLoadTarget();
						},
						function(err) {
							// should not be an error here as the target list has already been retrieved on the previous page
						}
					);
				}
			} else {
				// in case there is no target (JAVA GUI created)
				$scope.ctrl.populateVMsData();
				afterLoadTarget();
			}
		};

		self.initialize = function() {
			$scope.replicationGroup.currentStep = 3;
			$scope.replicationGroup.restoreOptionsAWSMode = RESTORE_OPTIONS_MODE_AWS.RESTORE;
			self.loadTargetDetail();

			/*
			 * TO-DO: Currently, cv-replication-groups-summary needs replicatonType from REPLICATION_TYPES.
			 * Change it so that it can read from REP_TYPES
			 */
			if ($scope.replicationGroup.replicationType === REP_TYPES.PERIODIC) {
				self.replicationType = REPLICATION_TYPES.STREAMING_REPLICATION;
			} else if ($scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS) {
				self.replicationType = REPLICATION_TYPES.CONTINUOUS_REPLICATION;
			}
		};

		function afterLoadTarget() {
			$scope.ctrl.createReplicationGroup();
			self.loadGrid = true;

			/* Show guest credentials if the replication is Non AWS - AWS with amazon proxy */
			$scope.replicationGroup.showGuestCredentials =
				$scope.replicationGroup.isAmazonProxy && $scope.replicationGroup.isAWSCrossRestore;
		}

		var isAutoSelect = function(name) {
			return name === $scope.autoSelect;
		};

		$scope.goBackToPreviouseStep = function() {
			$scope.replicationGroup.addNewVm = false;
			$scope.replicationGroup.currentStep--;
			$state.go('replicationGroup.recoveryOptions');
		};

		$scope.ctrl.refreshVm = function() {
			$scope.error.vmDisplayName = null;
			$scope.error.missingStorageAccount = null;
			$scope.serverMessage = null;
		};

		$scope.goToSummary = function() {
			var error = false;
			$scope.serverMessage = null;
			$scope.ctrl.createReplicationGroup();
			$scope.replicationGroup.addNewVm = false;

			if ($scope.error.missingStorageAccount) {
				$scope.serverMessage = cvUtil.errMsg($scope.error.missingStorageAccount);
			} else if ($scope.error.vmDisplayName) {
				if ($scope.replicationGroup.vendor === VENDORS.AZURE_V2.type) {
					$scope.error.vmDisplayName = $scope.error.vmDisplayName.slice(0, $scope.error.vmDisplayName.length - 2);
				}
				$scope.serverMessage = cvUtil.errMsg($scope.error.vmDisplayName);
			}

			error = $scope.allErrorVMs && $scope.allErrorVMs.length > 0;

			if (isAmazonVendor($scope.replicationGroup.vendor) && !error) {
				//Warning message to prompt user to proceed using hot add method by entering the guest credentials
				if (showHotAddWarning()) {
					const callBackFunctions = {
						noFunction() {
							$scope.replicationGroup.awsReplicationMethodSelected = AWS_REPLICATION_METHOD.IMPORT;
							$scope.serverMessage = null;
							$state.go('replicationGroup.summary');
							$scope.replicationGroup.currentStep++;
						},
						yesFunction: () => {
							$scope.replicationGroup.enableOverrideOptions = true;
							$scope.replicationGroup.awsReplicationMethodSelected = AWS_REPLICATION_METHOD.HOTADD;
						}
					};
					const awsProxyName = _.get($scope, 'replicationGroup.selectedProxy[0].clientName');
					$dialogs.confirm(
						cvLoc('label.confirm'),
						cvLoc('info.hotAddWarning', `<b>${awsProxyName}</b>`),
						callBackFunctions
					);
					return;
				}
			}

			if ($scope.vendor === VENDORS.ORACLE_CLOUD_INFRASTRUCTURE.type) {
				if (
					$scope.replicationGroup.vmAdvRestOptions &&
					$scope.replicationGroup.vmAdvRestOptions[0].vmSize === undefined
				) {
					error = true;
					$scope.serverMessage = cvUtil.errMsg(cvLoc('error.missingShape'));
				}
			}

			if (!error) {
				$scope.serverMessage = null;
				$state.go('replicationGroup.summary');
				$scope.replicationGroup.currentStep++;
			} else {
				$scope.replicationGroup.enableOverrideOptions = true;
			}
		};
		$scope.allErrorVMs = [];
		$scope.ctrl.createReplicationGroup = function() {
			$scope.error.vmDisplayName = false;
			$scope.amazonBucketMissing = false;
			$scope.allErrorVMs = [];

			if ($scope.ctrl && $scope.ctrl.openVmListSelection) {
				$scope.ctrl.openVmListSelection();
			}

			$scope.replicationGroup.vmAdvRestOptions = [];
			// add the rest of the vms into modified vms so that the adv restore options are populated for those vms as well

			// now convert adv restore options data and store in a separate array
			$scope.replicationGroup.modifiedVmsList = [];
			angular.forEach($scope.replicationGroup.modifiedVms, function(vm, guid) {
				$scope.replicationGroup.modifiedVmsList.push(vm);
				let { vmAdvOptions, errors } = replicationGroupFactory.createAdvanceRestoreOptions(
					vm,
					$scope.vendor,
					$scope.replicationGroup
				);
				$scope.replicationGroup.vmAdvRestOptions.push(vmAdvOptions);

				if (errors) {
					$scope.allErrorVMs.push(vmAdvOptions);
					$scope.error.missingStorageAccount = _.get(errors, 'missingStorageAccount');
					if ($scope.replicationGroup.vendor === VENDORS.AZURE_V2.type) {
						if (_.get(errors, 'vmDisplayName')) {
							if (!$scope.error.vmDisplayName) {
								$scope.error.vmDisplayName = cvLoc('error.invalidAzureDisplayNameMachines');
							}
							$scope.error.vmDisplayName += `${vm.name}, `;
						}
					} else {
						$scope.error.vmDisplayName = _.get(errors, 'vmDisplayName');
					}
				}
			});

			//set destinationVendor
			$scope.replicationGroup.target.replicationSchedule.options.restoreOptions.volumeRstOption.destinationVendor =
				$scope.vendor;
			$scope.vendorType = cvUtil.lookupEnumConstant($scope.vendor);

			return $scope.replicationGroup.vmAdvRestOptions;
		};

		/*
		 * Show the hot add warning if<br>
		 * - If the VM is eligible for guest credentials<br>
		 * - If the guest credentials are not already entered for all the VM's<br>
		 * - If the warning is already shown and the user has selected the AWS Replication method
		 */
		function showHotAddWarning() {
			return (
				$scope.replicationGroup.showGuestCredentials &&
				!areGuestCredentialsEnteredForAllInstances($scope.replicationGroup.modifiedVmsList) &&
				!$scope.replicationGroup.awsReplicationMethodSelected
			);
		}

		function areGuestCredentialsEnteredForAllInstances(vms) {
			let instancesWithGuestCredentials = vms.filter(vm => _.get(vm, 'vmOptions.guestCredentials.checked', false));
			return instancesWithGuestCredentials.length == vms.length;
		}

		function isAmazonVendor(vendor) {
			return vendor && vendor === VENDORS.AMAZON.type;
		}

		/* Sets the credentials in the vmOptions of each VM */
		function setCredentialsInVMOptions(vmOptions) {
			if (!vmOptions) {
				return;
			}

			if (_.isEmpty(vmOptions.credentialsModel)) {
				vmOptions.credentialsModel = _.cloneDeep($scope.replicationGroup.credentialsModel);
			}
		}

		self.initialize();
	}
]);

export default mod;
