<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-app="drApp.failover">
	<div class="setup-title">
		<h1>{{machineDetailsController.machineName}}</h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body">
			<div class="data-form-horizontal">
				<form ng-submit="machineDetailsController.save()">
					<div class="row form-group">
						<div class="col-md-4">
							<label for="priority"><cv:msg key="label.priority" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="number" id="priority" data-ng-model="machineDetailsController.priority" data-ng-min="1" ng-required autofocus>
						</div>
					</div>
					<div class="row form-group">
						<div class="col-md-12">
							<span class="{{machineDetailsController.priorityValidation.type}}">{{machineDetailsController.priorityValidation.message}}</span>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="machineDetailsDialog_button_#8987" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="machineDetailsController.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="machineDetailsDialog_button_#1367" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="machineDetailsController.save()"><cv:msg key="Save" bundle="messages"/></button> 
		</div>
	</div>
</div>