<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvEnum name="App.VSAReplicationStatus"></cv:cvEnum>
	<cv:cvEnum name="App.VSAFailoverStatus"></cv:cvEnum>
	<cv:cvEnum name="App.DRTestFailoverStatus"></cv:cvEnum>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
	<cv:cvEnum name="Api.AutoFailoverStatus"></cv:cvEnum>
	<cv:cvEnum name="Ida.VAppSource"></cv:cvEnum>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="page-title">{{fgDetailsController.vApp.vAppEntity.vAppName}}</h1>
		<span data-ng-show="fgDetailsController.isGroupDataLoading" class="grid-data-spinner ng-hide">
			<img ng-src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
		</span>
		<div class="cv-main-bar-actions cv-main-bar-flex page-action-item" data-ng-if="fgDetailsController.actions.length">
			<div ng-repeat="action in fgDetailsController.actions | limitTo:2 track by $index"
                ng-init="rowIndex = $index"
				class="cv-main-bar-action menu tabAction"
				data-ng-click="fgDetailsController.performAction(rowIndex)"><span data-ng-bind="action.title"></span><span ng-if="action.dropdown" class="k-icon k-i-arrow-60-down k-menu-expand-arrow"></span></div>
            <div ng-if="fgDetailsController.actions.length > 2" class="no-padding cv-main-bar-dropdown-menu menu" uib-dropdown>
				<a class="uib-dropdown-toggle main-tab-menu-toggle" uib-dropdown-toggle>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" width="20" height="20"><path d="M10.1 0C4.6-.1.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9v-.2C19.9 4.5 15.5.1 10.1 0zm0 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9-4 9-9 9z"/><path d="M6.1 8.8h2v2h-2zM9.1 8.8h2v2h-2zM12.1 8.8h2v2h-2z"/></svg>
				</a>
				<ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2" id="moreActions">
					<li class="no-padding" data-ng-repeat="action in fgDetailsController.actions | limitTo: fgDetailsController.actions.length - 2 : 2 track by $index" ng-init="rowIndex = $index+2">
						<a class="tabAction" data-ng-click="fgDetailsController.performAction(rowIndex)">
							<span data-ng-bind="action.title"></span>
						</a>
					</li>
				</ul>
            </div>
        </div>
	</div>
</div>
<div class="row">
	<div class="col-lg-6 col-md-12">
		<cv-tile-component data-ac-id="failoverDetails-label_groupDetails-dr" data-title='<cv:msg key="label.groupDetails" bundle="dr"/>' show-edit="true" loader="!fgDetailsController.isGroupDataLoading">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.groupName" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.vAppEntity.vAppName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.sourceHypervisor" bundle="dr"/></span>
					<span class="pageDetailColumn"><a ng-href="{{fgDetailsController.sourceHypvervisorHref}}">{{fgDetailsController.vApp.selectedEntities[0].entityName}}</a></span>
				</li>
				<li class="group" data-ng-if="!fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.sourceHypervisorVendor" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.machinesList[0].vendorText}}</span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.vApp.isFailoverGroup && !fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.destinationHypervisor" bundle="dr"/></span>
					<span class="pageDetailColumn"><a ng-href="{{fgDetailsController.destinationHypervisorHref}}">{{fgDetailsController.machinesList[0].destinationClient.clientName}}</a></span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.vApp.isFailoverGroup && !fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.destinationHypervisorVendor" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.machinesList[0].destVendorText}}</span>
				</li>
				<li class="group" data-ng-if="!fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.source" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.vAppSourceText}}</span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.vApp.isFailoverGroup && !fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.approvalToRunTasksShort" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.approvalRequired == true ? "Yes" : "No"}}</span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.vApp.isFailoverGroup && !fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.userToApproveOrNotify" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.usersForApproval || fgDetailsController.vApp.usersForApproval.length > 0 ? fgDetailsController.vApp.usersForApproval[0].fullName : ""}}</span>
				</li>
				<li class="group" data-ng-if="(fgDetailsController.vApp.isFailoverGroup || fgDetailsController.vApp.isTestFailoverGroup) && fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.operationType" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.operationType}}</span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.vApp.isSnapDR && !fgDetailsController.vApp.isTestFailoverGroup">
					<span class="pageDetailColumn"><cv:msg key="label.vmGroups" bundle="collectionsJs"/></span>
					<span class="pageDetailColumn">
						<a ng-href="#/collectionDetails/{{fgDetailsController.vApp.selectedEntities[0].entityId}}/{{fgDetailsController.vApp.arrayReplication.subclient.subclientId}}">
							{{fgDetailsController.vApp.arrayReplication.subclient.subclientName}}
						</a>
					</span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.copy" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.arrayReplication.copy.storagePolicyName}} / {{fgDetailsController.vApp.arrayReplication.copyName}}</span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.vApp.isSnapDR">
					<span class="pageDetailColumn"><cv:msg key="label.destinationHypervisor" bundle="dr"/></span>
					<span class="pageDetailColumn">
						<a ng-href="#/servers/{{fgDetailsController.vApp.arrayReplication.destination.clientId}}">{{fgDetailsController.vApp.arrayReplication.destination.clientName}}</a>
					</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.priorityIntervalInMins" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.config.vmGroups[0].delay}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.continueOnFailure" bundle="dr"/></span>
					<span class="pageDetailColumn">{{fgDetailsController.vApp.config.vmGroups[0].continueOnFailure == true ? "Yes" : "No"}}</span>
				</li>
				<li class="group" data-ng-if="fgDetailsController.targetAvailable && !fgDetailsController.vApp.isSnapDR">
					<span data-ng-if="fgDetailsController.vApp.isFailoverGroup">
						<span class="pageDetailColumn" data-ng-if="fgDetailsController.vApp.isFailoverGroup">
							<cv:msg key="label.virtualLabTarget" bundle="dr"/>
						</span>
						<span class="pageDetailColumn">
							<a ng-href="#/lifeCyclePolicyDetails/{{fgDetailsController.vApp.policy.entity.vmAllocPolicyId}}">{{fgDetailsController.vApp.policy.entity.vmAllocPolicyName}}</a>
						</span>
					</span>
					<span data-ng-if="fgDetailsController.vApp.isDevtestGroup">
						<span class="pageDetailColumn">
							<cv:msg key="label.lifeCyclePolicy" bundle="dr"/>
						</span>
						<span class="pageDetailColumn">
							<a ng-href="#/lifeCyclePolicyDetails/{{fgDetailsController.vApp.policy.entity.vmAllocPolicyId}}">{{fgDetailsController.vApp.policy.entity.vmAllocPolicyName}}</a>
						</span>
					</span>
				</li>
			</ul>
			<div class="page-details-box-links" data-ng-if="!fgDetailsController.vApp.isSnapDR">
                <a href="" data-ng-click="fgDetailsController.modifyBasicDetails(fgDetailsController.vApp)"><cv:msg key="label.edit" bundle="dr"/></a>
            </div>
		</cv-tile-component>
		<div data-ng-if="fgDetailsController.showAutoFailoverOptions">
			<cv-tile-component data-ac-id="failoverDetails-label_autofailoverOptions-dr" data-title='<cv:msg key="label.autofailoverOptions" bundle="dr"/>'>
				<div class="page-details-box-links">
					<div data-ng-show="!fgDetailsController.vApp.autofailover.machine">
						<a href="" data-ng-click="fgDetailsController.addMonitoringMachines(fgDetailsController.vApp)"><cv:msg key="label.addMonitoringMachines" bundle="dr"/></a>
					</div>
					<div data-ng-show="fgDetailsController.vApp.autofailover.status == 'MNTR_DISABLED' || fgDetailsController.vApp.autofailover.status == 'MNTR_FAILED'">
						<a href="" data-ng-click="fgDetailsController.startMonitoring(fgDetailsController.vApp)"><cv:msg key="label.startMonitoring" bundle="dr"/></a>
					</div>
					<div data-ng-show="fgDetailsController.vApp.autofailover.status == 'MNTR_ENABLED'">
						<a href="" data-ng-click="fgDetailsController.stopMonitoring(fgDetailsController.vApp)"><cv:msg key="label.stopMonitoring" bundle="dr"/></a>
					</div>
					<div data-ng-show="fgDetailsController.vApp.autofailover.status == 'MNTR_STARTING'">
						<label><cv:msg key="label.monitoringIsStarting" bundle="dr"/></label>
					</div>
				</div>
				<div>
					<ul class="list-style-secondary">
						<li class="group" data-ng-show="fgDetailsController.vApp.autofailover.machine">
							<span class="pageDetailColumn"><cv:msg key="label.autofailoverDelay" bundle="dr"/></span>
							<span class="pageDetailColumn">{{fgDetailsController.vApp.autofailover.timeThresholdBeforeFailover}}</span>
						</li>
						<li class="group" data-ng-show="fgDetailsController.vApp.autofailover.machine">
							<span class="pageDetailColumn"><cv:msg key="label.monitoringMachines" bundle="dr"/></span>
							<span class="pageDetailColumn">{{fgDetailsController.vApp.autofailover.machineNames}}</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.autofailoverStatus" bundle="dr"/></span>
							<span class="pageDetailColumn">{{fgDetailsController.vApp.autofailover.statusText}}</span>
						</li>
					</ul>
				</div>
			</cv-tile-component>
		</div>
	</div>
	<div class="col-lg-6 col-md-12" data-ng-if="fgDetailsController.vApp.isFailoverGroup && !fgDetailsController.vApp.isSnapDR">
		<cv-tile-component data-ac-id="failoverDetails-label_plannedFailoverSchedules-dr" data-title='<cv:msg key="label.plannedFailoverSchedules" bundle="dr"/>' loader="!fgDetailsController.isPlannedFailoverSchedulesLoading">
			<div class="page-details-box-links">
				<a href="" data-ng-click="fgDetailsController.addSchedule(fgDetailsController.vApp.vAppEntity.vAppId, 'PLANNED_FAILOVER')"><cv:msg key="label.addSchedule" bundle="dr"/></a>
			</div>
			<div class="schedule-list">
				<ul class="add-schedule__List list-style-secondary" data-ng-repeat="schedule in fgDetailsController.plannedFailoverSchedules track by $index">
					<li class="ellipsis-parent ellipsis-content group">
						<span class="pageDetailColumn">
							<a data-ng-click="fgDetailsController.editSchedule(schedule, 'PLANNED_FAILOVER')">{{schedule.name}}</a>
						</span>
					</li>
				</ul>
				<ul class="add-schedule__List list-style-secondary" data-ng-if="fgDetailsController.plannedFailoverSchedules.length==0">
					<li class="ellipsis-parent ellipsis-content group">
						<span class="pageDetailColumn">
							<cv:msg key="error.noScheduleAdded" bundle="schedule"/>
						</span>
					</li>
				</ul>
			</div>
		</cv-tile-component>
		<cv-tile-component data-ac-id="failoverDetails-label_testBootSchedules-dr" data-title='<cv:msg key="label.testBootSchedules" bundle="dr"/>' loader="!fgDetailsController.isTestbootSchedulesLoading" data-ng-if="fgDetailsController.testBootAllowed">
			<div class="page-details-box-links">
				<a href="" data-ng-click="fgDetailsController.addSchedule(fgDetailsController.vApp.vAppEntity.vAppId, 'TEST_BOOT')"><cv:msg key="label.addSchedule" bundle="dr"/></a>
			</div>
			<div class="schedule-list">
				<ul class="add-schedule__List list-style-secondary" data-ng-repeat="schedule in fgDetailsController.testBootSchedules track by $index">
					<li class="ellipsis-parent ellipsis-content group">
						<span class="pageDetailColumn">
							<a data-ng-click="fgDetailsController.editSchedule(schedule, 'TEST_BOOT')">{{schedule.name}}</a>
						</span>
					</li>
				</ul>
				<ul class="add-schedule__List list-style-secondary" data-ng-if="fgDetailsController.testBootSchedules.length==0">
					<li class="ellipsis-parent ellipsis-content group">
						<span class="pageDetailColumn">
							<cv:msg key="error.noScheduleAdded" bundle="schedule"/>
						</span>
					</li>
				</ul>
			</div>
		</cv-tile-component>
	</div>
	<div class="col-xs-12 col-sm-6" data-ng-if="fgDetailsController.vApp.isSnapDR && (fgDetailsController.vApp.isFailoverGroup || fgDetailsController.vApp.isTestFailoverGroup)">
		<cv-tile-component data-ac-id="failoverDetails-tile-esx" data-title='<cv:msg key="title.esxServerMapping" bundle="dr"/>' loader="!fgDetailsController.isGroupDataLoading">
			<ul class="list-style-secondary" 
				data-ng-repeat="esx in fgDetailsController.vApp.arrayReplication.server | orderBy track by $index">
				<li class="group" title="{{esx.sourceServer}} - {{esx.destinationServer}}">
					<span>{{esx.sourceServer}} - {{esx.destinationServer}}</span>
				</li>
			</ul>
		</cv-tile-component>
	</div>
</div>
<div class="row">
	<span data-ng-show="fgDetailsController.isMachineDataLoading" class="grid-data-spinner ng-hide">
		<img ng-src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
	</span>
	<div class="col-md-12" data-ng-show="!fgDetailsController.isMachineDataLoading">
		<cv-grid cv-grid-options="fgDetailsController.gridOptions" data-ng-if="!fgDetailsController.vApp.isSnapDR"></cv-grid>
	</div>
	<div class="col-md-12" data-ng-if="!fgDetailsController.vApp.machines.isLoading">
		<dr-machines machines="fgDetailsController.vApp.machines" data-ng-if="fgDetailsController.vApp.isSnapDR"></dr-machines>
	</div>
</div>
<div data-ng-if="fgDetailsController.vApp.policy">
	<cv-vsa-virtual-lab
		policy-entity="fgDetailsController.vApp.policy.entity">
	</cv-vsa-virtual-lab>
</div>