<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-app="drApp.failover" data-ng-controller="drScriptController as script">
	<div class="setup-title">
		<h1 data-ng-if="script.isPreScript" ><cv:msg key="label.preScriptOptions" bundle="dr"/></h1>
		<h1 data-ng-if="script.isPostScript" ><cv:msg key="label.postScriptOptions" bundle="dr"/></h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body">
			<div class="form-horizontal">
				<form data-ng-submit="script.save()">
					<div class="form-group" data-ng-if="script.isAppValidationScript">
						<div class="col-xs-12 col-sm-4">
							<label for="applicationName"><cv:msg key="label.applicationName" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="text" id="appName" data-ng-model="script.appName" data-ng-change="script.validateAppName()" ng-required="script.isAppValidationScript" autofocus>
							<div class="help-block" data-ng-if="script.networkPathValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.networkPathValidationMsg.text}}
							</div>
						</div>
					</div>
					<div class="form-group">
						<div class="col-xs-12 col-sm-4">
							<label for="uncNetworkPath"><cv:msg key="label.uncNetworkPath" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="text" id="uncNetworkPath" data-ng-model="script.uncNetworkPath" data-ng-change="script.validateNetworkPath()" ng-required autofocus>
							<div class="help-block" data-ng-if="script.networkPathValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.networkPathValidationMsg.text}}
							</div>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-4">
							<label for="username"><cv:msg key="label.userName" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="text" id="username" data-ng-model="script.username" data-ng-change="script.validateUserName()" ng-required>
							<div class="help-block" data-ng-if="script.userNameValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.userNameValidationMsg.text}}
							</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="script.isEditMode && !script.changePassword">
						<div class="col-md-12">
							<a href="" data-ng-click="script.changePassword=true">
								<cv:msg key="label.changePassword" bundle="dr" />
							</a>
						</div>
					</div>
					<div class="form-group" data-ng-show="!script.isEditMode || script.changePassword">
						<div class="col-xs-12 col-sm-4">
							<label for="password"><cv:msg key="label.password" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="password" id="password" data-ng-model="script.password" data-ng-change="script.validatePassword()" ng-required>
							<div class="help-block" data-ng-if="script.passwordValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.passwordValidationMsg.text}}
							</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="!script.isEditMode || script.changePassword">
						<div class="col-xs-12 col-sm-4">
							<label for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="password" id="confirmPassword" data-ng-model="script.confirmPassword" data-ng-change="script.validateConfirmPassword()" ng-required>
							<div class="help-block" data-ng-if="script.confirmPasswordValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.confirmPasswordValidationMsg.text}}
							</div>
						</div>
					</div>
					<div class="form-header push-down" data-ng-if="!script.isAppValidationScript"><cv:msg key="label.vmGuestOptions" bundle="dr"/></div>
					<div class="form-group">
						<div class="col-xs-12 col-sm-4">
							<label for="usernameuserImpersonation"><cv:msg key="label.userName" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="text" id="usernameuserImpersonation" data-ng-model="script.userImpersonation.username" data-ng-change="script.validateUIUserName()" ng-required="!script.isAppValidationScript">
							<div class="help-block" data-ng-if="script.userImpersonation.userNameValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.userImpersonation.userNameValidationMsg.text}}
							</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="script.isEditMode && !script.changeImpersonationPassword && !script.isAppValidationScript">
						<div class="col-md-12">
							<a href="" data-ng-click="script.changeImpersonationPassword=true">
								<cv:msg key="label.changePassword" bundle="dr" />
							</a>
						</div>
					</div>
					<div class="form-group" data-ng-if="(!script.isAppValidationScript || (!script.isEditMode || script.changeImpersonationPassword))">
						<div class="col-xs-12 col-sm-4">
							<label for="passworduserImpersonation"><cv:msg key="label.password" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="password" id="passworduserImpersonation" data-ng-model="script.userImpersonation.password" data-ng-change="script.validateUIPassword()" ng-required="!script.isAppValidationScript">
							<div class="help-block" data-ng-if="script.userImpersonation.passwordValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.userImpersonation.passwordValidationMsg.text}}
							</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="(!script.isAppValidationScript || (!script.isEditMode || script.changeImpersonationPassword))">
						<div class="col-xs-12 col-sm-4">
							<label for="confirmPassworduserImpersonation"><cv:msg key="label.confirmPassword" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="password" id="confirmPassworduserImpersonation" data-ng-model="script.userImpersonation.confirmPassword" data-ng-change="script.validateUIConfirmPassword()" ng-required>
							<div class="help-block" data-ng-if="script.userImpersonation.confirmPasswordValidationMsg.text">
								<i class="ion-alert-circled"></i>
								{{script.userImpersonation.confirmPasswordValidationMsg.text}}
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="drScriptDialog_button_#2520" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="script.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="drScriptDialog_button_#3442" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="script.save()"><cv:msg key="Save" bundle="messages"/></button> 
		</div>
	</div>
</div>