<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div class="form-group">
	<label class="col-xs-12 col-sm-5"><cv:msg key="label.sourceNetwork" bundle="dr"/></label>
	<div class="col-xs-12 col-sm-7">
		<isteven-multi-select
			input-model="drNetworkCtrl.sourceNetworks"
	        output-model="drNetworkCtrl.sourceNetwork"
			id="drSourceNetworks"	        
			name="drSourceNetworks"
	        tick-property="selected"
	        button-label="networkName"
	        class="isteven-multi-select"
	        item-label="networkName"
	        selection-mode="single">
	    </isteven-multi-select>
	    <div class="help-block" data-ng-if="drNetworkCtrl.errors.sourceNetwork">
			<i class="ion-alert-circled"></i>
			<span data-ng-bind="drNetworkCtrl.errors.sourceNetwork"/>
		</div>
	</div>
</div>

<div class="form-group">
	<label class="col-xs-12 col-sm-5"><cv:msg key="label.destinationNetwork" bundle="dr"/></label>
	<div class="col-xs-12 col-sm-7">
		<isteven-multi-select
			input-model="drNetworkCtrl.destinationNetworks"
	        output-model="drNetworkCtrl.destinationNetwork"
	        id="drDestinationNetworks"
	        name="drDestinationNetworks"
	        tick-property="selected"
	        button-label="networkName"
	        class="isteven-multi-select"
	        item-label="networkName"
	        selection-mode="single">
	    </isteven-multi-select>
	    <div class="help-block" data-ng-if="drNetworkCtrl.errors.destinationNetwork">
			<i class="ion-alert-circled"></i>
			<span data-ng-bind="drNetworkCtrl.errors.destinationNetwork"></span>
		</div>
	</div>
</div>

<div class="form-group">
	<div class="col-xs-12">
		<button type="button" data-ng-click="drNetworkCtrl.addNetwork()" class="btn btn-default">
			<cv:msg key="label.addToList" bundle="dr" />
		</button>
	</div>
</div>

<div class="form-group">
	<label class="col-xs-12">
		<h4><cv:msg key="label.networkMappingList" bundle="dr"/></h4>
	</label>
</div>

<div id="networks">
	<div class="filters-list-wrapper">
		<ul data-ng-repeat="nic in drNetworkCtrl.server.nics | orderBy track by $index">
			<li title="{{nic.sourceNetwork}} - {{nic.destinationNetwork}}">
				<label class="padding-left-0">
					{{nic.sourceNetworkLabel}} - {{nic.destinationNetworkLabel}}
				</label>
				<span class="delete-row">
					<a data-ng-click="drNetworkCtrl.deleteNetworkRow(nic)"
					title="<cv:msg key='label.remove' bundle='dr'/> {{nic.sourceNetworkLabel}} - {{nic.destinationNetworkLabel}}">&times;</a>
				</span>
			</li>
		</ul>
	</div>
</div>