<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="page-title">{{dgDetailsCtrl.vApp.vAppEntity.vAppName}} </h1>
		<span>
			<a class="page-action-item" href="" data-ng-click="dgDetailsCtrl.deleteGroup()">
				<cv:msg key="Delete" bundle="messages"/>
			</a>
		</span>
		<span>
			<a class="page-action-item" href="" data-ng-click="dgDetailsCtrl.editGroup()">
				<cv:msg key="label.edit" bundle="dr"/>
			</a>
        </span>
        <span>
			<a class="page-action-item" href="" data-ng-click="dgDetailsCtrl.createVirtualLab()">
				<cv:msg key="label.createVirtualLab" bundle="dr"/>
			</a>
        </span>
	</div>
</div>
<div class="row">
	<div class="col-xs-12 col-md-6">
		<cv-tile-component data-ac-id="label_groupDetails-dr" data-title='<cv:msg key="label.groupDetails" bundle="dr"/>'>
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.groupName" bundle="dr"/></span>
					<span class="pageDetailColumn">{{dgDetailsCtrl.vApp.vAppEntity.vAppName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.serversAndHypervisors" bundle="dr"/></span>
					<span class="pageDetailColumn">{{dgDetailsCtrl.vApp.selectedEntities[0].entityName}}</span>
				</li>
				<li class="group" data-ng-if="::dgDetailsCtrl.isSnapArrayReplication">
					<span class="pageDetailColumn"><cv:msg key="label.vmGroups" bundle="collectionsJs"/></span>
					<span class="pageDetailColumn">
						<a ng-href="#/collectionDetails/{{dgDetailsCtrl.vApp.selectedEntities[0].entityId}}/{{dgDetailsCtrl.vApp.arrayReplication.subclient.subclientId}}">
							{{dgDetailsCtrl.vApp.arrayReplication.subclient.subclientName}}
						</a>
					</span>
				</li>
				<li class="group" data-ng-if="::dgDetailsCtrl.isSnapArrayReplication">
					<span class="pageDetailColumn"><cv:msg key="label.copy" bundle="dr"/></span>
					<span class="pageDetailColumn">{{dgDetailsCtrl.vApp.arrayReplication.copyName}}</span>
				</li>
				<li class="group" data-ng-if="::dgDetailsCtrl.isSnapArrayReplication">
					<span class="pageDetailColumn"><cv:msg key="label.lifeCyclePolicy" bundle="dr"/></span>
					<span class="pageDetailColumn">
						<a ng-href="#/lifeCyclePolicyDetails/{{dgDetailsCtrl.vApp.policy.entity.vmAllocPolicyId}}">{{dgDetailsCtrl.vApp.policy.entity.vmAllocPolicyName}}</a>
					</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.continueOnFailure" bundle="dr"/></span>
					<span class="pageDetailColumn">{{dgDetailsCtrl.vApp.config.vmGroups[0].continueOnFailure == true ? "Yes" : "No"}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.priorityIntervalInMins" bundle="dr"/></span>
					<span class="pageDetailColumn">{{dgDetailsCtrl.vApp.config.vmGroups[0].delay}}</span>
				</li>
			</ul>
		</cv-tile-component>
	</div>
</div>
<div class="row" data-ng-if="dgDetailsCtrl.vApp">
	<div class="col-xs-12">
		<dr-machines v-app="dgDetailsCtrl.vApp"></dr-machines>
	</div>
</div>