import { drAppFailoverModule } from 'common/js/modules';

var failoverMod = drAppFailoverModule;
failoverMod.service('failoverService', [
	'$http',
	'$q',
	function($http, $q) {
		this.cancelAllPendingRequests = function() {
			if ($http.pendingRequests) {
				$http.pendingRequests.forEach(request => {
					if (request.cancel) {
						request.cancel.resolve();
					}
				});
			}
		};

		this.createFailoverGroup = function(obj) {
			return $http.post('failoverGroup.do', obj);
		};

		this.getFailoverGroupDetails = function(vAppId) {
			return $http.get('failoverGroup.do?vAppId=' + vAppId);
		};

		this.getFailoverGroups = function() {
			return $http.get('failoverGroups.do');
		};

		this.getDevtestGroupDetails = function(vAppId) {
			return $http.get('devtestGroup.do?vAppId=' + vAppId);
		};

		this.getDevtestGroups = function() {
			return $http.get('devtestGroups.do');
		};

		this.updateFailoverGroup = function(obj) {
			return $http.post('updateFailoverGroup.do', obj);
		};

		this.deleteFailoverGroup = function(vAppId) {
			return $http.delete('failoverGroup.do?vAppId=' + vAppId);
		};

		this.performUndoFailover = function(vApp, drOrchestrationType, subclientId) {
			return $http.post('failback.do', {
				vApp: vApp,
				drOrchestrationType: drOrchestrationType,
				subclientId: subclientId
			});
		};

		this.performFailback = function(vApp, subclientId) {
			var drOrchestrationType = JSON.stringify('2');
			return $http.post('failback.do', {
				vApp: vApp,
				drOrchestrationType: drOrchestrationType,
				subclientId: subclientId
			});
		};

		this.performPlannedFailover = function(vApp) {
			var drOrchestrationType = JSON.stringify('1');
			return $http.post('failover.do', {
				vApp: vApp,
				drOrchestrationType: drOrchestrationType
			});
		};

		this.performUnplannedFailover = function(vApp) {
			var drOrchestrationType = JSON.stringify('3');
			return $http.post('failover.do', {
				vApp: vApp,
				drOrchestrationType: drOrchestrationType
			});
		};

		this.performTestBoot = function(vApp, skipDisableNetworkAdapter) {
			var drOrchestrationType = JSON.stringify('7');
			return $http.post('failover.do', {
				vApp: vApp,
				drOrchestrationType: drOrchestrationType,
				skipDisableNetworkAdapter: skipDisableNetworkAdapter
			});
		};

		this.performTestFailover = function(vApp, repIds) {
			var drOrchestrationType = JSON.stringify('11');
			return $http.post('failover.do', {
				vApp: vApp,
				drOrchestrationType: drOrchestrationType,
				repIds: repIds
			});
		};

		this.performUndoTestFailover = function(vApp, repIds) {
			var drOrchestrationType = JSON.stringify('13');
			return $http.post('failover.do', {
				vApp: vApp,
				drOrchestrationType: drOrchestrationType,
				repIds: repIds
			});
		};

		this.getMachinesList = function(entityID, entityType, vAppSource) {
			return $http.get(
				'failoverMachines.do?entityID=' + entityID + '&entityType=' + entityType + '&vAppSource=' + vAppSource
			);
		};

		this.getDRJobDetails = function(jobId) {
			return $http.get('drJobDetails.do?jobId=' + jobId);
		};

		this.getServerAndServerGroups = function() {
			return $http.get('getServerAndServerGroups.do');
		};

		this.createSchedule = function(obj) {
			return $http.post('drGroupSchedule.do', {
				schedule: obj.schedule,
				virtualApp: obj.virtualApp,
				drOrchestrationType: obj.drOrchestrationType
			});
		};

		this.getSchedules = function(drOrchestrationType, vAppId) {
			return $http.get('drGroupSchedules.do?drOrchestrationType=' + drOrchestrationType + '&vAppId=' + vAppId);
		};

		this.modifySchedule = function(obj) {
			return $http.post('modifyDRGroupSchedule.do', {
				taskId: obj.taskId,
				schedule: obj.schedule,
				virtualApp: obj.virtualApp,
				drOrchestrationType: obj.drOrchestrationType
			});
		};

		this.deleteSchedule = function(taskId) {
			return $http.delete('drGroupSchedule.do?taskId=' + taskId);
		};

		this.getProxyServers = function(vendor) {
			return $http.get('proxyServers.do?vendor=' + vendor);
		};

		this.createVirtualLab = function(vAppId, vAppName, vendor) {
			return $http.post('virtualLab.do?vAppId=' + vAppId + '&vAppName=' + vAppName + '&vendor=' + vendor);
		};

		this.autofailoverMonitoring = function(vAppEntity, action) {
			return $http.post('autoFailover.do', {
				vAppEntity: JSON.stringify(vAppEntity),
				action: JSON.stringify(action)
			});
		};

		this.getVirtualLabs = function(vmAllocPolicyId) {
			return $http.get('virtualLabs.do?vmAllocPolicyId=' + vmAllocPolicyId);
		};

		this.getArrayEntities = function(subclientId, copyId, clientId) {
			let cancel = $q.defer();
			let url = `drArrayEntities.do?applicationId=${subclientId || 0}&copyId=${copyId || 0}&clientId=${clientId || 0}`;
			return $http.get(url, {
				timeout: cancel.promise,
				cancel: cancel,
				overrideTimeout: true
			});
		};

		this.getSnapDRReplicationStatus = function(vAppId) {
			//need to write new Rest API and change to that later
			return $http.get('snapDRReplicationStatus.do?vAppId=' + vAppId);
		};

		this.getStoragePolicyDetails = function(spId) {
			return $http.get('storagePolicyDetails.do?spId=' + spId);
		};
	}
]);

export default failoverMod;
