(function() {
	'use strict';

	var devtestMod = angular.module('drApp.devtest');
	devtestMod.service('devtestService', [
		'$http',
		'$q',
		function($http, $q) {
			this.createDevtestGroup = function(obj) {
				return $http.post('devtestGroup.do', obj);
			};

			this.getDevtestGroupDetails = function(vAppId) {
				return $http.get('devtestGroup.do?vAppId=' + vAppId);
			};

			this.getDevtestGroups = function() {
				return $http.get('devtestGroups.do');
			};

			this.updateDevtestGroup = function(obj) {
				return $http.post('updateDevtestGroup.do', obj);
			};

			this.deleteDevtestGroup = function(vAppId) {
				return $http.delete('devtestGroup.do?vAppId=' + vAppId);
			};

			this.getMachinesList = function(entityID, entityType, vAppSource) {
				return $http.get(
					'devtestMachines.do?entityID=' + entityID + '&entityType=' + entityType + '&vAppSource=' + vAppSource
				);
			};

			this.getDRJobDetails = function(jobId) {
				return $http.get('drJobDetails.do?jobId=' + jobId);
			};

			this.getServerAndServerGroups = function() {
				return $http.get('getServerAndServerGroups.do');
			};

			this.createSchedule = function(obj) {
				return $http.post('drGroupSchedule.do', {
					schedule: obj.schedule,
					virtualApp: obj.virtualApp
				});
			};

			this.modifySchedule = function(obj) {
				return $http.post('modifyDRGroupSchedule.do', {
					taskId: obj.taskId,
					schedule: obj.schedule,
					virtualApp: obj.virtualApp
				});
			};

			this.deleteSchedule = function(taskId) {
				return $http.delete('drGroupSchedule.do?taskId=' + taskId);
			};

			this.getProxyServers = function(vendor) {
				return $http.get('proxyServers.do?vendor=' + vendor);
			};
		}
	]);
})();
