import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/disasterRecovery/js/dr.constants.js';
import 'modules/disasterRecovery/js/controllers/autoFailover.ctrl.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Factory functions for handling Auto failover in DR Group
 */

var failoverMod = drAppFailoverModule;

failoverMod.factory('drAutoFailoverFactory', [
	'$uibModal',
	'cvToaster',
	'cvLoc',
	'failoverService',
	'drCRUDFactory',
	'FailoverConstants',
	'FailoverEnum',
	function drAutoFailoverFactory(
		$uibModal,
		cvToaster,
		cvLoc,
		failoverService,
		drCRUDFactory,
		FailoverConstants,
		FailoverEnum
	) {
		var factory = {
			// public functions
			addMonitoringMachines: addMonitoringMachines,
			handleAutofailoverOptions: handleAutofailoverOptions,
			startMonitoring: startMonitoring,
			stopMonitoring: stopMonitoring,
			isSupportedVendor: isSupportedVendor
		};

		// private variable
		var toasterTTL = 10000;
		var supportedVendors = [FailoverConstants.Vendors['VMW']];

		return factory;

		function addMonitoringMachines(vApp) {
			$uibModal.open({
				templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/autoFailover.jsp',
				backdrop: 'static',
				controllerAs: 'autofailoverController',
				controller: 'autofailoverController',
				resolve: {
					vApp: function() {
						return vApp;
					}
				}
			});
		}

		function isSupportedVendor(srcVendor, destVendor) {
			return (
				srcVendor && supportedVendors.indexOf(srcVendor) >= 0 && destVendor && supportedVendors.indexOf(destVendor) >= 0
			);
		}

		function startMonitoring(vApp) {
			failoverService
				.autofailoverMonitoring(vApp.vAppEntity, FailoverEnum.AutoFailoverAction['START'])
				.success(function(data) {
					if (angular.isDefined(data) && data.errorMessage == 'Success') {
						vApp.autofailover.status = FailoverEnum.AutoFailoverStatus['MNTR_STARTING'];
						drCRUDFactory.updateFailoverGroup(vApp).then(function() {
							vApp = drCRUDFactory.failoverGroupDetails;
						});
					} else {
						showErrorMessage();
					}
				})
				.error(function(e) {
					showErrorMessage(e);
				});
		}

		function stopMonitoring(vApp) {
			failoverService
				.autofailoverMonitoring(vApp.vAppEntity, FailoverEnum.AutoFailoverAction['STOP'])
				.success(function(data) {
					angular.isDefined(data) && (data.errorCode == 0 || data.errorMessage == 'Success')
						? showSuccessMessage(cvLoc('msg.stopMonitoringRequestSent'))
						: showErrorMessage();
				})
				.error(function(e) {
					showErrorMessage(e);
				});
		}

		// Adds the auto failover options to the vApp object
		function handleAutofailoverOptions(vApp, autoFailoverSelectedMachines, autoFailoverDelay) {
			vApp.autofailover = {};
			vApp.autofailover.timeThresholdBeforeFailover = autoFailoverDelay;
			vApp.autofailover.status = FailoverEnum.AutoFailoverStatus['MNTR_DISABLED'];
			vApp.autofailover.machine = [];
			autoFailoverSelectedMachines.forEach(function(selectedMachine) {
				var autofailoverMachine = {};

				autofailoverMachine.client = {};
				autofailoverMachine.client.clientId = selectedMachine.clientId;
				autofailoverMachine.client.clientName = selectedMachine.clientName;
				autofailoverMachine.client.hostName = selectedMachine.hostName;
				autofailoverMachine.client.clientGUID = selectedMachine.csGUID;
				autofailoverMachine.client._type_ = 3; //CLIENT_ENTITY

				autofailoverMachine.status = FailoverEnum.AutoFailoverStatus['ONLINE'];
				autofailoverMachine.isMaster = false;

				// Check Api.x -> AutofailoverLocation
				autofailoverMachine.locationType = selectedMachine.locationType;
				switch (autofailoverMachine.locationType) {
					case 0:
						autofailoverMachine.isSource = true;
						break;
					case 1:
						autofailoverMachine.isDestination = true;
						break;
					default:
						break;
				}

				// Setting the default port numbers.
				autofailoverMachine.port = [];
				autofailoverMachine.port.push(getPort(0, 2888));
				autofailoverMachine.port.push(getPort(1, 3888));
				autofailoverMachine.port.push(getPort(2, 2181));

				vApp.autofailover.machine.push(autofailoverMachine);
			});
		}

		/* ========== Helper Functions ========== */

		/*
		 * Creates a AutofailoverPort object. Check Api.x -> AutoFailoverPort for the object and enum definition
		 */
		function getPort(autoFailoverPortType, portNumber) {
			var port = {};
			port.portType = autoFailoverPortType;
			port.port = portNumber;

			return port;
		}

		/**
		 * Shows the cvToaster success message
		 */
		function showSuccessMessage(content) {
			cvToaster.showSuccessMessage({
				ttl: toasterTTL,
				message: content
			});
		}

		/**
		 * Shows the cvToaster error message
		 */
		function showErrorMessage(content) {
			cvToaster.showErrorMessage({
				ttl: toasterTTL,
				message: content ? content : cvLoc('generic_error')
			});
		}
	}
]);

export default failoverMod;
