import { drAppFailoverModule } from 'common/js/modules';

/**
 * List of all the constants that are to be used in the DR module
 */

var failoverMod = drAppFailoverModule;

failoverMod.constant('FailoverConstants', {
	VMAllocationPolicyType: {
		AZURE_RESOURCE_MANAGER: 'AZURE_RESOURCE_MANAGER',
		VMW_BACKUP_LABTEMPLATE: 'VMW_BACKUP_LABTEMPLATE',
		VMW_LIVEMOUNT: 'VMW_LIVEMOUNT'
	},
	DROrchestrationType: {
		FAILBACK: 'FAILBACK',
		NONE: 'NONE',
		PLANNED_FAILOVER: 'PLANNED_FAILOVER',
		REVERT_FAILOVER: 'REVERT_FAILOVER',
		TESTBOOT: 'TESTBOOT',
		UNDO_FAILOVER: 'UNDO_FAILOVER',
		UNPLANNED_FAILOVER: 'UNPLANNED_FAILOVER',
		TEST_FAILOVER: 'TEST_FAILOVER',
		UNDO_TEST_FAILOVER: 'UNDO_TEST_FAILOVER'
	},
	DRReplicationType: {
		LiveSync: 'LiveSync',
		LiveSyncDirect: 'LiveSyncDirect',
		LiveSyncIO: 'LiveSyncIO',
		SnapArrayReplication: 'SnapArrayReplication'
	},
	DRTestFailoverStatus: {
		DR_TEST_FAILOVER_NONE: 'DR_TEST_FAILOVER_NONE',
		DR_TEST_FAILOVER_COMPLETE: 'DR_TEST_FAILOVER_COMPLETE',
		DR_TEST_FAILOVER_IN_PROGRESS: 'DR_TEST_FAILOVER_IN_PROGRESS',
		DR_TEST_FAILOVER_FAILED: 'DR_TEST_FAILOVER_FAILED',
		DR_UNDO_TEST_FAILOVER_IN_PROGRESS: 'DR_UNDO_TEST_FAILOVER_IN_PROGRESS',
		DR_UNDO_TEST_FAILOVER_FAILED: 'DR_UNDO_TEST_FAILOVER_FAILED'
	},
	Vendors: {
		AMAZON: 'AMAZON',
		AZURE: 'AZURE',
		AZURE_STACK: 'AZURE_STACK',
		AZURE_V2: 'AZURE_V2',
		MICROSOFT: 'MICROSOFT',
		VMW: 'VMW'
	},
	VAppSource: {
		BACKUP: 'BACKUP',
		REPLICATION: 'REPLICATION',
		TEMPLATES: 'TEMPLATES'
	},
	VAppOperation: {
		LIVEMOUNT: 'LIVEMOUNT',
		FAILOVER: 'FAILOVER',
		VIRTUALLAB: 'VIRTUALLAB',
		TESTFAILOVER: 'TESTFAILOVER'
	}
});

failoverMod.constant('FailoverEnum', {
	AutoFailoverStatus: {
		MNTR_DISABLED: 0,
		MNTR_FAILED: 1,
		MNTR_ENABLED: 2,
		MNTR_PAUSED: 3,
		OFFLINE: 4,
		ONLINE: 5,
		MNTR_STARTING: 6,
		MNTR_NOT_CONFIGURED: 7
	},
	AutoFailoverAction: {
		START: 0,
		PAUSE: 1,
		RESUME: 2,
		STOP: 3
	},
	DRReplicationType: {
		LiveSync: 0,
		LiveSyncDirect: 1,
		LiveSyncIO: 2,
		SnapArrayReplication: 3
	},
	DROrchestrationType: {
		NONE: 0,
		PLANNED_FAILOVER: 1,
		FAILBACK: 2,
		UNPLANNED_FAILOVER: 3,
		REVERT_FAILOVER: 4,
		UNDO_FAILOVER: 6,
		TESTBOOT: 7,
		TEST_FAILOVER: 11,
		UNDO_TEST_FAILOVER: 13
	},
	ScriptType: {
		PRE: 1,
		POST: 2
	},
	VAppSource: {
		BACKUP: 0,
		REPLICATION: 1,
		TEMPLATES: 2,
		ARRAYREPLICATION: 3
	},
	VAppOperation: {
		LIVEMOUNT: 1,
		FAILOVER: 16,
		TESTFAILOVER: 256
	},
	VMPolicyApplicationType: {
		REPLICATION: 0,
		REGULAR: 1
	}
});

failoverMod.constant('FailoverTextForEnum', {
	FailoverStatus: {
		0: 'VSAREP_NONE',
		1: 'VSAREP_FAILOVER_COMPLETE',
		2: 'VSAREP_FAILOVER_RUNNING',
		3: 'VSAREP_FAILOVER_PAUSED',
		4: 'VSAREP_FAILOVER_FAILED',
		5: 'VSAREP_FAILBACK_COMPLETE',
		6: 'VSAREP_FAILBACK_RUNNING',
		7: 'VSAREP_FAILBACK_PAUSED',
		8: 'VSAREP_FAILBACK_FAILED',
		9: 'VSAREP_FAILBACK_PARTIAL',
		10: 'VSAREP_FAILOVER_PARTIAL',
		11: 'VSAREP_FAILOVER_SKIPPED',
		12: 'VSAREP_FAILBACK_SKIPPED',
		13: 'VSAREP_REVERT_FAILOVER_COMPLETE',
		14: 'VSAREP_REVERT_FAILOVER_RUNNING',
		15: 'VSAREP_REVERT_FAILOVER_FAILED',
		16: 'VSAREP_REVERT_FAILOVER_PAUSED',
		1000: 'VSAREP_FAILOVER_UNCHANGED'
	},
	SyncStatus: {
		0: 'VSAREP_NONE',
		1: 'VSAREP_COMPLETE',
		2: 'VSAREP_PENDING',
		3: 'VSAREP_RUNNING',
		4: 'VSAREP_PAUSED',
		5: 'VSAREP_FAILED',
		6: 'VSAREP_DISABLED',
		7: 'VSAREP_ENABLED',
		8: 'VSAREP_VALIDATION_FAILED',
		9: 'VSAREP_JOB_QUEUED',
		10: 'VSAREP_REVERT_FAILED',
		11: 'VSAREP_STARTING'
	},
	VAppSource: {
		0: 'BACKUP',
		1: 'REPLICATION',
		2: 'TEMPLATES',
		3: 'ARRAYREPLICATION'
	}
});

export default failoverMod;
