import 'modules/disasterRecovery/js/factory/drScript.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

const TEMPLATE = `	<cv-kendo-grid cv-grid-options="drMachinesCtrl.gridOptions"></cv-kendo-grid>
					<span data-ng-if="drMachinesCtrl.machines.isLoading" class="grid-data-spinner">
						<img ng-src="{{drMachinesCtrl.loadingImgSrc}}">
					</span>
					<div class="form-group" data-ng-if="submitController.getAttempted() && !drMachinesCtrl.isValid(drMachinesCtrl.machines)">
						<div class="col-xs-12 col-sm-offset-5 col-sm-7">
							<div class="help-block">
								<i class="ion-alert-circled"></i>
								{{'error.noMachineSelected' | cvLoc}}
							</div>
						</div>
					</div>`;

/*
 * Expected input for machines
 * machines = {
	gridOptions: {},
	machineList: [] 	// list of all the machines	to show
 }
 * 
 */

class DRMachines {
	constructor() {
		this.restrict = 'E';
		this.template = TEMPLATE;
		this.scope = {
			ctrl: '=?',
			machines: '='
		};
		this.require = ['?^^cvSubmit', '?^^form'];
		this.controllerAs = 'drMachinesCtrl';
		this.controller = DRMachinesController;
		this.bindToController = true;
	}

	link($scope, elem, atts, ctrl) {
		$scope.submitController = _.get(ctrl, '[0]');
		$scope.formController = _.get(ctrl, '[1]');
	}
}

class DRMachinesController {
	constructor(cvLoc, drScriptFactory) {
		this.cvLoc = cvLoc;
		this.drScriptFactory = drScriptFactory;
	}

	onActionsClick(event) {
		event.preventDefault();
	}

	isValid(machines) {
		return _.get(machines, 'machinesList', []).length > 0;
	}

	$onInit() {
		this.ctrl = this.ctrl || {};
		this.ctrl.areMachinesValid = this.isValid;
		this.machines.machinesList = this.machines.machinesList || [];
		this.loadingImgSrc = `${appUtil.appRoot}common/img/ajax-loader.gif`;
		this._setupGridOptions();
	}

	_setupGridOptions() {
		let self = this;
		let gridOptions = this.machines.gridOptions;
		this.gridOptions = {
			beforeGridInitialize: ({ grid }) => {
				self.machines.grid = grid;
			},
			columns: this._initMachinesColumnDefs(),
			enableCheckBoxColumn: gridOptions.enableCheckBoxColumn || false,
			gridTitle: gridOptions.gridTitle || this.cvLoc('label.virtualMachines'),
			tableName: gridOptions.tableName || 'drMachinesTable',
			actionMenu: gridOptions.actionMenu || [],
			detailGridOptions: gridOptions.detailGridOptions ? this._initDetailGridOptions() : null,
			enableColumnMenu: true,
			enableFiltering: true,
			gridEmptyMessage: gridOptions.gridEmptyMessage || this.cvLoc('msg.noVMsSelected'),
			gridToolbarMenu: gridOptions.gridToolbarMenu || [],
			hasViews: false,
			idField: gridOptions.idField || 'clientId',
			noResultsMessage: gridOptions.noResultsMessage || this.cvLoc('msg.noVMsAvailable'),
			onGridDataBound: gridOptions.onGridDataBound,
			onGridSelectionChanged: gridOptions.onGridSelectionChanged,
			pageSize: gridOptions.pageSize || 10,
			pageSizes: [5, 10, 15, 25, 50, 100, 500, 1000],
			persistSelection: true,
			scrollable: false,
			searchable: gridOptions.searchable || false,
			url: self._getData.bind(this),
			usePageToolbar: true
		};
	}

	_getData(options) {
		options.success(this.machines.machinesList);
	}

	_initMachinesColumnDefs() {
		return this.machines.gridOptions.columnsTemplate;
	}

	_initDetailGridOptions() {
		return {
			columns: this.machines.detailGridOptions.columnsTemplate,
			gridTitle: this.machines.detailGridOptions.gridTitle,
			tableName: 'drMachinesVMTable',
			enableCheckBoxColumn: false,
			url: this._getDetailGridData.bind(this),
			gridEmptyMessage: this.cvLoc('msg.noVMsAvailable'),
			enableColumnMenu: false,
			enableFiltering: false,
			enableVirtualization: false,
			hasViews: false,
			gridToolbarMenu: []
		};
	}

	_getDetailGridData(parentEntity, options) {
		let index = this.machines.machinesList.findIndex(
			ds => ds.datastore.strDatastoreUUID === parentEntity.datastore.strDatastoreUUID
		);
		if (index > -1) {
			options.success(this.machines.machinesList[index].vm);
		} else {
			options.success([]);
		}
	}
}

DRMachinesController.$inject = ['cvLoc', 'drScriptFactory'];
drAppFailoverModule.directive('drMachines', () => new DRMachines());

export default drAppFailoverModule;
