import 'modules/disasterRecovery/js/factory/dr.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

const TEMPLATE = `
<div class="form-group">
	<label class="col-xs-12 col-sm-5" for="serversDiv" data-ng-bind="drHypervisorsCtrl.typeObj.title"></label>
	<span class="col-xs-12 col-sm-7">
		<isteven-multi-select
			input-model="drHypervisorsCtrl.servers"
			output-model="drHypervisorsCtrl.serversSelected"
			button-label="name"
			item-label="name"
			tick-property="selected"
			selection-mode="single"
			class="isteven-multi-select"
			id="serversDiv"
			name="servers"
			directive-id="serversDiv"
			search-property="servers.name"
			max-height="400px"
			on-item-click="drHypervisorsCtrl.onHypervisorSelect()"
			group-property="header"
			helper-elements="filter">
		</isteven-multi-select>
		<div class="help-block" data-ng-if="submitController.getAttempted() && !drHypervisorsCtrl.isValid(drHypervisorsCtrl.serversSelected)">
			<i class="ion-alert-circled"></i>
			{{'error.noServersSelected' | cvLoc}}
		</div>
	</span>
</div>
`;

class DRHypervisors {
	constructor() {
		this.restrict = 'E';
		this.template = TEMPLATE;
		this.scope = {};
		this.require = ['^^cvSubmit', '^^form', '?^drArrayReplication'];
		this.controllerAs = 'drHypervisorsCtrl';
		this.controller = DRHypervisorsController;
		this.bindToController = {
			filterVendors: '=?',
			ctrl: '=',
			vApp: '=',
			type: '@' // see _getTypes() for the list of supported types
		};
	}

	link($scope, elem, atts, ctrl) {
		$scope.submitController = ctrl[0];
		$scope.formController = ctrl[1];
		let controller = _.get(ctrl, '[2]');

		$scope.drHypervisorsCtrl.onHypervisorSelect = function() {
			$scope.drHypervisorsCtrl.onSelect();
			controller.onHypervisorSelect($scope.drHypervisorsCtrl.serversSelected);
		};
	}
}

class DRHypervisorsController {
	constructor(cvLoc, drOrchestrationFactory) {
		this.cvLoc = cvLoc;
		this.drOrchestrationFactory = drOrchestrationFactory;
	}

	onSelect() {
		let serversSelected = this.serversSelected[0];
		this.vApp.isClientGroup = serversSelected.isClientGroup;
		this.vApp.selectedEntities = [];
		let selectedEntity = {
			clientId: serversSelected.id,
			entityId: serversSelected.id,
			entityName: serversSelected.name
		};
		this.vApp.selectedEntities.push(selectedEntity);
	}

	isValid(selectedEntities) {
		return !!(selectedEntities && selectedEntities.length > 0);
	}

	$onInit() {
		let self = this;
		this.ctrl = this.ctrl || {};
		this.ctrl.isHypervisorValid = this.isValid;
		this.servers = [this._loadingISteven('name')];
		this.type = (this.type || 'all').toLowerCase();
		this.typeObj = this._getTypes()[this.type];
		this.typeObj
			.getData()
			.then(function() {
				self._setDefaultHypervisor();
			})
			.catch(function() {
				self.servers = [];
			});
	}

	_getTypes() {
		let self = this;
		return {
			hypervisors: {
				title: this.cvLoc('label.sourceHypervisor'),
				getData: function() {
					return this._getHypervisors();
				}.bind(self)
			},
			clientgroups: {
				title: this.cvLoc('label.serverGroups'),
				getData: function() {
					return this._getClientGroups();
				}.bind(self)
			},
			all: {
				title: this.cvLoc('label.serverGroupsAndHypervisors'),
				getData: function() {
					return this._getHypervisors().then(function() {
						return self._getClientGroups();
					});
				}.bind(self)
			}
		};
	}

	_getClientGroups() {
		const self = this;
		return this.drOrchestrationFactory.getClientGroups().then(function() {
			let clientGroups = angular.copy(self.drOrchestrationFactory.clientGroups);
			if (self.type === 'all') {
				let headerLabel = self.cvLoc('label.serverGroups');
				self._concat(headerLabel, clientGroups);
			} else {
				self.servers = clientGroups;
			}
			self._removeLoader();
		});
	}

	_getHypervisors() {
		const self = this;
		return this.drOrchestrationFactory.getHyperVisors().then(function() {
			let hypervisors = angular.copy(self.drOrchestrationFactory.hypervisors);
			hypervisors = hypervisors.filter(server => self.filterVendors.indexOf(server.type) >= 0);
			if (self.type === 'all') {
				let headerLabel = self.cvLoc('label.hypervisors');
				self._concat(headerLabel, hypervisors);
			} else {
				self.servers = hypervisors;
			}
			self._removeLoader();
		});
	}

	/*
	 * Select the values from vApp, if it contains selectedEntities (edit case).
	 * Select the first one in the list otherwise.
	 */
	_setDefaultHypervisor() {
		this.serversSelected = [];
		let firstElementIndex = this._firstElementIndex();
		if (this.servers && this.servers.length > firstElementIndex) {
			if (_.get(this, 'vApp.selectedEntities', {}).length > 0) {
				for (var i in this.servers) {
					let index = this.vApp.selectedEntities.findIndex(selectedEntity => {
						return selectedEntity.clientId === this.servers[i].id;
					});
					if (index >= 0) {
						this.servers[i].selected = true;
						this.serversSelected.push(this.servers[i]);
					}
				}
			} else {
				this.servers[firstElementIndex].selected = true;
				this.serversSelected[0] = this.servers[firstElementIndex];
			}
			this.onHypervisorSelect();
		} else {
			this.servers = [];
		}
	}

	/* gets the index of the first element of the group */
	_firstElementIndex() {
		let index = 0;
		if (this.type == 'all') {
			index = 1; // 'all' has a header as the first element
		}
		return index;
	}

	/* concats the data into this.servers */
	_concat(headerLabel, data) {
		var header = {
			name: `<strong>${headerLabel}</strong>`,
			header: true
		};
		var end = {
			header: false
		};
		this.servers = this.servers || [];
		this.servers = this.servers.concat(header);
		this.servers = this.servers.concat(data);
		this.servers = this.servers.concat(end);
	}

	_removeLoader() {
		if (this.servers && this.servers[0].type === 'loader') {
			this.servers.shift(); // Remove the loader
		}
	}

	_loadingISteven(name) {
		let loading = {
			type: 'loader',
			id: 0,
			selected: true,
			disableSelection: true // disable from using this as a value to save
		};
		loading[name] = this.cvLoc('Loading');

		return loading;
	}
}

DRHypervisorsController.$inject = ['cvLoc', 'drOrchestrationFactory'];
drAppFailoverModule.directive('drHypervisors', () => new DRHypervisors());

export default drAppFailoverModule;
