import 'modules/disasterRecovery/js/factory/drVirtualLab.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Creates a Virtual Lab cvgrid
 */

var failoverMod = drAppFailoverModule;

var vsaReplicationTargetDirective = function() {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/cvVSAVirtualLab.jsp',
		scope: {},
		require: [],
		bindToController: {
			policyEntity: '='
		},
		controller: 'vsaVirtualLabController',
		controllerAs: 'virtualLabCtrl'
	};
};

var controllers = {};
failoverMod.controller('vsaVirtualLabController', [
	'cvLoc',
	'cvTableOptions',
	'drVirtualLabFactory',
	function(cvLoc, cvTableOptions, drVirtualLabFactory) {
		var self = this;
		this.$onInit = function() {
			// initial function
			fetchVirtualLabTargets();

			function fetchVirtualLabTargets() {
				self.policyEntity &&
					drVirtualLabFactory.getVirtualLabs(self.policyEntity.vmAllocPolicyId).then(function() {
						self.labs = drVirtualLabFactory.labs;
					});
			}

			var globalGridOptionsLabs = angular.copy(cvTableOptions.commonNgGridOptions);

			angular.extend(globalGridOptionsLabs, {
				data: 'labs',
				paginationPageSizes: [5, 10, 15],
				paginationPageSize: 5,
				columnDefs: [
					{
						field: 'lab.labName',
						sort: {
							direction: 'asc',
							priority: 0
						},
						displayName: cvLoc('label.labName'),
						cellTemplate: '<span class="crop"><a href="#">{{row.entity.lab.labName}}</a></span>',
						width: '15%'
					},
					{
						field: 'status',
						displayName: cvLoc('label.column.status'),
						cellTemplate: '<label>{{row.entity.status}}</label>',
						width: '5%'
					},
					{
						field: 'vmCount',
						displayName: cvLoc('label.column.numberofMachines'),
						cellTemplate: '<label class="crop">{{row.entity.vmCount}}</label>',
						width: '15%'
					},
					{
						field: 'expirationTime',
						displayName: cvLoc('label.column.expirationTime'),
						cellTemplate: '<span class="crop"><div class="time" val="{{row.entity.expirationTime.time}}"></div></span>',
						width: '15%'
					}
				]
			});

			self.gridOptionsLabs = {
				cvTableName: 'labsTable',
				cvGridTitle: cvLoc('label.virtualLabs'),
				cvIsPageTitle: false,
				cvSearchFields: ['status', 'lab.labName'],
				cvAppScope: self,
				gridOptions: globalGridOptionsLabs
			};
		};
	}
]);

failoverMod.directive('cvVsaVirtualLab', vsaReplicationTargetDirective);

export default failoverMod;
