import 'modules/disasterRecovery/js/controllers/addMachines.ctrl.js';
import 'modules/disasterRecovery/js/controllers/drScript.ctrl.js';
import 'modules/disasterRecovery/js/dr.constants.js';
import 'modules/disasterRecovery/js/factory/dr.factory.js';
import 'modules/disasterRecovery/js/factory/drArrayReplication.factory.js';
import 'modules/disasterRecovery/js/factory/drAutoFailover.factory.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/disasterRecovery/js/factory/drOperations.factory.js';
import 'modules/disasterRecovery/js/factory/drSchedule.factory.js';
import 'modules/disasterRecovery/js/factory/drScript.factory.js';
import 'modules/disasterRecovery/js/factory/drVirtualLab.factory.js';
import 'modules/disasterRecovery/repGrp/js/controllers/repGrpParent.ctrl.js';
import { drAppFailoverModule } from 'common/js/modules';

/**
 * The controller file handles the details page of the failover groups
 */

var failoverMod = drAppFailoverModule;

failoverMod.controller('failoverGroupDetailsController', [
	'$state',
	'$stateParams',
	'$uibModal',
	'$rootScope',
	'$scope',
	'$dialogs',
	'$log',
	'cvUtil',
	'cvTableOptions',
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'cvToaster',
	'drOrchestrationFactory',
	'drCRUDFactory',
	'drOperationsFactory',
	'drScheduleFactory',
	'drAutoFailoverFactory',
	'drScriptFactory',
	'drVirtualLabFactory',
	'FailoverEnum',
	'FailoverTextForEnum',
	'FailoverConstants',
	'arrayReplicationFactory',
	'VENDORS',
	function(
		$state,
		$stateParams,
		$uibModal,
		$rootScope,
		$scope,
		$dialogs,
		$log,
		cvUtil,
		cvTableOptions,
		cvBreadcrumbsTabsFactory,
		cvLoc,
		cvToaster,
		drOrchestrationFactory,
		drCRUDFactory,
		drOperationsFactory,
		drScheduleFactory,
		drAutoFailoverFactory,
		drScriptFactory,
		drVirtualLabFactory,
		FailoverEnum,
		FailoverTextForEnum,
		FailoverConstants,
		arrayReplicationFactory,
		VENDORS
	) {
		var self = this;
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.failoverGroups'),
				link: '#failover'
			}
		]);

		// functions
		self.addMonitoringMachines = drAutoFailoverFactory.addMonitoringMachines;
		self.addSchedule = drScheduleFactory.addSchedule;
		self.editPostScript = drScriptFactory.openPostScriptDialog;
		self.editPreScript = drScriptFactory.openPreScriptDialog;
		self.editSchedule = drScheduleFactory.editSchedule;
		self.modifyBasicDetails = drCRUDFactory.modifyBasicDetails;
		self.modifyMachineDetails = drCRUDFactory.modifyMachineDetails;
		self.performAction = performAction;
		self.removeMachine = removeMachine;
		self.startMonitoring = drAutoFailoverFactory.startMonitoring;
		self.stopMonitoring = drAutoFailoverFactory.stopMonitoring;

		// variables
		let benableTestbootNetwork = cvConfig.enableTestbootNetwork ? cvConfig.enableTestbootNetwork : false;
		self.isGroupDataLoading = true;
		self.isMachineDataLoading = true;
		self.isPlannedFailoverSchedulesLoading = true;
		self.isTestbootSchedulesLoading = true;
		self.plannedFailoverSchedules = [];
		self.testBootSchedules = [];
		self.vApp = {};
		self.vAppId = $stateParams.vAppId;
		self.showTestFailoverForAzure = !!cvConfig.showTestFailoverForAzure;
		self.showTestFailoverForAmazon = !!cvConfig.showTestFailoverForAmazon;

		var toasterTTL = 10000;
		let virtualLabAllowed = false;
		let failbackAllowed = false;
		let failoverAllowed = false;
		let testBootAllowed = false;
		let undoFailoverAllowed = false;
		let undoTestFailoverAllowed = false;
		let testFailoverAllowed = false;
		let viewTestFailoverVMs = false;

		drCRUDFactory.getFailoverGroupDetails(self.vAppId).then(function() {
			self.isGroupDataLoading = false;
			self.vApp = drCRUDFactory.failoverGroupDetails;
			if (!self.vApp) {
				showErrorMessage(cvLoc('msg.errorFetchingGroupDetails'));
				return;
			}

			self.machinesList = [];
			var type = 'client';
			var state = 'clientDetails';
			if (self.vApp.isClientGroup) {
				type = 'clientgroup';
				state = 'clientGroupDetails';
			}

			if (angular.isDefined(self.vApp.autofailover) && angular.isDefined(self.vApp.autofailover.machine)) {
				self.vApp.autofailover.statusText = cvUtil.lookupEnumConstant(self.vApp.autofailover.status);
				self.vApp.autofailover.machineNames = '';
				self.vApp.autofailover.machine.forEach(function(machine) {
					self.vApp.autofailover.machineNames += machine.client.clientName + ' ,';
				});

				if (self.vApp.autofailover.machineNames.length > 0) {
					self.vApp.autofailover.machineNames = self.vApp.autofailover.machineNames.substring(
						0,
						self.vApp.autofailover.machineNames.lastIndexOf(',') - 1
					);
				}
			} else {
				self.vApp.autofailover = {};
				self.vApp.autofailover.statusText = cvUtil.lookupEnumConstant('MNTR_NOT_CONFIGURED');
			}

			self.vApp.isFailoverGroup = self.vApp.operationType.toUpperCase() === FailoverConstants.VAppOperation['FAILOVER'];
			self.vApp.isDevtestGroup =
				self.vApp.operationType.toUpperCase() === FailoverConstants.VAppOperation['LIVEMOUNT'] ||
				self.vApp.operationType.toUpperCase() === FailoverConstants.VAppOperation['VIRTUALLAB'];
			self.vApp.isSnapDR = self.vApp.replicationType === FailoverConstants.DRReplicationType.SnapArrayReplication;
			self.vApp.isTestFailoverGroup =
				self.vApp.operationType.toUpperCase() === FailoverConstants.VAppOperation.TESTFAILOVER;

			if (self.vApp.isDevtestGroup) {
				var columnsToRemove = ['lastSyncTime', 'syncStatusText', 'failoverStatusText'];
				drOrchestrationFactory.removeGridColumns(columnsToRemove, self.gridOptions.gridOptions.columnDefs);
			}
			if (self.vApp.isSnapDR) {
				initSnapDR();
				initPageActions();
			}

			self.sourceHypvervisorHref = '#/' + state + '/' + self.vApp.selectedEntities[0].entityId;
			self.targetAvailable = self.vApp.policy && self.vApp.policy.entity ? true : false;

			self.vApp.vAppSourceText = cvUtil.lookupEnumConstant(self.vApp.source);

			if (
				self.vApp &&
				!self.vApp.isSnapDR &&
				self.vApp.selectedEntities &&
				self.vApp.selectedEntities.length > 0 &&
				self.vApp.source
			) {
				drOrchestrationFactory
					.getMachinesList(
						self.vApp.selectedEntities[0].entityId,
						type,
						FailoverEnum.VAppSource[self.vApp.source.toUpperCase()]
					)
					.then(function() {
						self.isMachineDataLoading = false;
						self.showPreScript = false;
						self.showPostScript = false;
						var machines = drOrchestrationFactory.failoverEligibleMachines;

						// Adding the list of machines selected by the user to the self.machinesList
						// and adding the groupid to the machinesList from self.vApp.config
						machines.forEach(function(machine) {
							self.vApp.config.vmGroups.forEach(function(vmGroup) {
								if (vmGroup.vmSequence) {
									vmGroup.vmSequence.forEach(function(sequence) {
										if (
											sequence.vmInfo.vmName === machine.client.clientName &&
											sequence.vmInfo.vmGUID === machine.client.GUID &&
											machine.replicationId === sequence.replicationId
										) {
											var groupId = vmGroup.groupId;
											if (!groupId) {
												groupId = 1;
											}
											machine.groupId = groupId;
											machine.postScript = sequence.postScript;
											machine.preScript = sequence.preScript;

											// if status = 'VSAREP_NONE', show empty text
											if (machine.failoverStatus == '0') {
												machine.failoverStatusText = '';
											} else {
												machine.failoverStatusText = cvUtil.lookupEnumConstant(
													FailoverTextForEnum.FailoverStatus[machine.failoverStatus]
												);
											}
											machine.syncStatusText = cvUtil.lookupEnumConstant(
												FailoverTextForEnum.SyncStatus[machine.syncStatus]
											);
											machine.vendorText = cvUtil.lookupEnumConstant(machine.vendor);
											self.subclientId = machine.client.subclientId;
											self.machinesList.push(machine);

											if (angular.isDefined(machine.destVendor)) {
												machine.destVendorText = cvUtil.lookupEnumConstant(machine.destVendor);
											}

											self.showPostScript =
												self.showPostScript ||
												drScriptFactory.isPostScriptSupported(machine.vendor, machine.destVendor);
											self.showPreScript =
												self.showPreScript || drScriptFactory.isPreScriptSupported(machine.vendor, machine.destVendor);
											self.destinationHypervisorHref = '#/clientDetails/' + machine.destinationClient.clientId;
											failbackAllowed = failbackAllowed || drOperationsFactory.isFailbackAllowedOnMachine(machine);
											failoverAllowed = failoverAllowed || drOperationsFactory.isFailoverAllowedOnMachine(machine);

											self.showAutoFailoverOptions =
												self.showAutoFailoverOptions ||
												drAutoFailoverFactory.isSupportedVendor(machine.vendor, machine.destVendor);
											testBootAllowed = testBootAllowed || drOperationsFactory.isTestbootAllowedOnMachine(machine);
											testFailoverAllowed =
												testFailoverAllowed ||
												(self.vApp.isFailoverGroup &&
													self.showTestFailoverForAzure &&
													machine.destVendor === VENDORS.AZURE_V2.type) ||
												(self.vApp.isFailoverGroup &&
													self.showTestFailoverForAmazon &&
													machine.destVendor === VENDORS.AMAZON.type);
											viewTestFailoverVMs = viewTestFailoverVMs || testFailoverAllowed; //view test failover visible only for test failover supported vendor
											virtualLabAllowed =
												virtualLabAllowed ||
												(self.targetAvailable &&
													((self.vApp.isFailoverGroup &&
														drVirtualLabFactory.isCreateVirtualLabAllowedOnMachine(machine)) ||
														self.vApp.isDevtestGroup));
										}
									});
								}
							});
						});

						self.vApp.machinesFromSameSchedule = drOperationsFactory.areMachinesFromSameSchedule(self.machinesList);

						self.vApp.machinesList = self.machinesList;
						initPageActions();
					});

				self.vApp.isFailoverGroup &&
					drScheduleFactory.getPlannedFailoverSchedules(self.vAppId).then(function() {
						self.isPlannedFailoverSchedulesLoading = false;
						self.plannedFailoverSchedules = drScheduleFactory.schedules;
					});

				self.vApp.isFailoverGroup &&
					drScheduleFactory.getTestbootSchedules(self.vAppId).then(function() {
						self.isTestbootSchedulesLoading = false;
						self.testBootSchedules = drScheduleFactory.schedules;
					});
			}
		});

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'machinesList',
			paginationPageSizes: [5, 10, 15],
			paginationPageSize: 5,
			columnDefs: [
				{
					field: 'clientList.clientName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('label.name'),
					cellTemplate:
						'<span class="crop"><a href="#/vm/{{row.entity.client.GUID}}">{{row.entity.client.clientName}}</a></span>',
					width: '15%'
				},
				{
					field: 'destClient.clientName',
					displayName: cvLoc('label.destinationName'),
					cellTemplate: '<span class="crop">{{row.entity.destClient.clientName}}</span>',
					width: '15%'
				},
				{
					field: 'priority',
					displayName: cvLoc('label.priority'),
					cellTemplate: '<label>{{row.entity.groupId}}</label>',
					width: '5%'
				},
				{
					field: 'lastBackupTime',
					displayName: cvLoc('label.lastBackupTime'),
					cellTemplate: '<span class="crop"><div class="time" val="{{row.entity.lastbackuptime.time}}"></div></span>',
					width: '15%'
				},
				{
					field: 'lastSyncTime',
					displayName: cvLoc('label.lastSyncTime'),
					cellTemplate: '<span class="crop"><div class="time" val="{{row.entity.lastSyncTime.time}}"></div></span>',
					width: '15%'
				},
				{
					field: 'syncStatusText',
					displayName: cvLoc('label.syncStatus'),
					cellTemplate: '<label class="crop">{{row.entity.syncStatusText}}</label>',
					width: '15%'
				},
				{
					field: 'failoverStatusText',
					displayName: cvLoc('label.failoverStatus'),
					cellTemplate: '<label class="crop">{{row.entity.failoverStatusText}}</label>',
					width: '15%'
				},
				{
					field: 'actions',
					displayName: cvLoc('label.actions'),
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href data-ng-click="grid.appScope.modifyMachineDetails(row.entity, grid.appScope.vApp)">' +
						cvLoc('label.edit') +
						'</a></li><li><a href data-ng-click="grid.appScope.removeMachine(row.entity)">' +
						cvLoc('label.remove') +
						'</a></li><li data-ng-if="grid.appScope.showPreScript"><a href data-ng-click="grid.appScope.editPreScript(row.entity, grid.appScope.vApp, true)">' +
						cvLoc('label.editPreScript') +
						'</li><li data-ng-if="grid.appScope.showPostScript"><a href data-ng-click="grid.appScope.editPostScript(row.entity, grid.appScope.vApp, true)">' +
						cvLoc('label.editPostScript') +
						'</li></ul></div>'
				}
			]
		});

		self.gridOptions = {
			cvPageLinks: [
				{
					label: cvLoc('label.addVirtualMachines'),
					onclick: function() {
						$uibModal.open({
							templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/addMachinesDialog.jsp',
							backdrop: 'static',
							controllerAs: 'addMachinesController',
							controller: 'addMachinesController',
							resolve: {
								vApp: function() {
									return self.vApp;
								},
								groupMachines: function() {
									return self.machinesList;
								},
								drEligibleMachines: function() {
									return drOrchestrationFactory.failoverEligibleMachines;
								}
							}
						});
					}
				}
			],
			cvTableName: 'machineTable',
			cvGridTitle: cvLoc('label.virtualMachines'),
			cvIsPageTitle: false,
			cvSearchFields: ['clientList.clientName', 'destClient.clientName', 'target'],
			cvOnGridEmpty: {
				message: cvLoc('msg.noVMsAvailable')
			},
			cvAppScope: self,
			gridOptions: globalGridOptions
		};

		function removeMachine(machineToRemove) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					var updatedVMGroups = [];
					self.vApp.config.vmGroups.forEach(function(vmGroup) {
						if (vmGroup.vmSequence) {
							var updatedVMSequence = [];
							var updatedVMGroup = {};
							vmGroup.vmSequence.forEach(function(sequence) {
								if (
									sequence.vmInfo.vmName == machineToRemove.client.clientName &&
									sequence.vmInfo.vmGUID == machineToRemove.client.GUID
								) {
								} else {
									updatedVMSequence.push(sequence);
								}
							});

							updatedVMGroup.vmSequence = updatedVMSequence;
							if (vmGroup.groupId) {
								updatedVMGroup.groupId = vmGroup.groupId;
							}

							if (vmGroup.delay) {
								updatedVMGroup.delay = vmGroup.delay;
							}

							if (vmGroup.continueOnFailure) {
								updatedVMGroup.continueOnFailure = vmGroup.continueOnFailure;
							}
							if (!_.isEmpty(updatedVMGroup.vmSequence)) {
								updatedVMGroups.push(updatedVMGroup);
							}
						}
					});

					self.vApp.config.vmGroups = updatedVMGroups;

					var clientList = [];
					self.vApp.clientList.forEach(function(client) {
						// Add those machines that do not match the machine to be removed.
						if (client.clientId != machineToRemove.client.clientId) {
							clientList.push(client);
						}
					});
					self.vApp.clientList = clientList;

					drCRUDFactory.updateFailoverGroup(self.vApp);
				}
			};

			$dialogs.confirm(
				cvLoc('label.removeMachine'),
				cvLoc('msg.confirmRemoveMachine', machineToRemove.client.clientName),
				callBackFunctions
			);
		}

		function editSnapArrayGroup() {
			drOrchestrationFactory
				.openFailoverCreateModal(FailoverEnum.VAppSource.ARRAYREPLICATION, self.vApp)
				.result.then(function() {
					$state.reload();
				});
		}

		function initSnapDR() {
			self.vApp.machines = self.vApp.machines || {};
			self.vApp.page = 'failoverDetails';
			if (self.vApp.isTestFailoverGroup) {
				testFailoverAllowed = true;
				undoTestFailoverAllowed = true;
			} else {
				failoverAllowed = true;
				undoFailoverAllowed = true;
			}

			getSnapDRReplicationStatus();
		}

		function _getSnapDRGridOptions() {
			let gridOptions = {};

			if (self.vApp.isTestFailoverGroup) {
				gridOptions.columnsTemplate = arrayReplicationFactory.getTestFailoverDetailsColumns();
				gridOptions.actionMenu = [
					{
						id: 'TestFailover',
						label: cvLoc('label.testFailover'),
						onSelect: testFailoverMachines,
						contextMenuOnly: false
					},
					{
						id: 'UndoTestFailover',
						label: cvLoc('label.undoTestFailover'),
						onSelect: undoTestFailoverMachines,
						contextMenuOnly: false
					},
					{
						id: 'assignPriority',
						label: cvLoc('label.assignPriority'),
						onSelect: _assignPriority,
						contextMenuOnly: false
					},
					{
						id: 'configureIP',
						label: `${cvLoc('label.configure')} ${cvLoc('label.ip')}`,
						onSelect: _configureIPAddress,
						contextMenuOnly: false
					}
				];
				gridOptions.enableCheckBoxColumn = true;
			} else {
				gridOptions.columnsTemplate = arrayReplicationFactory.getFailoverDetailsColumns();
				gridOptions.actionMenu = [
					{
						id: 'assignPriority',
						label: cvLoc('label.assignPriority'),
						onSelect: _assignPriority,
						contextMenuOnly: false
					},
					{
						id: 'configureIP',
						label: `${cvLoc('label.configure')} ${cvLoc('label.ip')}`,
						onSelect: _configureIPAddress,
						contextMenuOnly: false
					}
				];
			}
			return gridOptions;
		}

		function _setupColumnFilters(columnDef, data) {
			const types = _.mapValues(columnDef, 'type');
			let filterType = null;

			_.keys(types).forEach(key => {
				const type = types[key];

				switch (type) {
					case 'number':
						filterType = 'numeric';
						break;
					case 'string':
						filterType = 'checkboxmultiselect';
						break;
					default:
						filterType = null;
						break;
				}

				columnDef[key].filterQueryParam = key;
				columnDef[key].filterType = filterType;

				let values = [...new Set(_.values(_.mapValues(data, key)).filter(v => !!v))];
				columnDef[key].data = values.map(v => {
					return { value: v, label: v };
				});
			});
		}

		/* Gets the replication status for the Snap DR machines */
		function getSnapDRReplicationStatus() {
			self.vApp.machines.machinesList = [];
			self.vApp.machines.isLoading = true;
			arrayReplicationFactory.getSnapDRReplicationStatus(self.vAppId).then(function(siteInfo) {
				self.vApp.machines.isLoading = false;
				self.isMachineDataLoading = false;
				siteInfo.forEach(sInfo => {
					// Move the priority to each vmSequnce from vmGroup
					if (self.vApp.config && self.vApp.config.vmGroups) {
						self.vApp.config.vmGroups.forEach(vmGroup => {
							vmGroup.vmSequence.forEach(sequence => {
								if (sequence.vmInfo.vmGUID === sInfo.sourceGuid) {
									sInfo.priority = vmGroup.groupId;
									sInfo.ipText =
										_.get(sequence, 'vmStaticIPAddressOptions', []).length > 0 &&
										!_.isEmpty(sequence.vmStaticIPAddressOptions[0].sourceIP)
											? cvLoc('label.configured')
											: cvLoc('label.notConfigured');
									sInfo.destComputerName = sequence.destComputerName || '';
									sInfo.lastReplicationJobFailureReason = sInfo.lastReplicationJobFailureReason || '';
									// for making filters works for these two columns.
									sInfo.ipColumn = sInfo.ipText;
									sInfo.hostname = sInfo.destComputerName;
								}
							});
						});
					}
				});
				self.vApp.machines.machinesList = siteInfo || [];
				let gridOptions = _getSnapDRGridOptions();
				_setupColumnFilters(gridOptions.columnsTemplate, self.vApp.machines.machinesList);
				self.vApp.machines.gridOptions = gridOptions;
				self.vApp.machines.isLoading = false;
				if (self.vApp.machines.grid) {
					self.vApp.machines.grid.refreshData();
				}
			});
		}

		function initPageActions() {
			const editAction = createAction('edit', 'label.edit');
			const deleteAction = createAction('delete', 'Delete');
			/*
			 * For replication failover groups, 'Test failover' terminology is used for creating a virtual
			 * lab.
			 */
			const createVirtualLab = createAction('createVirtualLab', 'label.testFailover');
			const failback = createAction('failback', 'label.failback');
			const plannedFailover = createAction('plannedFailover', 'label.plannedFailover');
			const testBoot = createAction('testBoot', 'label.testBoot');
			const testbootNetworkDisabled = createAction('testbootNetworkDisabled', 'label.testboot.networkDisabled');
			const testbootNetworkEnabled = createAction('testbootNetworkEnabled', 'label.testboot.networkEnabled');
			let testFailover = createAction('testFailover', 'label.testFailover');
			const undoFailover = createAction('undoFailover', 'label.undoFailover');
			let undoTestFailover = createAction('undoTestFailover', 'label.undoTestFailover');
			const unPlannedFailover = createAction('unplannedFailover', 'label.unplannedFailover');
			let viewTestFailover = createAction('viewTestFailover', 'label.viewTestFailoverVMs');

			self.actions = [];
			if (self.vApp.isSnapDR) {
				self.actions.push(editAction);
				testFailover = createAction('testFailover', 'label.testFailover.group');
				undoTestFailover = createAction('undoTestFailover', 'label.undoTestFailover.group');
			}
			self.actions.push(deleteAction);
			if (virtualLabAllowed) {
				self.actions.push(createVirtualLab);
			}
			if (failbackAllowed) {
				self.actions.push(failback);
			}
			if (failoverAllowed) {
				self.actions.push(plannedFailover);
			}
			if (!benableTestbootNetwork && testBootAllowed) {
				self.actions.push(testBoot);
			}
			if (benableTestbootNetwork && testBootAllowed) {
				self.actions.push(testbootNetworkDisabled);
				self.actions.push(testbootNetworkEnabled);
			}
			if (testFailoverAllowed) {
				self.actions.push(testFailover);
			}

			if (viewTestFailoverVMs) {
				self.actions.push(viewTestFailover);
			}

			if (undoFailoverAllowed) {
				self.actions.push(undoFailover);
			}
			if (undoTestFailoverAllowed) {
				self.actions.push(undoTestFailover);
			}
			if (failoverAllowed) {
				self.actions.push(unPlannedFailover);
			}

			function createAction(value, title) {
				return {
					value: value,
					title: cvLoc(title)
				};
			}
		}

		function performAction(index) {
			let action = self.actions[index].value;
			switch (action) {
				case 'edit':
					editSnapArrayGroup();
					break;
				case 'delete':
					drCRUDFactory.deleteGroup(self.vApp.vAppEntity.vAppId, self.vApp.vAppEntity.vAppName);
					break;
				case 'createVirtualLab':
					drVirtualLabFactory.createVirtualLab(sanitize(self.vApp));
					break;
				case 'failback':
					drOperationsFactory.failback(sanitize(self.vApp), self.subclientId);
					break;
				case 'plannedFailover':
					drOperationsFactory.plannedFailover(sanitize(self.vApp));
					break;
				case 'testBoot':
					drOperationsFactory.testBoot(sanitize(self.vApp));
					break;
				case 'testbootNetworkDisabled':
					drOperationsFactory.testBoot(sanitize(self.vApp), false);
					break;
				case 'testbootNetworkEnabled':
					drOperationsFactory.testBoot(sanitize(self.vApp), true);
					break;
				case 'testFailover':
					testFailoverGroup();
					break;
				case 'undoFailover':
					drOperationsFactory.undoFailover(sanitize(self.vApp));
					break;
				case 'undoTestFailover':
					undoTestFailoverGroup();
					break;
				case 'unplannedFailover':
					unplannedFailover();
					break;
				case 'viewTestFailover':
					viewTestFailoverMachines();
					break;
			}
		}

		function unplannedFailover() {
			if (self.vApp.isSnapDR) {
				let bodyText = cvLoc('label.confirmUnplannedFailoverArray');
				let additionalConfirm = true;
				drOperationsFactory.unPlannedFailover(sanitize(self.vApp), bodyText, additionalConfirm);
			} else {
				drOperationsFactory.unPlannedFailover(sanitize(self.vApp));
			}
		}

		/*
		 * Perform test failover for the entire group. Select only those machines that are eligible for a test
		 * failover
		 */
		function testFailoverGroup() {
			if (self.vApp.isSnapDR) {
				testFailoverForSnapDR(self.vApp.machines.machinesList, cvLoc('error.testFailoverNotEligible.group'));
			} else {
				drOperationsFactory.testFailover(sanitize(self.vApp));
			}
		}

		/*
		 * View test failover vms
		 *
		 */
		function viewTestFailoverMachines() {
			$state.go('testFailoverMachines', { replicationId: '', failoverGroupId: _.get(self.vApp, 'vAppEntity.vAppId') });
		}
		/*
		 * Perform undo test failover for the entire group. Select only those machines that are eligible for
		 * an undo test failover
		 */
		function undoTestFailoverGroup() {
			if (self.vApp.isSnapDR) {
				undoTestFailoverForSnapDR(self.vApp.machines.machinesList, cvLoc('error.undoTestFailoverNotEligible.group'));
			} else {
				drOperationsFactory.undoTestFailover(sanitize(self.vApp));
			}
		}

		/* Function to return the machines repids that do not included the provided testFailoverStatus */
		function getSupportedRepIdsUsingTestFailoverStatus(machines, unSupportedStatuses) {
			const repIds = machines
				.filter(machine => !unSupportedStatuses.includes(machine.testFailoverStatus))
				.map(machine => machine.replicationId);
			return repIds;
		}

		/* Perform test failover for a list of machines */
		function testFailoverMachines(row) {
			let rowValue = row.selectedRowValues && row.selectedRowValues.length > 0 ? row.selectedRowValues : row.rowValue;
			if (self.vApp.isSnapDR) {
				testFailoverForSnapDR(rowValue, cvLoc('error.testFailoverNotEligible.machines'));
			} else {
				// This operation is not supported for other failover group types
			}
		}

		/* Perform undo test failover for a list of machines */
		function undoTestFailoverMachines(row) {
			let rowValue = row.selectedRowValues && row.selectedRowValues.length > 0 ? row.selectedRowValues : row.rowValue;
			if (self.vApp.isSnapDR) {
				undoTestFailoverForSnapDR(rowValue, cvLoc('error.undoTestFailoverNotEligible.machines'));
			} else {
				// This operation is not supported for other failover group types
			}
		}

		function _configureIPAddress(grid) {
			if (self.vApp.isSnapDR) {
				let rows = _getSelectedRows(grid);
				if (rows.length) {
					if (rows.length > 1) {
						showErrorMessage(cvLoc('error.batchActionNotEligible'));
						return;
					}
					let machine = rows[0];

					let vAppCopy = _.cloneDeep(self.vApp);
					delete vAppCopy.machines;

					let vmGroups = _.get(vAppCopy, 'config.vmGroups', []);

					vmGroups.forEach(group => {
						let allVMs = _.get(group, 'vmSequence', []);
						allVMs.forEach(vm => {
							if (_.get(vm, 'vmInfo.vmGUID', '') == _.get(machine, 'sourceGuid')) {
								machine.clientName = machine.sourceName;
								machine.ip = vm.vmStaticIPAddressOptions;

								arrayReplicationFactory.configureIPAddress(machine).then(result => {
									vm.destComputerName = result.destComputerName;
									vm.vmStaticIPAddressOptions = _.get(result, 'ip', []);
									drCRUDFactory.updateFailoverGroup(vAppCopy); // reloads the state, so no need to refresh grid.
								});
							}
						});
					});
				}
			}
		}

		function _assignPriority(grid) {
			if (self.vApp.isSnapDR) {
				let rows = _getSelectedRows(grid);
				if (rows.length) {
					let vAppCopy = _.cloneDeep(self.vApp);
					delete vAppCopy.machines;

					arrayReplicationFactory
						.assignPriority(
							_.get(
								_.minBy(rows, row => row.priority),
								'priority',
								1
							)
						)
						.then(priority => {
							_updateVMGroupsInConfig(vAppCopy, priority, rows);
							drCRUDFactory.updateFailoverGroup(vAppCopy); // reloads the state, so no need to refresh grid.
						});
				}
			}
		}

		function _updateVMGroupsInConfig(vApp, priority, selectedMachines) {
			if (vApp && selectedMachines) {
				let vmGroups = _.get(vApp, 'config.vmGroups', []);
				let sourceGroups = vmGroups.filter(g => g.groupId != priority);

				if (sourceGroups && sourceGroups.length) {
					let targetGroup = _.find(vmGroups, { groupId: priority });

					if (!targetGroup) {
						targetGroup = {};
						targetGroup.groupId = priority;
						targetGroup.continueOnFailure = _.get(vmGroups, '[0].continueOnFailure', false);
						targetGroup.delay = _.get(vmGroups, '[0].delay', 2);
						targetGroup.vmSequence = [];
						vmGroups.push(targetGroup);
					}

					sourceGroups.forEach(group => {
						let vmSeq = _.get(group, 'vmSequence', []);

						for (let i = vmSeq.length - 1; i >= 0; i--) {
							let vm = vmSeq[i];
							let guid = _.get(vm, 'vmInfo.vmGUID', '');

							for (let j = 0; j < selectedMachines.length; j++) {
								let machine = selectedMachines[j];
								if (guid == machine.sourceGuid) {
									targetGroup.vmSequence.push(vm);
									vmSeq.splice(i, 1);
									break;
								}
							}
						}
					});

					// clean up source groups.
					for (let k = vmGroups.length - 1; k >= 0; k--) {
						let group = vmGroups[k];
						if (!group.vmSequence.length) {
							vmGroups.splice(k, 1);
						}
					}
				}
			}
		}

		function _getSelectedRows(grid) {
			let selectedRows = _.get(grid, 'selectedRowValues');
			selectedRows = selectedRows.filter(row => !_.isUndefined(row));
			if (selectedRows.length == 0) {
				selectedRows = _.get(grid, 'rowValue', []);
			}

			return selectedRows;
		}

		function testFailoverForSnapDR(machines, errMsg) {
			const status = FailoverConstants.DRTestFailoverStatus;
			const unSupportedStatuses = [
				status.DR_TEST_FAILOVER_IN_PROGRESS,
				status.DR_UNDO_TEST_FAILOVER_IN_PROGRESS,
				status.DR_TEST_FAILOVER_COMPLETE
			];
			const repIds = getSupportedRepIdsUsingTestFailoverStatus(machines, unSupportedStatuses);
			if (repIds && repIds.length > 0) {
				drOperationsFactory.testFailover(sanitize(self.vApp), repIds);
			} else {
				showErrorMessage(errMsg);
			}
		}

		function undoTestFailoverForSnapDR(machines, errMsg) {
			const status = FailoverConstants.DRTestFailoverStatus;
			const unSupportedStatuses = [
				status.DR_TEST_FAILOVER_IN_PROGRESS,
				status.DR_UNDO_TEST_FAILOVER_IN_PROGRESS,
				status.DR_TEST_FAILOVER_NONE
			];
			const repIds = getSupportedRepIdsUsingTestFailoverStatus(machines, unSupportedStatuses);
			if (repIds && repIds.length > 0) {
				drOperationsFactory.undoTestFailover(sanitize(self.vApp), repIds);
			} else {
				showErrorMessage(errMsg);
			}
		}

		/* removes the vApp of circular dependency */
		function sanitize(vApp) {
			vApp = _.cloneDeep(vApp);
			if (!!vApp) {
				vApp.machines = {};
			}
			return vApp;
		}

		var scheduleAddListener = $rootScope.$on('scheduleAdded', function(evt, addedSchedule) {
			if (addedSchedule) {
				addedSchedule.repeat = {
					enabled: addedSchedule.repeatEnabled,
					duration: addedSchedule.repeatDuration,
					hrs: addedSchedule.repeatHrs,
					mins: addedSchedule.repeatMins,
					time: addedSchedule.repeatTime
				};
				var workflowId = -1;
				var drOrchestrationType = -1;
				if (addedSchedule.vmOperationType == 'PLANNED_FAILOVER') {
					drOrchestrationType = FailoverEnum.DROrchestrationType['PLANNED_FAILOVER'];
				} else if (addedSchedule.vmOperationType == 'TEST_BOOT') {
					drOrchestrationType = FailoverEnum.DROrchestrationType['TESTBOOT'];
				}
				drScheduleFactory
					.createSchedule({
						schedule: JSON.stringify(addedSchedule),
						virtualApp: JSON.stringify(self.vApp),
						drOrchestrationType: JSON.stringify(drOrchestrationType)
					})
					.success(function(data) {
						if (!data || data.errorCode > 0) {
							showErrorMessage(data.errorMessage);
						} else {
							addedSchedule.taskId = data.taskId;
							if (addedSchedule.vmOperationType == 'PLANNED_FAILOVER') {
								self.plannedFailoverSchedules.push(addedSchedule);
							} else if (addedSchedule.vmOperationType == 'TEST_BOOT') {
								self.testBootSchedules.push(addedSchedule);
							}

							var responseContent = cvLoc('msg.scheduleCreated');
							showSuccessMessage(responseContent);
						}
					})
					.error(function(e) {
						showErrorMessage(e);
					});
			}
		});

		var scheduleDeleteListener = $rootScope.$on('scheduleDeleted', function(evt, deletedSchedule) {
			if (deletedSchedule) {
				drScheduleFactory
					.deleteSchedule(deletedSchedule.taskId)
					.success(function(data) {
						if (!data || data.errorCode > 0) {
							showErrorMessage(data.errorMessage);
						} else {
							var idToDelete = deletedSchedule.id;
							var schedules;

							if (deletedSchedule.vmOperationType == 'PLANNED_FAILOVER') {
								schedules = self.plannedFailoverSchedules;
							} else if (deletedSchedule.vmOperationType == 'TEST_BOOT') {
								schedules = self.testBootSchedules;
							}

							if (schedules) {
								schedules.forEach(function(schedule, index) {
									if (
										schedule.id == idToDelete &&
										schedule.freqType == deletedSchedule.freqType &&
										schedule.name == deletedSchedule.name
									) {
										schedules.splice(index, 1);
										return;
									}
								});
							}

							var responseContent = cvLoc('msg.scheduleDeleted');
							showSuccessMessage(responseContent);
						}
					})
					.error(function(e) {
						showErrorMessage(e);
					});
			}
		});

		var scheduleEditListener = $rootScope.$on('scheduleEdited', function(evt, editedSchedule) {
			if (editedSchedule) {
				editedSchedule.repeat = {
					enabled: editedSchedule.repeatEnabled,
					duration: editedSchedule.repeatDuration,
					hrs: editedSchedule.repeatHrs,
					mins: editedSchedule.repeatMins,
					time: editedSchedule.repeatTime
				};
				var drOrchestrationType = -1;
				if (editedSchedule.vmOperationType == 'PLANNED_FAILOVER') {
					drOrchestrationType = FailoverEnum.DROrchestrationType['PLANNED_FAILOVER'];
				} else if (editedSchedule.vmOperationType == 'TEST_BOOT') {
					drOrchestrationType = FailoverEnum.DROrchestrationType['TESTBOOT'];
				}
				drScheduleFactory
					.modifySchedule({
						taskId: editedSchedule.taskId,
						schedule: JSON.stringify(editedSchedule),
						virtualApp: JSON.stringify(self.vApp),
						drOrchestrationType: JSON.stringify(drOrchestrationType)
					})
					.success(function(data) {
						if (!data || data.errorCode > 0) {
							showErrorMessage(data.errorMessage);
						} else {
							var idToEdit = editedSchedule.id;
							var schedules;

							if (editedSchedule.vmOperationType == 'PLANNED_FAILOVER') {
								schedules = self.plannedFailoverSchedules;
							} else if (editedSchedule.vmOperationType == 'TEST_BOOT') {
								schedules = self.testBootSchedules;
							}

							if (schedules) {
								schedules.forEach(function(schedule, index) {
									if (schedule.id == idToEdit) {
										schedules[index] = editedSchedule;
										return;
									}
								});
							}

							var responseContent = cvLoc('msg.scheduleEdited');
							showSuccessMessage(responseContent);
						}
					})
					.error(function(e) {
						showErrorMessage(e);
					});
			}
		});

		/*
		 * The below listeners are at the rootscope level and hence have to be destroyed when the controller
		 * gets destroyed. Otherwise, these listeners will be called even when schedules are being added in a
		 * different page.
		 */
		$scope.$on('$destroy', function() {
			scheduleAddListener();
			scheduleEditListener();
			scheduleDeleteListener();
		});

		/* ===== Helper Functions ==== */

		/**
		 * Shows the cvToaster success message
		 */
		function showSuccessMessage(content) {
			cvToaster.showSuccessMessage({
				ttl: toasterTTL,
				message: content
			});
		}

		/**
		 * Shows the cvToaster error message
		 */
		function showErrorMessage(content) {
			cvToaster.showErrorMessage({
				ttl: toasterTTL,
				message: content ? content : cvLoc('generic_error')
			});
		}
	}
]);

export default failoverMod;
