import 'modules/disasterRecovery/js/dr.constants.js';
import 'modules/disasterRecovery/js/factory/dr.factory.js';
import 'modules/disasterRecovery/js/factory/drAutoFailover.factory.js';
import 'modules/disasterRecovery/js/factory/drScript.factory.js';
import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';
import 'modules/disasterRecovery/js/directives/cv-vsa-replication-target-directive.js';
import 'modules/disasterRecovery/js/directives/dr-network.directive.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * The file has the controller for the failover group create page. Functions include fetching the server /
 * server groups, failover eligible machines, creating failover groups and user input validation
 */

var failoverMod = drAppFailoverModule;

failoverMod.controller('failoverGroupCreateController', [
	'$scope',
	'$state',
	'$stateParams',
	'$uibModalInstance',
	'cvToaster',
	'cvUtil',
	'cvLoc',
	'cvTableOptions',
	'cvPageActionsFactory',
	'cvBreadcrumbsTabsFactory',
	'controllerParams',
	'failoverService',
	'drScriptFactory',
	'drOrchestrationFactory',
	'drAutoFailoverFactory',
	'FailoverEnum',
	'FailoverConstants',
	'FailoverTextForEnum',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$state,
		$stateParams,
		$uibModalInstance,
		cvToaster,
		cvUtil,
		cvLoc,
		cvTableOptions,
		cvPageActionsFactory,
		cvBreadcrumbsTabsFactory,
		controllerParams,
		failoverService,
		drScriptFactory,
		drOrchestrationFactory,
		drAutoFailoverFactory,
		FailoverEnum,
		FailoverConstants,
		FailoverTextForEnum,
		VM_POLICY_APP_TYPE
	) {
		var self = this;

		// variables
		self.isEditMode = !_.isEmpty(controllerParams.vApp);
		self.vApp = initvApp(controllerParams.vApp);
		self.autoFailoverMachines = [];
		self.destinationServerRequired = false;
		self.isDataLoading = true;
		self.isMachineDataLoading = false;
		self.lifeCyclePolicies = [];
		self.localLangDestinationHypervisor = {};
		self.localLangMachines = {};
		self.localLangMonitoringMachines = {};
		self.localLangReplicationTarget = {};
		self.localLangUsers = {};
		self.machinesList = [];
		self.servers = [];
		self.serversDestination = [];
		self.showAutoFailoverOptions = false;
		self.vAppSource = controllerParams.vAppSource;
		self.vAppSourceText = cvLoc(
			`label.source.${FailoverTextForEnum.VAppSource[controllerParams.vAppSource].toLowerCase()}`
		);
		self.vAppOperation = FailoverConstants.VAppOperation.FAILOVER;

		// functions
		self.addPostScript = drScriptFactory.openPostScriptDialog;
		self.addPreScript = drScriptFactory.openPreScriptDialog;
		self.createFailoverGroup = createFailoverGroup;
		self.enableSaveButton = enableSaveButton;
		self.showMachines = showMachines;
		self.showMachinesFromDestinationHypervisor = showMachinesFromDestinationHypervisor;
		self.validateAutoFailoverMachineSelection = validateAutoFailoverMachineSelection;
		self.cancel = cancel;
		self.ctrl = {};
		self.isSourceBackup = isSourceBackup;
		self.isSourceReplication = isSourceReplication;
		self.isSourceArrayReplication = isSourceArrayReplication;

		// validation messges
		self.approvalValidation = cvUtil.emptyMsg();
		self.autofailoverMachineValidation = cvUtil.emptyMsg();
		self.groupNameValidation = cvUtil.emptyMsg();
		self.machineValidation = cvUtil.emptyMsg();
		self.lifeCycleValidation = cvUtil.emptyMsg();

		// local variables
		var isClientGroupsDataLoading = true;
		var isHypvervisorDataLoading = true;
		var requiredMachinesCountforAutofailover = 3;

		self.localLangMachines = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectMachine'));
		self.localLangDestinationHypervisor = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectDestinationHypervisor'));
		self.localLangMonitoringMachines = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectMonitoringMachine'));
		self.localLangUsers = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectUsers'));
		self.localLangPolicy = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectLabPolicy'));
		self.policyAppType = VM_POLICY_APP_TYPE.REPLICATION;

		/**
		 * Fetches the list of all the clients groups, creates a header for the isteven class and pushes the
		 * data to servers
		 */
		drOrchestrationFactory.getClientGroups().then(function() {
			isClientGroupsDataLoading = false;
			self.isDataLoading = isClientGroupsDataLoading || isHypvervisorDataLoading;

			var header = {
				name: '<strong>' + cvLoc('label.serverGroups') + '</strong>',
				header: true
			};
			var end = {
				header: false
			};
			self.servers = self.servers.concat(header);
			self.servers = self.servers.concat(drOrchestrationFactory.clientGroups);
			self.servers = self.servers.concat(end);
		});

		drOrchestrationFactory.getHyperVisors().then(function() {
			isHypvervisorDataLoading = false;
			self.isDataLoading = isClientGroupsDataLoading || isHypvervisorDataLoading;

			var header = {
				name: '<strong>' + cvLoc('label.hypervisors') + '</strong>',
				header: true
			};
			var end = {
				header: false
			};
			self.servers = self.servers.concat(header);
			self.servers = self.servers.concat(drOrchestrationFactory.hypervisors);
			self.servers = self.servers.concat(end);
		});

		drOrchestrationFactory.getUsers().then(function() {
			self.users = drOrchestrationFactory.users;
		});

		drOrchestrationFactory.getProxyServers('VMW').then(function() {
			var header = {
				name: '<strong>' + cvLoc('label.source') + '</strong>',
				header: true
			};

			var end = {
				header: false
			};
			self.autoFailoverMachines = self.autoFailoverMachines.concat(header);
			self.autoFailoverMachines = self.autoFailoverMachines.concat(drOrchestrationFactory.proxyServers);
			self.autoFailoverMachines = self.autoFailoverMachines.concat(end);
		});

		drOrchestrationFactory.getLifeCyclePolicies().then(function() {
			self.lifeCyclePolicies = self.lifeCyclePolicies.concat(drOrchestrationFactory.lifeCyclePolicies);
		});

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'machinesList',
			enableGridMenu: false,
			paginationPageSizes: [5, 10, 15],
			paginationPageSize: 5,
			columnDefs: [
				{
					field: 'client.clientName',
					sort: {
						direction: 'asc'
					},
					displayName: cvLoc('label.source'),
					cellTemplate: '<span class="crop">{{row.entity.client.clientName}}</span>'
				},
				{
					field: 'destClient.clientName',
					displayName: cvLoc('label.destination'),
					cellTemplate: '<span class="crop">{{row.entity.destClient.clientName}}</span>'
				},
				{
					field: 'entity.groupId',
					displayName: cvLoc('label.priority'),
					cellClass: 'margin-top-0',
					cellTemplate: '<input type="number" ng-model=row.entity.groupId ng-min="1" ng-required >'
				},
				{
					field: 'actions',
					displayName: cvLoc('label.actions'),
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" data-ng-click="grid.appScope.addPreScript(row.entity)">' +
						cvLoc('label.addPreScript') +
						'</a></li><li><a href data-ng-click="grid.appScope.addPostScript(row.entity)">' +
						cvLoc('label.addPostScript') +
						'</a></li></ul></div>'
				}
			],
			onRegisterApi: function(gridApi) {
				self.getSelectedRows = function() {
					return gridApi.selection.getSelectedRows();
				};
			}
		});

		self.gridOptions = {
			cvTableName: 'machineTable',
			cvSearchFields: ['client.clientName', 'destClient.clientName'],
			cvGridDirectives: {
				uiGridSelection: true
			},
			cvGridCssClass: {
				'users-grid': true,
				'grid-style': true
			},
			cvOnGridEmpty: {
				message: cvLoc('msg.noVMsAvailable')
			},
			cvAppScope: self,
			gridOptions: globalGridOptions
		};

		/**
		 * Fetches the list of all the failover eligible machines for the selected client / client group. Adds
		 * a default group id of 1 to each of the machine. Does a check for the list of all the supported
		 * vendor types for the Auto failover options Does a check for the list of all the supported vendor
		 * types for the destination hypervisor Builds the destination hypervisor in case there are multiple
		 * destination for replication serversMap: serverMap[destinationClientId] = {machine1, machine2} ->
		 * Contains all the machines against each destinationclientid Note that clientid and serverid are same
		 * values, just different terminology
		 */
		function showMachines() {
			self.destinationServerRequired = false;
			self.serversMap = {};
			self.serversDestination = [];
			self.machinesList = [];
			angular.forEach(self.serversList, function(server, key) {
				self.isMachineDataLoading = true;
				let entityType = server.isClientGroup ? 'clientGroup' : 'client';
				drOrchestrationFactory.getMachinesList(server.id, entityType, self.vAppSource).then(function() {
					self.isMachineDataLoading = false;
					self.showAutoFailoverOptions = false;
					switch (self.vAppSource) {
						case FailoverEnum.VAppSource['BACKUP']:
							showBackedupMachines();
							break;
						case FailoverEnum.VAppSource['REPLICATION']:
							showReplicatedMachines();
							break;
					}
				});
			});
		}

		/**
		 * Shows up the list of machines based on the destination hypervisor selected
		 */
		function showMachinesFromDestinationHypervisor(selectedDestination) {
			if (angular.isUndefined(selectedDestination)) {
				selectedDestination = self.serversDestinationSelected[0];
			}
			self.showAutoFailoverOptions = false;
			hideActionsColumn();
			self.machinesList = self.serversMap[selectedDestination.id];
			self.machinesList.forEach(function(machine) {
				handleAutoFailoverVisibility(machine.vendor, machine.destVendor);
				handleScriptVisibility(machine.vendor, machine.destVendor);
			});
			self.destVendor = self.machinesList && self.machinesList.length > 0 && self.machinesList[0].destVendor;
			$scope.$broadcast('showReplicationTargets', self.destVendor);
		}

		function validateGroupName() {
			return Boolean(_.get(self, 'vApp.vAppEntity.vAppName', false));
		}

		function validateMachineSelection() {
			var selectedMachines = self.getSelectedRows();
			return Boolean(selectedMachines) && selectedMachines.length > 0;
		}

		function validateLifecyclePolicy() {
			if (isSourceBackup()) {
				return true;
			}
			return self.lifeCyclePolicySelected && self.lifeCyclePolicySelected.length > 0;
		}

		function validateApproval() {
			if (isSourceReplication()) {
				return true;
			}
			if (self.approvalRequired && self.usersSelected.length == 0) {
				return false;
			} else {
				return true;
			}
		}

		function validatePrioritySelection() {
			return !self.getSelectedRows().filter(row => !row.groupId || row.groupId < 1).length > 0;
		}

		/*
		 * Verifies if a minimum of 3 machines have been selected. Not a mandatory field. The user should be
		 * able to leave this field empty
		 */
		function validateAutoFailoverMachineSelection() {
			if (
				self.autoFailoverMachines &&
				self.autoFailoverMachines.length >= 0 &&
				self.autoFailoverSelectedMachines &&
				self.autoFailoverSelectedMachines.length < requiredMachinesCountforAutofailover &&
				self.autoFailoverSelectedMachines.length != 0
			) {
				self.autofailoverMachineValidation = {
					message: cvLoc('msg.minimumMachinesAutofailover'),
					type: 'error'
				};
				return false;
			} else {
				self.autofailoverMachineValidation = cvUtil.emptyMsg();
				return true;
			}
		}

		function enableSaveButton() {
			return (
				validateGroupName() &&
				validateMachineSelection() &&
				validatePrioritySelection() &&
				validateApproval() &&
				self.validateAutoFailoverMachineSelection()
			);
		}

		//initial functions
		showActionsColumn();

		function createFailoverGroup() {
			var validationPassed = true;
			if (!validateGroupName()) {
				self.groupNameValidation = {
					message: cvLoc('msg.groupNameRequired'),
					type: 'error'
				};
				validationPassed = false;
			} else {
				self.groupNameValidation = cvUtil.emptyMsg();
			}
			if (isSourceArrayReplication()) {
				validationPassed = validationPassed && self.ctrl.isArrayReplicationValid(self.vApp);
			} else if (isSourceBackup() || isSourceReplication()) {
				if (!validateMachineSelection()) {
					self.machineValidation = {
						message: cvLoc('msg.minimumMachines'),
						type: 'error'
					};
					validationPassed = false;
				} else if (!validatePrioritySelection()) {
					self.machineValidation = {
						message: cvLoc('msg.validPriorityForAllMachines'),
						type: 'error'
					};
					validationPassed = false;
				} else {
					self.machineValidation = cvUtil.emptyMsg();
				}

				if (!validateApproval()) {
					self.approvalValidation = {
						message: cvLoc('msg.selectUserForApproval'),
						type: 'error'
					};
					validationPassed = false;
				} else {
					self.approvalValidation = cvUtil.emptyMsg();
				}

				if (!validateAutoFailoverMachineSelection()) {
					validationPassed = false;
				}
			}
			if (!validationPassed) {
				return;
			}

			let vAppCopy = {};
			if (isSourceArrayReplication()) {
				self.vApp.replicationType = FailoverEnum.DRReplicationType.SnapArrayReplication;
				self.vApp.source = FailoverEnum.VAppSource['REPLICATION'];
				self.ctrl.onSubmitArrayReplication(self.vApp);
				/* Construct a separate variable with only the required inputs to create the group */
				vAppCopy.clientList = self.vApp.clientList;
				vAppCopy.config = self.vApp.config;
				vAppCopy.isClientGroup = self.vApp.isClientGroup;
				vAppCopy.operationType = self.vApp.operationType;
				vAppCopy.policy = self.vApp.policy;
				vAppCopy.replicationType = self.vApp.replicationType;
				vAppCopy.selectedEntities = self.vApp.selectedEntities;
				vAppCopy.source = self.vApp.source;
				vAppCopy.vAppEntity = self.vApp.vAppEntity;
				vAppCopy.arrayReplication = self.vApp.arrayReplication;
			} else {
				var selectedServer = self.serversList[0];
				self.vApp = self.vApp || {};
				self.vApp.vAppEntity = self.vApp.vAppEntity || {};
				self.vApp.source = self.vAppSource;
				switch (self.vAppSource) {
					case FailoverEnum.VAppSource['BACKUP']:
						self.vApp.operationType = FailoverEnum.VAppOperation['LIVEMOUNT'];
						self.vApp.approvalRequired = null;
						break;
					case FailoverEnum.VAppSource['REPLICATION']:
						self.vApp.operationType = FailoverEnum.VAppOperation['FAILOVER'];
						self.vApp.approvalRequired = self.approvalRequired;
						break;
				}
				self.vApp.isClientGroup = self.serversList[0].isClientGroup;

				self.vApp.clientList = [];
				self.vApp.config = {};
				self.vApp.config.vmGroups = [];

				var selectedMachines = self.getSelectedRows();
				var instanceId = 0;
				selectedMachines.forEach(function(selectedMachine) {
					var machine = {};
					machine.GUID = selectedMachine.client.GUID;
					machine.backupsetId = selectedMachine.backupSet.backupsetId;
					machine.backupsetName = selectedMachine.backupSet.backupsetName;
					machine.clientId = selectedMachine.client.clientId;
					machine.clientName = selectedMachine.client.clientName;
					machine.entityId = selectedMachine.replicationId;
					if (instanceId == 0 && !angular.isUndefined(selectedMachine.client.instanceId)) {
						instanceId = selectedMachine.client.instanceId;
					}
					self.vApp.clientList.push(machine);

					var vmSequence = {};
					vmSequence.copyPrecedence = selectedMachine.copyPrecedence;
					vmSequence.replicationId = selectedMachine.replicationId;
					var vmInfo = {};
					vmInfo.vmGUID = selectedMachine.client.GUID;
					vmInfo.vmName = selectedMachine.client.clientName;
					vmSequence.vmInfo = vmInfo;
					vmSequence.preScript = selectedMachine.preScript;
					vmSequence.postScript = selectedMachine.postScript;
					vmSequence.delay = 1;

					var vmGroups = self.vApp.config.vmGroups;
					var vmGroup;
					var added = false;
					if (vmGroups) {
						vmGroups.forEach(function(group) {
							if (group.groupId == selectedMachine.groupId) {
								group.vmSequence.push(vmSequence);
								added = true;
							}
						});
					} else {
						vmGroups = [];
					}
					if (!added) {
						vmGroup = {};
						vmGroup.vmSequence = [];
						vmGroup.delay = self.vApp.delay;
						vmGroup.continueOnFailure = self.vApp.continueOnFailure;
						vmGroup.groupId = selectedMachine.groupId;
						vmGroup.vmSequence.push(vmSequence);
						self.vApp.config.vmGroups.push(vmGroup);
					}
				});
				//moving selectedEntities code afte iterating the
				self.vApp.selectedEntities = [];
				var selectedEntity = {};
				selectedEntity.clientId = selectedServer.id;
				selectedEntity.entityId = selectedServer.id;
				selectedEntity.entityName = selectedServer.name;
				if (!angular.isUndefined(selectedServer.instanceId) && selectedServer.instanceId > 0) {
					selectedEntity.instanceId = selectedServer.instanceId;
				} else if (!angular.isUndefined(instanceId) && instanceId > 0) {
					selectedEntity.instanceId = instanceId;
				}

				self.vApp.selectedEntities.push(selectedEntity);
				self.vApp.usersForApproval = [];
				if (self.usersSelected) {
					self.usersSelected.forEach(function(user) {
						self.vApp.usersForApproval.push(user);
					});
				}

				if (self.autoFailoverSelectedMachines && self.autoFailoverSelectedMachines.length > 0) {
					drAutoFailoverFactory.handleAutofailoverOptions(
						self.vApp,
						self.autoFailoverSelectedMachines,
						self.autoFailoverDelay
					);
				}

				if (self.selectedTarget && self.selectedTarget.length > 0) {
					var target = self.selectedTarget[0];
					self.vApp.policy = target;
					if (drOrchestrationFactory.isVirtualLabTarget(target)) {
						self.vApp.isVirtualLab = true;
						self.vApp.config.vmPolicy = target.entity;
					}
				}

				if (isSourceBackup() && self.lifeCyclePolicySelected && self.lifeCyclePolicySelected.length > 0) {
					self.vApp.policy = self.lifeCyclePolicySelected[0];
					if (drOrchestrationFactory.isVirtualLabTarget(self.lifeCyclePolicySelected)) {
						self.vApp.isVirtualLab = true;
						self.vApp.config.vmPolicy = self.lifeCyclePolicySelected.entity;
					}
				}
			}

			let vAppToSave = isSourceArrayReplication() ? vAppCopy : self.vApp;
			let promise = self.isEditMode ? failoverService.updateFailoverGroup : failoverService.createFailoverGroup;
			promise({
				virtualApp: JSON.stringify(vAppToSave)
			})
				.success(function(data) {
					if (!data || !data.resp || data.resp.errorCode > 0) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: data && data.resp && data.resp.errorMessage ? data.resp.errorMessage : cvLoc('generic_error')
						});
					} else {
						var responseContent = '';
						if (self.isEditMode) {
							responseContent = cvLoc('msg.updateSuccessful');
						} else {
							var vAppId = data.entity.vAppId;
							var vAppName = data.entity.vAppName;
							var groupURL = '#/failoverDetails/' + vAppId;
							var responseContent =
								' <a href="' + groupURL + '">' + cvLoc('msg.addSuccessful') + ' ' + vAppName + '</a>';
							$state.transitionTo('failover', $stateParams, {
								reload: true,
								inherit: false,
								notify: true
							});
						}
						cvToaster.showSuccessMessage({
							ttl: '10000',
							message: responseContent
						});
						$uibModalInstance.close();
					}
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e ? e : cvLoc('generic_error')
					});
				});
		}

		function handleScriptVisibility(srcVendor, destVendor) {
			if (!srcVendor || !destVendor) {
				return;
			}
			var showPreScript = false;
			var showPostScript = false;

			drScriptFactory.isPreScriptSupported(srcVendor, destVendor) ? (showPreScript = true) : '';
			drScriptFactory.isPostScriptSupported(srcVendor, destVendor) ? (showPostScript = true) : '';
			showPreScript || showPostScript ? showActionsColumn() : '';
		}

		function handleAutoFailoverVisibility(srcVendor, destVendor) {
			drAutoFailoverFactory.isSupportedVendor(srcVendor, destVendor) ? (self.showAutoFailoverOptions = true) : '';
		}

		function hideActionsColumn() {
			getActionsColumn().visible = false;
		}

		function showActionsColumn() {
			getActionsColumn().visible = true;
		}

		function getActionsColumn() {
			if (self.gridOptions.gridOptions.columnDefs && self.gridOptions.gridOptions.columnDefs[3]) {
				if (self.gridOptions.gridOptions.columnDefs[3].field === 'actions') {
					return self.gridOptions.gridOptions.columnDefs[3];
				} else {
					var index = -1;
					for (var i = 0; i < self.gridOptions.gridOptions.columnDefs.length; i++) {
						if (self.gridOptions.gridOptions.columnDefs[i].field === 'actions') {
							index = i;
						}
					}
					return self.gridOptions.gridOptions.columnDefs[index];
				}
			}
		}

		function showBackedupMachines() {
			if (drOrchestrationFactory.failoverEligibleMachines.length > 0) {
				drOrchestrationFactory.removeAllGridColumns(self.gridOptions.gridOptions.columnDefs);
				self.gridOptions.gridOptions.columnDefs = drOrchestrationFactory.createBackupMachinesGridColumns();
				drOrchestrationFactory.failoverEligibleMachines.forEach(function(machine) {
					// Machines are added to group 1 by default
					machine.groupId = 1;
					machine.destClient.clientName = machine.client.clientName + '_LM_<JobID>';
				});
				self.machinesList = drOrchestrationFactory.failoverEligibleMachines;
			} else {
				// if no machines are eligible for failover, set the machineslist to empty
				self.machinesList = [];
			}
		}

		function showReplicatedMachines() {
			if (drOrchestrationFactory.failoverEligibleMachines.length > 0) {
				drOrchestrationFactory.removeAllGridColumns(self.gridOptions.gridOptions.columnDefs);
				self.gridOptions.gridOptions.columnDefs = drOrchestrationFactory.createReplicatedMachinesGridColumns();
				drOrchestrationFactory.failoverEligibleMachines.forEach(function(machine) {
					// Machines are added to group 1 by default
					machine.groupId = 1;
					if (drOrchestrationFactory.isSupportedDestHypervisor(machine.vendor, machine.destVendor)) {
						if (self.serversMap[machine.destinationClient.clientId]) {
							self.serversMap[machine.destinationClient.clientId].push(machine);
						} else {
							self.serversMap[machine.destinationClient.clientId] = [];
							self.serversMap[machine.destinationClient.clientId].push(machine);
						}
					}
					handleAutoFailoverVisibility(machine.vendor, machine.destVendor);
					handleScriptVisibility(machine.vendor, machine.destVendor);
				});
			} else {
				// if no machines are eligible for failover, set the machineslist to empty
				self.machinesList = [];
			}

			// If the self.serversMap has more than one entry, it indicates that the same machines are replicated to multiple destination hypervisors, in which case, show all the destination hypervisors. The user will have to select the destination hypervisor and the corresponding machines are shown to the user.
			// self.serversDestination contains the list of all the destination hypervisors
			if (Object.keys(self.serversMap).length > 1) {
				self.destinationServerRequired = true;
				// builds the destination server
				Object.keys(self.serversMap).forEach(function(clientId) {
					var machines = self.serversMap[clientId];
					if (machines && machines.length > 0) {
						var machine = machines[0];
						var destinationServer = {};
						destinationServer.id = machine.destinationClient.clientId;
						destinationServer.name = machine.destinationClient.clientName;
						self.serversDestination.push(destinationServer);
					}
				});
				self.serversDestination[0].selected = true;
				showMachinesFromDestinationHypervisor(self.serversDestination[0]);
			} else if (Object.keys(self.serversMap).length > 0) {
				// implies that there is at-least one supported vendor.
				Object.keys(self.serversMap).forEach(function(clientId) {
					self.machinesList = self.serversMap[clientId];
				});
			}

			self.destVendor = self.machinesList && self.machinesList.length > 0 && self.machinesList[0].destVendor;
			$scope.$broadcast('showReplicationTargets', self.destVendor);
		}

		function initvApp(vApp) {
			vApp = vApp || {};
			vApp.page = 'failoverCreate';
			vApp.machines = vApp.machines || {};
			vApp.machines.actionMenu = [];
			vApp.arrayReplication = vApp.arrayReplication || {};
			vApp.arrayReplication.restoreOption = vApp.arrayReplication.restoreOption || {};
			vApp.arrayReplication.restoreOption.nics = vApp.arrayReplication.restoreOption.nics || [];
			vApp.delay = _.get(vApp, 'config.vmGroups[0].delay', 2);
			vApp.continueOnFailure = _.get(vApp, 'config.vmGroups[0].continueOnFailure', false);

			return vApp;
		}

		function isSourceBackup() {
			return self.vAppSource === FailoverEnum.VAppSource.BACKUP;
		}

		function isSourceReplication() {
			return self.vAppSource === FailoverEnum.VAppSource.REPLICATION;
		}

		function isSourceArrayReplication() {
			return self.vAppSource === FailoverEnum.VAppSource.ARRAYREPLICATION;
		}

		function cancel() {
			$uibModalInstance.dismiss();
		}

		// Helper function
		/*
		 * Checks if the reg key has been enabled in the AdminConsole path
		 */
		function isACRegKeyEnabled(regkeyName) {
			return !!(
				cv &&
				cv.additionalSettings &&
				cv.additionalSettings.AdminConsole &&
				cv.additionalSettings.AdminConsole[regkeyName]
			);
		}
	}
]);

export default failoverMod;
