import 'modules/disasterRecovery/js/directives/dr-ip.directive.js';

import { drAppFailoverModule } from 'common/js/modules';

export class ConfigureArrayMachinesController {
	constructor($uibModalInstance, machine) {
		this.$uibModalInstance = $uibModalInstance;
		this.machine = machine;
		this._init();
	}

	close() {
		this.$uibModalInstance.dismiss();
	}

	submit() {
		let self = this;
		if (this.ctrl.onSubmitIP) {
			this.machine.ip = this.ctrl.onSubmitIP();
		}
		this.machine.ip.forEach(i => (i.destComputerName = self.machine.destComputerName));
		this.$uibModalInstance.close(this.machine);
	}

	_init() {
		this.machine = this.machine || {};
		this.machine.ip = this.machine.ip || [];
		this.ctrl = {};
	}
}

ConfigureArrayMachinesController.$inject = ['$uibModalInstance', 'machine'];
drAppFailoverModule.controller('configureArrayMachinesController', ConfigureArrayMachinesController);

export default drAppFailoverModule;
