import 'modules/disasterRecovery/js/controllers/devtestGroup/devtestGroupCreate.ctrl.js';
import 'modules/disasterRecovery/js/dr.constants.js';
import 'modules/disasterRecovery/js/factory/dr.factory.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/disasterRecovery/js/factory/drOperations.factory.js';
import 'modules/disasterRecovery/js/factory/drVirtualLab.factory.js';
import * as devtestColumnsTemplate from 'modules/disasterRecovery/js/columns/devtestGroup.column.template.js';
import { drAppFailoverModule } from 'common/js/modules';

/**
 * Shows the list of Devtest groups
 */

export class DevtestGroupListController {
	constructor(
		$scope,
		$state,
		$modal,
		cvUtil,
		cvLoc,
		drOrchestrationFactory,
		drCRUDFactory,
		drVirtualLabFactory,
		FailoverConstants
	) {
		this.$scope = $scope;
		this.$state = $state;
		this.$modal = $modal;
		this.cvUtil = cvUtil;
		this.cvLoc = cvLoc;
		this.drOrchestrationFactory = drOrchestrationFactory;
		this.drCRUDFactory = drCRUDFactory;
		this.drVirtualLabFactory = drVirtualLabFactory;
		this.FailoverConstants = FailoverConstants;
		this._init();
	}

	_init() {
		this.isSnapDREnabled = _.get(cvConfig, 'enableSnapDRDevtest', false);
		this._setupGridOptions();
	}

	_setupGridOptions() {
		let self = this;
		this.gridOptions = {};
		this.$scope.gridOptions = this.gridOptions;
		this.gridOptions.sortDirection = {
			field: 'vAppEntity.vAppName',
			dir: 'asc'
		};
		this.gridOptions.columns = this._initColumnDefs();
		this.gridOptions.gridTitle = this.cvLoc('label.nav.devtest');
		this.gridOptions.tableName = 'devtestGroupTable';
		this.gridOptions.idField = 'vAppEntity.vAppName';
		this.gridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
		this.gridOptions.url = this._getDevtestGroups.bind(this);
		this.gridOptions.usePageToolbar = true;
		this.gridOptions.gridToolbarMenu = this._getGridToolbarMenu();
		this.gridOptions.actionMenu = [
			{
				id: 'Delete',
				label: this.cvLoc('Delete'),
				onSelect: this._deleteGroup.bind(this),
				contextMenuOnly: false
			},
			{
				id: 'TestFailover',
				label: this.cvLoc('label.createVirtualLab'),
				onSelect: this._testFailover.bind(this),
				contextMenuOnly: false
			}
		];
	}

	_initColumnDefs() {
		return devtestColumnsTemplate.getColumns(this._onActionsClick.bind(this), {
			cvLoc: this.cvLoc,
			cvUtil: this.cvUtil
		});
	}

	_getDevtestGroups(options) {
		let self = this;
		self.devtestGroups = [];
		this.drCRUDFactory.getDevtestGroups().then(function() {
			/* currently, support is only for Snap Array replication */
			if (self.isSnapDREnabled) {
				let groups = self.drCRUDFactory.devtestGroups.filter(
					group => group.replicationType === self.FailoverConstants.DRReplicationType.SnapArrayReplication
				);
				self.devtestGroups = self.devtestGroups.concat(groups);
			} else {
				self.devtestGroups = [];
			}
			self.devtestGroups.forEach(group => (group.vendor = 'VMW'));
			options.success(self.devtestGroups);
		});
	}

	_createDevtestURL() {
		let self = this;
		this.drOrchestrationFactory.openDevtestCreateModal().result.then(function() {
			self.$state.reload();
		});
	}

	_deleteGroup(row) {
		let vApp = row.selectedRowValues && row.selectedRowValues.length > 0 ? row.selectedRowValues[0] : row.rowValue;
		let appId = vApp.vAppEntity.vAppId;
		let appName = vApp.vAppEntity.vAppName;
		this.drCRUDFactory.deleteGroup(appId, appName, 'devtest');
	}

	_testFailover(row) {
		let vApp = row.selectedRowValues && row.selectedRowValues.length > 0 ? row.selectedRowValues[0] : row.rowValue;
		this.drVirtualLabFactory.createVirtualLab(vApp);
	}

	_onActionsClick(event) {
		event.preventDefault();
	}

	_getGridToolbarMenu() {
		let toolbarMenu = [];
		if (this.isSnapDREnabled) {
			toolbarMenu.push({
				id: 'AddRecoveryGroupButton',
				label: this.cvLoc('label.add'),
				onSelect: this._createDevtestURL.bind(this)
			});
		}

		return toolbarMenu;
	}
}

DevtestGroupListController.$inject = [
	'$scope',
	'$state',
	'$uibModal',
	'cvUtil',
	'cvLoc',
	'drOrchestrationFactory',
	'drCRUDFactory',
	'drVirtualLabFactory',
	'FailoverConstants'
];
drAppFailoverModule.controller('devtestGroupListController', DevtestGroupListController);

export default drAppFailoverModule;
