import 'modules/disasterRecovery/js/directives/dr-array-replication.directive.js';
import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';

import { drAppFailoverModule } from 'common/js/modules';

export class DevtestGroupCreateController {
	constructor($state, $uibModalInstance, cvToaster, cvLoc, vApp, failoverService, FailoverEnum) {
		this.$state = $state;
		this.$uibModalInstance = $uibModalInstance;
		this.cvToaster = cvToaster;
		this.cvLoc = cvLoc;
		this.vApp = vApp;
		this.failoverService = failoverService;
		this.FailoverEnum = FailoverEnum;
		this.isEditMode = !_.isEmpty(vApp);
		this._init();
	}

	createDevtestGroup() {
		let self = this;
		if (!this._isValidForm()) {
			return;
		}

		if (this.vApp.source === this.vAppSourceValues['ARRAYREPLICATION']) {
			this.vApp.replicationType = this.FailoverEnum.DRReplicationType.SnapArrayReplication;
			this.ctrl.onSubmitArrayReplication(this.vApp);
		}

		/* Construct a separate variable with the required inputs to create a Devtest group */
		let vAppCopy = {};
		vAppCopy.clientList = this.vApp.clientList;
		vAppCopy.config = this.vApp.config;
		vAppCopy.isClientGroup = this.vApp.isClientGroup;
		vAppCopy.operationType = this.vApp.operationType;
		vAppCopy.policy = this.vApp.policy;
		vAppCopy.replicationType = this.vApp.replicationType;
		vAppCopy.selectedEntities = this.vApp.selectedEntities;
		vAppCopy.source = this.vApp.source;
		vAppCopy.vAppEntity = this.vApp.vAppEntity;
		vAppCopy.arrayReplication = this.vApp.arrayReplication;

		let promise = this.isEditMode ? this.failoverService.updateFailoverGroup : this.failoverService.createFailoverGroup;
		promise({
			virtualApp: JSON.stringify(vAppCopy)
		})
			.success(function(data) {
				if (!data || !data.resp || data.resp.errorCode > 0) {
					self._showErrorMessage(
						data && data.resp && data.resp.errorMessage ? data.resp.errorMessage : self.cvLoc('generic_error')
					);
				} else {
					let vAppId = data.entity.vAppId;
					let vAppName = data.entity.vAppName;
					let groupURL = '#/devtestDetails/' + vAppId;
					let responseContent =
						' <a href="' + groupURL + '">' + self.cvLoc('msg.addSuccessful') + ' ' + vAppName + '</a>';
					if (self.isEditMode) {
						responseContent = self.cvLoc('msg.updateSuccessful');
					}
					self._showSuccessMessage(responseContent);
					self.$state.reload();
					self.close();
				}
			})
			.error(function(e) {
				self._showErrorMessage(e);
			});
	}

	close() {
		this.$uibModalInstance.dismiss();
	}

	_init() {
		this.ctrl = {};
		this.vApp = this.vApp || {};
		this.vApp.operationType = this.FailoverEnum.VAppOperation['LIVEMOUNT'];
		this.vAppSourceValues = this.FailoverEnum.VAppSource; // created to refer the constants in the jsp file
		this.vApp.source = this.FailoverEnum.VAppSource['ARRAYREPLICATION'];
		this.vApp.delay = _.get(this, 'vApp.config.vmGroups[0].delay', 2);
		this.vApp.continueOnFailure = _.get(this, 'vApp.config.vmGroups[0].continueOnFailure', false);
	}

	_isAppNameValid() {
		return Boolean(_.get(this, 'vApp.vAppEntity.vAppName', false));
	}

	_isValidForm() {
		let validForm = true;
		if (this.vApp.source === this.vAppSourceValues['ARRAYREPLICATION']) {
			validForm = validForm && this.ctrl.isArrayReplicationValid(this.vApp);
		}
		validForm = validForm && this._isAppNameValid();

		return validForm;
	}

	_showSuccessMessage(msg) {
		this.cvToaster.showSuccessMessage({
			ttl: '10000',
			message: msg
		});
	}

	_showErrorMessage(e) {
		this.cvToaster.showErrorMessage({
			ttl: '10000',
			message: e ? e : this.cvLoc('generic_error')
		});
	}
}

DevtestGroupCreateController.$inject = [
	'$state',
	'$uibModalInstance',
	'cvToaster',
	'cvLoc',
	'vApp',
	'failoverService',
	'FailoverEnum'
];
drAppFailoverModule.controller('devtestGroupCreateController', DevtestGroupCreateController);

export default drAppFailoverModule;
