import 'modules/disasterRecovery/js/factory/dr.factory.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Opens up and edits the basic details of the DR Group
 */

var failoverMod = drAppFailoverModule;

failoverMod.controller('basicDetailsController', [
	'$uibModalInstance',
	'cvLoc',
	'cvUtil',
	'drCRUDFactory',
	'drOrchestrationFactory',
	'vApp',
	'VM_POLICY_APP_TYPE',
	function($uibModalInstance, cvLoc, cvUtil, drCRUDFactory, drOrchestrationFactory, vApp, VM_POLICY_APP_TYPE) {
		var self = this;

		// functions
		this.save = save;
		this.closeModal = closeModal;

		// variables
		self.localLangPolicy = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectLabPolicy'));
		self.policyAppType = VM_POLICY_APP_TYPE.REPLICATION;

		if (vApp) {
			self.vApp = vApp;
			self.vAppName = self.vApp.vAppEntity.vAppName;
			self.approvalRequired = self.vApp.approvalRequired;
			self.lifeCycleValidation = cvUtil.emptyMsg();
			if (self.vApp.config && self.vApp.config.vmGroups && self.vApp.config.vmGroups.length > 0) {
				self.continueOnFailure = self.vApp.config.vmGroups[0].continueOnFailure;
				self.delay = self.vApp.config.vmGroups[0].delay;
			} else {
				self.continueOnFailure = false;
				self.delay = 0;
			}
			if (self.vApp.machinesList && self.vApp.machinesList.length > 0) {
				self.destVendor = self.vApp.machinesList[0].destVendor;
			}
			if (self.vApp.policy) {
				if (self.vApp.policy.entity) {
					self.targetIdToTick = self.vApp.policy.entity.vmAllocPolicyId;
				}
			}
		} else {
			self.vApp = {};
			self.vApp.vAppEntity = {};
		}

		drOrchestrationFactory.getUsers().then(function(data) {
			self.users = drOrchestrationFactory.users;
			if (angular.isDefined(self.vApp.usersForApproval) && angular.isDefined(self.users)) {
				self.vApp.usersForApproval.forEach(function(userForApproval) {
					self.users.forEach(function(user) {
						if (userForApproval.userEntity.userId == user.userEntity.userId) {
							user.selected = true;
						}
					});
				});
			}
		});

		drOrchestrationFactory.getLifeCyclePolicies().then(function() {
			self.lifeCyclePolicies = drOrchestrationFactory.lifeCyclePolicies;
			var policyToSelect = self.lifeCyclePolicies.find(function(policies) {
				return policies.entity && policies.entity.vmAllocPolicyId === self.targetIdToTick;
			});
			if (policyToSelect) {
				policyToSelect.selected = true;
			}
		});

		function closeModal() {
			$uibModalInstance.dismiss();
		}

		function save() {
			var validationPassed = true;
			if (!self.vAppName) {
				self.nameValidation = {
					message: cvLoc('msg.groupNameRequired'),
					type: 'error'
				};
				validationPassed = false;
			} else {
				self.nameValidation = cvUtil.emptyMsg();
			}

			if (self.approvalRequired && !self.usersSelected.length) {
				self.approvalValidation = {
					message: cvLoc('msg.selectUserForApproval'),
					type: 'error'
				};
				validationPassed = false;
			} else {
				self.approvalValidation = cvUtil.emptyMsg();
			}

			if (!validationPassed) {
				return;
			}

			self.vApp.vAppEntity.vAppName = self.vAppName;
			self.vApp.approvalRequired = self.approvalRequired;
			self.vApp.config.vmGroups.forEach(function(vmGroup) {
				vmGroup.delay = self.delay;
				vmGroup.continueOnFailure = self.continueOnFailure;
			});
			self.vApp.usersForApproval = [];
			self.usersSelected &&
				self.usersSelected.forEach(function(user) {
					self.vApp.usersForApproval.push(user);
				});
			if (self.selectedTarget && self.selectedTarget.length > 0) {
				var target = self.selectedTarget[0];
				self.vApp.policy = target;
				if (drOrchestrationFactory.isVirtualLabTarget(target)) {
					self.vApp.isVirtualLab = true;
					self.vApp.config.vmPolicy = target.entity;
				}
			} else {
				//we were showing test failover target during edit previusly (before sp21)  we need to set empty during edit if its notset.
				self.vApp.policy = undefined;
				self.vApp.isVirtualLab = false;
				self.vApp.config.vmPolicy = undefined;
			}
			if (self.vApp.isDevtestGroup) {
				if (!self.vApp.policy) {
					self.vApp.policy = {};
				}
			}
			closeModal();

			drCRUDFactory.updateFailoverGroup(self.vApp).then(function() {
				self.vApp = drCRUDFactory.failoverGroupDetails;
			});
		}
	}
]);

export default failoverMod;
