import 'modules/disasterRecovery/js/dr.constants.js';
import 'modules/disasterRecovery/js/factory/dr.factory.js';
import 'modules/disasterRecovery/js/factory/drAutoFailover.factory.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * The controller handles adding Autofailover machines to the DR Group
 */

var failoverMod = drAppFailoverModule;

failoverMod.controller('autofailoverController', [
	'$uibModalInstance',
	'cvLoc',
	'cvUtil',
	'drCRUDFactory',
	'drOrchestrationFactory',
	'drAutoFailoverFactory',
	'FailoverConstants',
	'vApp',
	function(
		$uibModalInstance,
		cvLoc,
		cvUtil,
		drCRUDFactory,
		drOrchestrationFactory,
		drAutoFailoverFactory,
		FailoverConstants,
		vApp
	) {
		var self = this;

		// functions
		self.closeModal = closeModal;
		self.save = save;

		// variables
		self.autoFailoverMachines = [];
		self.localLangMonitoringMachines = {};
		if (vApp) {
			self.vApp = vApp;
			self.vAppName = self.vApp.vAppEntity.vAppName;
		} else {
			self.vApp = {};
			self.vApp.vAppEntity = {};
		}

		// validation messages
		self.autofailoverMachineValidation = cvUtil.emptyMsg();
		self.localLangMonitoringMachines = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectMonitoringMachine'));

		drOrchestrationFactory.getProxyServers(FailoverConstants.Vendors['VMW']).then(function() {
			var header = {
				name: '<strong>' + cvLoc('label.source') + '</strong>',
				header: true
			};

			var end = {
				header: false
			};
			self.autoFailoverMachines = self.autoFailoverMachines.concat(header);
			self.autoFailoverMachines = self.autoFailoverMachines.concat(drOrchestrationFactory.proxyServers);
			self.autoFailoverMachines = self.autoFailoverMachines.concat(end);
		});

		function closeModal() {
			$uibModalInstance.dismiss();
		}

		function save() {
			var validationPassed = true;
			if (self.autoFailoverSelectedMachines.length != 3) {
				self.autofailoverMachineValidation = {
					message: cvLoc('msg.minimumMachinesAutofailover'),
					type: 'error'
				};
				return false;
			} else {
				self.autofailoverMachineValidation = cvUtil.emptyMsg();
			}

			if (!validationPassed) {
				return;
			}

			if (self.autoFailoverSelectedMachines.length > 0) {
				drAutoFailoverFactory.handleAutofailoverOptions(
					self.vApp,
					self.autoFailoverSelectedMachines,
					self.autoFailoverDelay
				);
			}
			closeModal();
			drCRUDFactory.updateFailoverGroup(self.vApp).then(function() {
				self.vApp = drCRUDFactory.failoverGroupDetails;
			});
		}
	}
]);

export default failoverMod;
