import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/disasterRecovery/js/factory/drScript.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * The controller adds machines to existing groups
 */

var failoverMod = drAppFailoverModule;

failoverMod.controller('addMachinesController', [
	'$state',
	'$uibModalInstance',
	'cvTableOptions',
	'cvPageActionsFactory',
	'cvLoc',
	'cvUtil',
	'drCRUDFactory',
	'drScriptFactory',
	'vApp',
	'groupMachines',
	'drEligibleMachines',
	function(
		$state,
		$uibModalInstance,
		cvTableOptions,
		cvPageActionsFactory,
		cvLoc,
		cvUtil,
		drCRUDFactory,
		drScriptFactory,
		vApp,
		groupMachines,
		drEligibleMachines
	) {
		var self = this;

		/*
		 * groupMachines = the machines already available in the group drEligibleMachines = the list of all the
		 * machines that are eligible to be added to the group machinesList = drEligibleMachines - groupMachines
		 */

		// functions
		self.closeModal = closeModal;
		self.save = save;

		// variables
		self.vApp = vApp;
		self.machinesList = [];
		self.groupMachines = groupMachines;
		self.drEligibleMachines = drEligibleMachines;
		self.addPreScript = drScriptFactory.openPreScriptDialog;
		self.addPostScript = drScriptFactory.openPostScriptDialog;

		// private variables
		var destinationClient = '';
		if (groupMachines.length > 0) {
			destinationClient = groupMachines[0].destinationClient;
		}
		var showPreScript = false;
		var showPostScript = false;

		// TODO Implement a better search algo
		self.drEligibleMachines.forEach(function(failoverEligibleMachine) {
			// Add the machines if the destination client matches with the already exisiting machines' destination client.
			if (failoverEligibleMachine.destinationClient.clientId === destinationClient.clientId) {
				var contains = false;
				self.groupMachines.forEach(function(groupMachine) {
					if (groupMachine.client.clientId == failoverEligibleMachine.client.clientId) {
						contains = true;
					}
				});

				if (!contains) {
					failoverEligibleMachine.groupId = 1;
					self.machinesList.push(failoverEligibleMachine);
				}
				drScriptFactory.isPreScriptSupported(failoverEligibleMachine.vendor, failoverEligibleMachine.destVendor)
					? (showPreScript = true)
					: '';
				drScriptFactory.isPostScriptSupported(failoverEligibleMachine.vendor, failoverEligibleMachine.destVendor)
					? (showPostScript = true)
					: '';
			}
		});

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'machinesList',
			enableGridMenu: false,
			paginationPageSizes: [5, 10, 15],
			paginationPageSize: 5,
			columnDefs: [
				{
					field: 'client.clientName',
					sort: {
						direction: 'asc'
					},
					displayName: cvLoc('label.name'),
					cellTemplate: '<span class="crop">{{row.entity.client.clientName}}</span>',
					width: '30%'
				},
				{
					field: 'priority',
					displayName: cvLoc('label.priority'),
					cellClass: 'priorityInputParent',
					cellTemplate:
						'<input type="number" class="priorityInputModal" ng-model=row.entity.groupId ng-min="1" ng-required>',
					width: '15%'
				},
				{
					field: 'destClient.clientName',
					displayName: cvLoc('label.destinationName'),
					cellTemplate: '<span class="crop">{{row.entity.destClient.clientName}}</span>',
					width: '30%'
				},
				{
					field: 'actions',
					displayName: cvLoc('label.actions'),
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" data-ng-click="grid.appScope.addPreScript(row.entity, grid.appScope.vApp)">' +
						cvLoc('label.addPreScript') +
						'</a></li><li><a href data-ng-click="grid.appScope.addPostScript(row.entity, grid.appScope.vApp)">' +
						cvLoc('label.addPostScript') +
						'</a></li></ul></div>'
				}
			],
			onRegisterApi: function(gridApi) {
				self.getSelectedRows = function() {
					return gridApi.selection.getSelectedRows();
				};

				self.selectAllRows = gridApi.selection.selectAllRows;
			}
		});

		self.gridOptions = {
			cvTableName: 'machineTable',
			cvSearchFields: ['client.clientName', 'destClient.clientName', 'target'],
			cvGridDirectives: {
				uiGridSelection: true
			},
			cvGridCssClass: {
				'users-grid': true
			},
			cvOnGridEmpty: {
				message: cvLoc('msg.allFailoverEligibleMachinesSelected')
			},
			cvAppScope: self,
			gridOptions: globalGridOptions
		};

		showPreScript || showPostScript ? showActionsColumn() : hideActionsColumn();

		function closeModal() {
			$uibModalInstance.dismiss();
		}

		function validateMachineSelection() {
			var selectedMachines = self.getSelectedRows();
			if (!selectedMachines || selectedMachines.length == 0) {
				return false;
			} else {
				return true;
			}
		}

		function validatePrioritySelection() {
			return !self.getSelectedRows().filter(row => !row.groupId || row.groupId < 1).length > 0;
		}

		function save() {
			var validationPassed = true;

			if (!validateMachineSelection()) {
				self.machineValidation = {
					message: cvLoc('msg.minimumMachines'),
					type: 'error'
				};
				validationPassed = false;
			} else if (!validatePrioritySelection()) {
				self.machineValidation = {
					message: cvLoc('msg.validPriorityForAllMachines'),
					type: 'error'
				};
				validationPassed = false;
			} else {
				self.machineValidation = cvUtil.emptyMsg();
			}

			if (!validationPassed) {
				return;
			}

			self.closeModal();

			self.getSelectedRows().forEach(function(selectedMachine) {
				if (!self.vApp.clientList) {
					self.vApp.clientList = [];
				}

				var machine = {};
				machine.GUID = selectedMachine.client.GUID;
				machine.backupsetId = selectedMachine.backupSet.backupsetId;
				machine.backupsetName = selectedMachine.backupSet.backupsetName;
				machine.clientId = selectedMachine.client.clientId;
				machine.clientName = selectedMachine.client.clientName;
				machine.entityId = selectedMachine.replicationId;
				self.vApp.clientList.push(machine);

				var vmSequence = {};
				vmSequence.copyPrecedence = selectedMachine.copyPrecedence;
				vmSequence.replicationId = selectedMachine.replicationId;
				var vmInfo = {};
				vmInfo.vmGUID = selectedMachine.client.GUID;
				vmInfo.vmName = selectedMachine.client.clientName;
				vmSequence.vmInfo = vmInfo;
				vmSequence.postScript = selectedMachine.postScript;
				vmSequence.delay = 1;

				var vmGroups = self.vApp.config.vmGroups;
				var vmGroup;
				var added = false;
				if (vmGroups) {
					vmGroups.forEach(function(group) {
						if (group.groupId == selectedMachine.groupId) {
							if (!group.vmSequence) {
								group.vmSequence = [];
							}
							group.vmSequence.push(vmSequence);
							added = true;
						}
					});
				} else {
					vmGroups = [];
				}
				if (!added) {
					vmGroup = {};
					vmGroup.vmSequence = [];
					vmGroup.delay = self.delay;
					vmGroup.continueOnFailure = self.continueOnFailure;
					vmGroup.groupId = selectedMachine.groupId;
					vmGroup.vmSequence.push(vmSequence);
					self.vApp.config.vmGroups.push(vmGroup);
				}
			});

			drCRUDFactory.updateFailoverGroup(self.vApp).then(function() {
				$state.reload();
			});
		}

		function hideActionsColumn() {
			getActionsColumn().visible = false;
		}

		function showActionsColumn() {
			getActionsColumn().visible = true;
		}

		function getActionsColumn() {
			if (self.gridOptions.gridOptions.columnDefs && self.gridOptions.gridOptions.columnDefs[3]) {
				if (self.gridOptions.gridOptions.columnDefs[3].field === 'actions') {
					return self.gridOptions.gridOptions.columnDefs[3];
				} else {
					var index = -1;
					for (var i = 0; i < self.gridOptions.gridOptions.columnDefs.length; i++) {
						if (self.gridOptions.gridOptions.columnDefs[i].field === 'actions') {
							index = i;
						}
					}
					return self.gridOptions.gridOptions.columnDefs[index];
				}
			}
		}
	}
]);

export default failoverMod;
