export const getDevtestColumns = function(cvLoc) {
	const columnList = [getSourceMachineColumn(cvLoc), getDatastoreColumn(cvLoc)];
	columnList[0].clientName.width = '40%';
	columnList[1].datastoreLabel.width = '40%';
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getFailoverColumns = function(cvLoc) {
	const columnList = [
		getSourceMachineColumn(cvLoc),
		getDatastoreColumn(cvLoc),
		getPriorityColumn(cvLoc),
		getIPColumn(cvLoc)
	];
	columnList[0].clientName.width = '30%';
	columnList[1].datastoreLabel.width = '35%';
	columnList[2].priority.width = '10%';
	columnList[3].ipColumn.width = '25%';
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getFailoverDetailsColumns = function(cvLoc) {
	const columnList = [
		getSourceMachineFailoverDetailsColumn(cvLoc),
		getDatastoreColumn(cvLoc),
		getPriorityColumn(cvLoc),
		getIPColumn(cvLoc),
		getHostNameColumn(cvLoc),
		getFailoverStatusColumn(cvLoc),
		getFailureReasonColumn(cvLoc)
	];
	columnList[0].sourceName.width = '20%';
	columnList[1].datastoreLabel.width = '25%';
	columnList[2].priority.width = '10%';
	columnList[3].ipColumn.width = '10%';
	columnList[4].hostname.width = '10%';
	columnList[5].failoverStatusText.width = '25%';
	columnList[6].lastReplicationJobFailureReason.width = '10%';
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getTestFailoverDetailsColumns = function(cvLoc) {
	const columnList = [
		getSourceMachineFailoverDetailsColumn(cvLoc),
		getDatastoreColumn(cvLoc),
		getPriorityColumn(cvLoc),
		getIPColumn(cvLoc),
		getHostNameColumn(cvLoc),
		getTestFailoverStatusColumn(cvLoc),
		getFailureReasonColumn(cvLoc)
	];
	columnList[0].sourceName.width = '20%';
	columnList[1].datastoreLabel.width = '25%';
	columnList[2].priority.width = '10%';
	columnList[3].ipColumn.width = '10%';
	columnList[4].hostname.width = '10%';
	columnList[5].testFailoverStatusText.width = '15%';
	columnList[6].lastReplicationJobFailureReason.width = '10%';
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getSelectMachinesColumns = function(cvLoc) {
	const columnList = [getSourceMachineColumn(cvLoc), getDatastoreColumn(cvLoc)];
	columnList[0].clientName.width = '40%';
	columnList[1].datastoreLabel.width = '40%';
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getSourceMachineColumn = function(cvLoc) {
	return {
		clientName: {
			title: cvLoc('label.machineName'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="">#:clientName#</span>`
		}
	};
};

export const getSourceMachineFailoverDetailsColumn = function(cvLoc) {
	return {
		sourceName: {
			title: cvLoc('label.machineName'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:sourceName#">#:sourceName#</span>`
		}
	};
};

export const getDatastoreColumn = function(cvLoc) {
	return {
		datastoreLabel: {
			title: cvLoc('label.datastore'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:datastoreLabel#">#:datastoreLabel#</span>`
		}
	};
};

export const getDatastoreColumnFailover = function(cvLoc) {
	return {
		strDatastorename: {
			title: cvLoc('label.datastore'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:datastore.strDatastorename#">#:datastore.strDatastorename#</span>`,
			width: '90%'
		}
	};
};

export const getFailoverStatusColumn = function(cvLoc) {
	return {
		failoverStatusText: {
			title: cvLoc('label.failoverStatus'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:failoverStatusText#">#:failoverStatusText#</span>`
		}
	};
};

export const getTestFailoverStatusColumn = function(cvLoc) {
	return {
		testFailoverStatusText: {
			title: cvLoc('label.testFailoverStatus'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:testFailoverStatusText#">#:testFailoverStatusText#</span>`
		}
	};
};

export const getPriorityColumn = function(cvLoc) {
	return {
		priority: {
			title: cvLoc('label.priority'),
			type: 'number',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:priority#">#:priority#</span>`
		}
	};
};

export const getIPColumn = function(cvLoc) {
	return {
		ipColumn: {
			title: cvLoc('label.ipSettings'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:ipText#">#:ipText#</span>`
		}
	};
};

export const getHostNameColumn = function(cvLoc) {
	return {
		hostname: {
			title: cvLoc('label.destHostname'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:destComputerName#">#:destComputerName#</span>`
		}
	};
};

export const getFailureReasonColumn = function(cvLoc) {
	return {
		lastReplicationJobFailureReason: {
			title: cvLoc('label.failureReason'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:lastReplicationJobFailureReason#">#:lastReplicationJobFailureReason#</span>`
		}
	};
};
