import { acAppcredentialManagerModule } from 'common/js/modules';

acAppcredentialManagerModule.service('credentialManagerService', [
	'$http',
	'CREDENTIAL_TYPE',
	'cvLoc',
	'CREDENTIAL_PROPERTY_LEVEL',
	'CLOUD_VENDOR_TYPE',
	'MANAGEMENT_ENDPOINT',
	'AUTHENTICATION_ENDPOINT',
	'KEY_VAULT_ENDPOINT',
	'STORAGE_ENDPOINT',
	'AMAZON_AUTH_TYPE',
	'AZURE_AUTH_TYPE',
	function(
		$http,
		CREDENTIAL_TYPE,
		cvLoc,
		CREDENTIAL_PROPERTY_LEVEL,
		CLOUD_VENDOR_TYPE,
		MANAGEMENT_ENDPOINT,
		AUTHENTICATION_ENDPOINT,
		KEY_VAULT_ENDPOINT,
		STORAGE_ENDPOINT,
		AMAZON_AUTH_TYPE,
		AZURE_AUTH_TYPE
	) {
		this.getCredentialType = function() {
			return $http.get('getCredentialType.do');
		};

		this.getCredentialRecord = function(
			propertyLevel = CREDENTIAL_PROPERTY_LEVEL.MINIMAL_WITH_DESC,
			recordType = 0,
			credentialName = ''
		) {
			return $http.get(
				'credentialManager.do?propertyLevel=' +
					propertyLevel +
					'&recordType=' +
					recordType +
					'&credentialName=' +
					credentialName
			);
		};

		this.addCredentialRecord = function(credentialReq) {
			return $http.post('addCredentialManager.do', { createCredentialReq: angular.toJson(credentialReq) });
		};

		this.editCredentialRecord = function(credentialRecordInfo) {
			return $http({
				method: 'PUT',
				url: 'editCredentialManager.do',
				params: { credentialRecordInfo: angular.toJson(credentialRecordInfo) },
				data: { password: angular.toJson(credentialRecordInfo.record.password) }
			});
		};

		this.deleteCredentialRecord = function(credentialRecordInfo) {
			return $http({ method: 'DELETE', url: 'deleteCredentialManager.do', params: credentialRecordInfo });
		};

		this.getStorageEndpoint = function(data) {
			var endpoint = '';
			switch (data.id) {
				case '1':
					endpoint = STORAGE_ENDPOINT[data.id];
					break;
				case '2':
					endpoint = STORAGE_ENDPOINT[data.id];
					break;
				case '3':
					endpoint = STORAGE_ENDPOINT[data.id];
					break;
				default:
					endpoint = STORAGE_ENDPOINT['0'];
					break;
			}

			return endpoint;
		};

		this.getManagementEndpoint = function(data) {
			var endpoint = '';
			switch (data.id) {
				case '1':
					endpoint = MANAGEMENT_ENDPOINT[data.id];
					break;
				case '2':
					endpoint = MANAGEMENT_ENDPOINT[data.id];
					break;
				case '3':
					endpoint = MANAGEMENT_ENDPOINT[data.id];
					break;
				default:
					endpoint = MANAGEMENT_ENDPOINT['0'];
					break;
			}

			return endpoint;
		};

		this.getAuthenticationEndpoint = function(data) {
			var endpoint = '';
			switch (data.id) {
				case '1':
					endpoint = AUTHENTICATION_ENDPOINT[data.id];
					break;
				case '2':
					endpoint = AUTHENTICATION_ENDPOINT[data.id];
					break;
				case '3':
					endpoint = AUTHENTICATION_ENDPOINT[data.id];
					break;
				default:
					endpoint = AUTHENTICATION_ENDPOINT['0'];
					break;
			}

			return endpoint;
		};

		this.getKeyVaultEndpoint = function(data) {
			var endpoint = '';
			switch (data.id) {
				case '1':
					endpoint = KEY_VAULT_ENDPOINT[data.id];
					break;
				case '2':
					endpoint = KEY_VAULT_ENDPOINT[data.id];
					break;
				case '3':
					endpoint = KEY_VAULT_ENDPOINT[data.id];
					break;
				default:
					endpoint = KEY_VAULT_ENDPOINT['0'];
					break;
			}

			return endpoint;
		};

		this.getRecTypeLabels = function(recordType) {
			var recTypeLabels = {};
			switch (recordType) {
				case 'S3_COMPATIBLE':
				case 'ALICLOUD_OSS':
				case 'AMAZON_S3':
				case 'CMCC_ONEST':
				case 'GOOGLE_CLOUD':
				case 'HUAWEI_OSS':
				case 'CEPH_OBJECT_GATEWAY_S3':
				case 'CLOUDIAN_HYPERSTORE':
				case 'DELL_EMC_ECS_S3':
				case 'FUJITSU_STORAGE_ETERNUS':
				case 'HITACHI_VANTARA_HCP_S3':
				case 'NETAPP_STORAGEGRID':
				case 'REVERA_VAULT':
				case 'SCALITY_RING':
				case 'WASABI_HOT_CLOUD_STORAGE':
				case 'NUTANIX_BUCKETS':
				case 'AMAZON_GLACIER':
				case 'KINGSOFT_KS3':
				case 'IRON_MOUNTAIN_CLOUD':
				case 'INSPUR_CLOUD':
				case 'VERIZON_CLOUD':
				case 'AMPLIDATA':
				case 'TELEFONICA_OPEN_CLOUD_OBJECT_STORAGE':
				case 'IBM_CLOUD_S3':
					recTypeLabels.userNameLabel = 'label.accessKey';
					recTypeLabels.passwordLabel = 'label.secretAccessKey';
					recTypeLabels.errorUserNameLabel = 'error.accessKey';
					recTypeLabels.errorPasswordLabel = 'error.secretAccessKey';
					break;
				case 'EMC_ATMOS':
				case 'ATT_SYNAPTIC':
					recTypeLabels.userNameLabel = 'label.tokenId';
					recTypeLabels.passwordLabel = 'label.sharedSecret';
					recTypeLabels.errorUserNameLabel = 'error.tokenId';
					recTypeLabels.errorPasswordLabel = 'error.sharedSecret';
					break;
				case 'IBM_CLOUD':
				case 'OPENSTACK':
				case 'RACKSPACE_CLOUD_FILES':
					recTypeLabels.userNameLabel = 'label.userName';
					recTypeLabels.passwordLabel = 'label.apiKey';
					recTypeLabels.errorUserNameLabel = 'error.userName';
					recTypeLabels.errorPasswordLabel = 'error.apiKey';
					break;
				case 'MICROSOFT_AZURE':
					recTypeLabels.userNameLabel = 'label.accountName';
					recTypeLabels.passwordLabel = 'label.accessKey';
					recTypeLabels.errorUserNameLabel = 'error.accountName';
					recTypeLabels.errorPasswordLabel = 'error.accessKey';
					break;
				case 'LINUXACCOUNT':
					recTypeLabels.userNameLabel = 'label.userName';
					recTypeLabels.passwordLabel = 'label.passphrase';
					recTypeLabels.errorUserNameLabel = 'error.userName';
					recTypeLabels.errorPasswordLabel = 'error.password';
					break;
				case 'SALESFORCE_CONNECTED_APP':
					recTypeLabels.userNameLabel = 'label.consumerKey';
					recTypeLabels.passwordLabel = 'label.consumerSecret';
					recTypeLabels.errorUserNameLabel = 'error.consumerKey';
					recTypeLabels.errorPasswordLabel = 'error.consumerSecret';
					break;
				default:
					recTypeLabels.userNameLabel = 'label.userName';
					recTypeLabels.passwordLabel = 'label.password';
					recTypeLabels.errorUserNameLabel = 'error.userName';
					recTypeLabels.errorPasswordLabel = 'error.password';
					break;
			}

			return recTypeLabels;
		};

		// Utility function used to set the correct credential type.
		// The 'CLOUD_ACCOUNT' type is a dummy type, used to show the
		// cloud vendors in a separate drop down. So when saving a cloud credential
		// we need to get the correct credential type from the vendor type.
		// It is used during create a new credential (credentialManager.factory.js)
		// and during edit an existing credential (credentialManager.ctrl.js)
		// New line
		this.setCredentialRecType = function(credentialReq, vendorSelection) {
			// If cloud account was selected, redirect to the correct vendor type
			if (credentialReq.recordType[0].value === 'CLOUD_ACCOUNT') {
				if (vendorSelection.vendorType[0].value === 'AMAZON') {
					credentialReq.recordType = AMAZON_AUTH_TYPE[vendorSelection.authType[0].value];
				} else if (vendorSelection.vendorType[0].value === 'MICROSOFT_AZURE_TYPE') {
					credentialReq.recordType = AZURE_AUTH_TYPE[vendorSelection.authType[0].value];
				} else {
					credentialReq.recordType = CLOUD_VENDOR_TYPE[vendorSelection.vendorType[0].value];
				}
			} else {
				credentialReq.recordType = CREDENTIAL_TYPE[credentialReq.recordType[0].value];
			}
		};

		this.getCredentialTypePlaceholder = function() {
			var credAcctTypeTranslation = {
				nothingSelected: cvLoc('placeholder.selectCredType')
			};

			return credAcctTypeTranslation;
		};

		this.getCloudVendorTypePlaceholder = function() {
			var cloudVendorTypeTranslation = {
				nothingSelected: cvLoc('placeholder.selectCloudVendorType'),
				search: cvLoc('placeholder.cloudVendorSeartch')
			};

			return cloudVendorTypeTranslation;
		};

		this.getCredentialsMultiRecTypes = function(recTypes) {
			var recObj = {
				recordTypes: JSON.stringify(recTypes)
			};
			return $http.post('getCredentialsMultiRecTypes.do', recObj);
		};
	}
]);

export default acAppcredentialManagerModule;
