import 'modules/credentialManager/js/services/credentialManager.svc.js';
import 'modules/credentialManager/js/controllers/credentialManager.ctrl.js';

import { acAppcredentialManagerModule } from 'common/js/modules';

var credMod = acAppcredentialManagerModule;
var factories = {};

factories.credentialManagerFactory = [
	'$uibModal',
	'CREDENTIAL_TYPE',
	'CLOUD_VENDOR_TYPE',
	'cvUtil',
	'securityService',
	'credentialManagerService',
	'CREATE_CREDENTIAL_DEFAULT',
	'$q',
	'PERMISSION_TYPE',
	'CREDENTIAL_TYPE_BASE',
	'CREDENTIAL_PROPERTY_LEVEL',
	'CREDENTIAL_TYPE_ENVIRONMENT',
	'AMAZON_AUTH_TYPE',
	'AZURE_AUTH_TYPE',
	function(
		$modal,
		CREDENTIAL_TYPE,
		CLOUD_VENDOR_TYPE,
		cvUtil,
		securityService,
		credentialManagerService,
		CREATE_CREDENTIAL_DEFAULT,
		$q,
		PERMISSION_TYPE,
		CREDENTIAL_TYPE_BASE,
		CREDENTIAL_PROPERTY_LEVEL,
		CREDENTIAL_TYPE_ENVIRONMENT,
		AMAZON_AUTH_TYPE,
		AZURE_AUTH_TYPE
	) {
		var credentialManagerFactory = {};
		const azureADAccount = 4;

		credentialManagerFactory.openCreateNewUser = function(params) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/credentialManager/partials/addEditCredentialManager.jsp',
				backdrop: 'static',
				controller: 'credentialManagerCreateController as credMgrCreateCtrl',
				resolve: {
					cancelReloadApp: function() {
						return params.cancelReloadApp;
					},
					AccountTypeId: function() {
						return params.AccountTypeId;
					},
					showInputs: function() {
						return params.showInputs;
					},
					accountTypes: function() {
						return params.accountTypes;
					}
				}
			});
		};

		credentialManagerFactory.openEditCredential = function(params) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/credentialManager/partials/addEditCredentialManager.jsp',
				backdrop: 'static',
				controller: 'credentialManagerEditController as credMgrEditCtrl',
				resolve: {
					cancelReloadApp: function() {
						return params.cancelReloadApp;
					},
					credentialEntity: function() {
						return params.credentialEntity;
					},
					fromCredListPage: function() {
						if (params.fromCredListPage === 'undefined' || params.fromCredListPage === null) {
							params.fromCredListPage = false;
						}
						return params.fromCredListPage;
					}
				}
			});
		};

		credentialManagerFactory.initCredentialReq = function() {
			let credentialReq = {
				credentialRecord: {
					recordType: [{ value: 'AMAZON_S3' }]
				},
				additionalInformation: {
					connectString: CREATE_CREDENTIAL_DEFAULT.connectString,
					dbName: CREATE_CREDENTIAL_DEFAULT.dbName,
					azureCredInfo: {
						authType: CREATE_CREDENTIAL_DEFAULT.sharedSecret,
						applicationId: CREATE_CREDENTIAL_DEFAULT.applicationId,
						environment: CREATE_CREDENTIAL_DEFAULT.environment,
						subscriptionId: CREATE_CREDENTIAL_DEFAULT.subscriptionId,
						tenantId: CREATE_CREDENTIAL_DEFAULT.tenantId,
						endpoints: {
							activeDirectoryEndpoint: CREATE_CREDENTIAL_DEFAULT.activeDirectoryEndpoint,
							storageEndpoint: CREATE_CREDENTIAL_DEFAULT.storageEndpoint,
							resourceManagerEndpoint: CREATE_CREDENTIAL_DEFAULT.resourceManagerEndpoint
						}
					},
					cloudCredentialInfo: {
						amazonStorageCredInfo: {
							roleARN: CREATE_CREDENTIAL_DEFAULT.roleARN
						}
					}
				},
				record: {},
				createAs: {
					userGroup: {},
					user: {
						user: {}
					}
				},
				securityAssociations: {
					associations: [],
					associationsOperationType: '1'
				}
			};
			return credentialReq;
		};

		credentialManagerFactory.getCredentialTypes = function() {
			let credTypes = [];
			angular.forEach(CREDENTIAL_TYPE, function(value, key) {
				if (
					value != CREDENTIAL_TYPE['VMWAREACCOUNT'] &&
					value != CREDENTIAL_TYPE['HYPERVACCOUNT'] &&
					value != CREDENTIAL_TYPE['AZUREACCOUNT']
				) {
					credTypes.push(key);
				}
			});
			return credTypes;
		};

		credentialManagerFactory.getCloudVendorTypes = function() {
			let cloudVendorTypes = [];
			angular.forEach(CLOUD_VENDOR_TYPE, function(value, key) {
				cloudVendorTypes.push(key);
			});
			return cloudVendorTypes;
		};

		credentialManagerFactory.getAmazonAuthTypes = function() {
			let amazonAuthTypes = [];
			angular.forEach(AMAZON_AUTH_TYPE, function(value, key) {
				amazonAuthTypes.push(key);
			});
			return amazonAuthTypes;
		};

		credentialManagerFactory.getAzureAuthTypes = function() {
			let azureAuthTypes = [];
			angular.forEach(AZURE_AUTH_TYPE, function(value, key) {
				azureAuthTypes.push(key);
			});
			return azureAuthTypes;
		};
		credentialManagerFactory.populateEnvironment = function() {
			let environment = [];
			angular.forEach(CREDENTIAL_TYPE_ENVIRONMENT, function(value, key) {
				environment.push({
					id: key,
					name: value
				});
			});
			return environment;
		};

		credentialManagerFactory.getEnvironment = function(type) {
			let environment = [];
			angular.forEach(CREDENTIAL_TYPE_ENVIRONMENT, function(value, key) {
				if (value === type) {
					environment.push({
						id: key,
						name: value
					});
				}
			});
			return environment;
		};

		credentialManagerFactory.populateRecordTypeList = function(
			editMode,
			credentialReq,
			accountTypeId = 0,
			accountTypes = null
		) {
			let defer = $q.defer();
			$q.recordTypeList = [];
			credentialManagerService.getCredentialType().success(
				function(data) {
					/*
					 * This call returns all record types defined in the .x structure We compare it with our
					 * local constants definition and only add the ones for which a constant has been defined.
					 * This will help discard new types for which complete support may not have been added.
					 */
					let credTypes = credentialManagerFactory.getCredentialTypes();
					let i = 0,
						index = 0;

					for (i = 0; i < data.length; i++) {
						if (credTypes.includes(data[i].value)) {
							if (!accountTypes || (accountTypes && accountTypes.includes(data[i].value))) {
								$q.recordTypeList.push(data[i]);
							}
						}
					}

					/*
					 * We need to set the record type for the following cases: 1. Create credential account
					 * invoked from storage pool, 2. Edit credential invocation
					 */

					if (accountTypeId > 0) {
						index = credentialManagerFactory.getIndexByTypeId(
							$q.recordTypeList,
							accountTypeId > CREDENTIAL_TYPE_BASE['CLOUD'] ||
								accountTypeId === CLOUD_VENDOR_TYPE.AMAZON ||
								accountTypeId === AMAZON_AUTH_TYPE.AMAZON_STS_IAM_ROLE ||
								accountTypeId === CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE ||
								accountTypeId === azureADAccount ||
								accountTypeId === CLOUD_VENDOR_TYPE.SALESFORCE_CONNECTED_APP
								? CREDENTIAL_TYPE['CLOUD_ACCOUNT']
								: accountTypeId
						);
						$q.recordTypeList[index].selected = true;
						/*
						 * This is when create was invoked from outside, like storage pool creation
						 */
						if (!editMode) {
							credentialReq.recordType = [$q.recordTypeList[index]];
						}
					}

					defer.resolve($q.recordTypeList);
				},
				function(err) {
					defer.reject(err);
				}
			);

			return defer.promise;
		};

		credentialManagerFactory.populateCloudVendorTypeList = function(
			editMode,
			credentialReq,
			vendorSelection,
			accountTypeId = 0
		) {
			let defer = $q.defer();
			$q.vendorTypeList = [];

			credentialManagerService.getCredentialType().success(
				function(data) {
					/*
					 * This call returns all record types defined in the .x structure We compare it with our
					 * local constants definition and only add cloud vendor types which have constants. This
					 * will help discard new cloud types for which complete support may not have been added.
					 */

					let cloudVendorTypes = credentialManagerFactory.getCloudVendorTypes();
					let index = 0,
						i = 0;

					// Add only cloud vendor types
					for (i = 0; i < data.length; i++) {
						if (cloudVendorTypes.includes(data[i].value)) {
							$q.vendorTypeList.push(data[i]);
						}
					}

					cvUtil.sortAscending($q.vendorTypeList, 'label');

					if (accountTypeId === AMAZON_AUTH_TYPE.AMAZON_S3 || accountTypeId === AMAZON_AUTH_TYPE.AMAZON_STS_IAM_ROLE) {
						accountTypeId = CLOUD_VENDOR_TYPE.AMAZON;
					} else if (
						accountTypeId === AZURE_AUTH_TYPE.AZUREACCOUNT ||
						accountTypeId === AZURE_AUTH_TYPE.MICROSOFT_AZURE
					) {
						accountTypeId = CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE;
					}

					if (accountTypeId > 0) {
						index = credentialManagerFactory.getIndexByTypeId($q.vendorTypeList, accountTypeId);
						if (index >= 0) {
							vendorSelection.vendorType = [$q.vendorTypeList[index]];
							$q.vendorTypeList[index].selected = true;
						}
					}

					defer.resolve($q.vendorTypeList);
				},
				function(err) {
					defer.reject(err);
				}
			);

			return defer.promise;
		};

		credentialManagerFactory.populateAuthTypeList = function(
			editMode,
			credentialReq,
			accountTypeId = 0,
			authTypeId = 0,
			accountTypes = null
		) {
			let defer = $q.defer();
			$q.authTypeList = [];
			credentialManagerService.getCredentialType().success(
				function(data) {
					/*
					 * This call returns all record types defined in the .x structure We compare it with our
					 * local constants definition and only add the ones for which a constant has been defined.
					 * This will help discard new types for which complete support may not have been added.
					 */
					let credTypes = credentialManagerFactory.getAmazonAuthTypes();
					authTypeId = authTypeId === 0 ? AMAZON_AUTH_TYPE.AMAZON_S3 : authTypeId;
					if (accountTypeId === CLOUD_VENDOR_TYPE['MICROSOFT_AZURE_TYPE']) {
						credTypes = credentialManagerFactory.getAzureAuthTypes();
						authTypeId = authTypeId === 0 ? AZURE_AUTH_TYPE.MICROSOFT_AZURE : authTypeId;
					}
					let i = 0,
						index = 0;

					for (i = 0; i < data.length; i++) {
						if (credTypes.includes(data[i].value)) {
							$q.authTypeList.push(data[i]);
						}
					}

					/*
					 * We need to set the record type for the following cases: 1. Create credential account
					 * invoked from storage pool, 2. Edit credential invocation
					 */

					if (accountTypeId > 0) {
						index = credentialManagerFactory.getIndexByTypeId($q.authTypeList, authTypeId);
						$q.authTypeList[index].selected = true;
					}

					defer.resolve($q.authTypeList);
				},
				function(err) {
					defer.reject(err);
				}
			);

			return defer.promise;
		};
		credentialManagerFactory.getIndexByTypeId = function(typeList, typeId) {
			let index = 0;
			if (typeId) {
				if (
					typeId === AMAZON_AUTH_TYPE.AMAZON_IAM_ROLE ||
					typeId === AMAZON_AUTH_TYPE.AMAZON_S3 ||
					typeId === AMAZON_AUTH_TYPE.AMAZON_STS_IAM_ROLE
				) {
					index = typeList.findIndex(type => AMAZON_AUTH_TYPE[type.value] === typeId);
				} else if (typeId === AZURE_AUTH_TYPE.AZUREACCOUNT || typeId === AZURE_AUTH_TYPE.MICROSOFT_AZURE) {
					index = typeList.findIndex(type => AZURE_AUTH_TYPE[type.value] === typeId);
				} else if (
					(typeId >= CLOUD_VENDOR_TYPE.SALESFORCE_CONNECTED_APP && typeId <= CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE) ||
					typeId > CREDENTIAL_TYPE_BASE['CLOUD']
				) {
					index = typeList.findIndex(type => CLOUD_VENDOR_TYPE[type.value] === typeId);
				} else {
					index = typeList.findIndex(type => CREDENTIAL_TYPE[type.value] === typeId);
				}
			} else {
				index = typeList.findIndex(type => CREDENTIAL_TYPE[type.value] === typeId);
			}

			if (index === -1) {
				index = 0;
			}
			return index;
		};

		credentialManagerFactory.addUserAndGroupSelected = function(
			credentialReq,
			userAndUserGroupsList,
			selectedOwner,
			selectedUserOrGroup
		) {
			const _properties = {
				isCreatorAssociation: false,
				permissions: [{ permissionId: PERMISSION_TYPE.USERCREDENTIAL }]
			};
			if (selectedUserOrGroup.loginName !== selectedOwner.loginName) {
				if (selectedUserOrGroup.userInfo.userType === 'USER') {
					//User
					userAndUserGroupsList.push({
						userId: selectedUserOrGroup.userInfo.id,
						userName: selectedUserOrGroup.loginName,
						name: selectedUserOrGroup.name,
						checked: true
					});
					credentialReq.securityAssociations.associations.push({
						userOrGroup: [
							{
								userId: selectedUserOrGroup.userInfo.id,
								userName: selectedUserOrGroup.loginName,
								entityTypeName: 'USER_ENTITY'
							}
						],
						properties: _properties
					});
				} else {
					//User Group
					userAndUserGroupsList.push({
						userGroupId: selectedUserOrGroup.userInfo.id,
						userGroupName: selectedUserOrGroup.loginName,
						name: selectedUserOrGroup.name,
						checked: true
					});
					credentialReq.securityAssociations.associations.push({
						userOrGroup: [
							{
								userGroupId: selectedUserOrGroup.userInfo.id,
								userGroupName: selectedUserOrGroup.loginName,
								entityTypeName: 'USERGROUP_ENTITY'
							}
						],
						properties: _properties
					});
				}
			}
		};

		credentialManagerFactory.updateSelectedUserOrGroupOnDelete = function(
			credentialReq,
			userAndUserGroupsList,
			selectedUserOrGroup
		) {
			_.remove(userAndUserGroupsList, userOrUserGroup => {
				if (
					selectedUserOrGroup.loginName === userOrUserGroup.userName &&
					selectedUserOrGroup.userInfo.id === userOrUserGroup.userId
				) {
					return true;
				} else if (
					selectedUserOrGroup.loginName === userOrUserGroup.userGroupName &&
					selectedUserOrGroup.userInfo.id === userOrUserGroup.userGroupId
				) {
					return true;
				}
			});
			_.remove(credentialReq.securityAssociations.associations, userOrUserGroup => {
				if (
					selectedUserOrGroup.loginName === userOrUserGroup.userOrGroup[0].userName &&
					userOrUserGroup.userOrGroup[0].userId === selectedUserOrGroup.userInfo.id
				) {
					return true;
				} else if (
					selectedUserOrGroup.loginName === userOrUserGroup.userOrGroup[0].userGroupName &&
					userOrUserGroup.userOrGroup[0].userGroupId === selectedUserOrGroup.userInfo.id
				) {
					return true;
				}
			});
		};

		credentialManagerFactory.addOwner = function(credentialReq, data) {
			if (data.userGroupId && data.userGroupName) {
				credentialReq.createAs.userGroup.userGroupName = data.userGroupName;
				credentialReq.createAs.userGroup.userGroupId = data.userGroupId;
				credentialReq.createAs.user.user = {};
			} else if (data.userId && data.userName) {
				credentialReq.createAs.user.user.userName = data.userName;
				credentialReq.createAs.user.user.userId = data.userId;
				credentialReq.createAs.userGroup = {};
			}
		};

		credentialManagerFactory.setupOwner = function(credentialReq, userAndUserGroupsList) {
			// You can login as a user only and not as user group
			let selectedOwner = {
				name: cv.loginName,
				loginName: cv.loggedInUserName,
				userInfo: {
					id: parseInt(cv.loggedInUserId),
					name: cv.loginName,
					userType: 'USER'
				},
				iconClass: 'k-i-user'
			};
			let initial_owner = {
				userId: parseInt(cv.loggedInUserId),
				userName: cv.loggedInUserName,
				name: cv.loginName,
				selected: true
			};
			userAndUserGroupsList.push(initial_owner);
			credentialManagerFactory.addOwner(credentialReq, initial_owner);
			return selectedOwner;
		};

		credentialManagerFactory.addSelectedUserOrGroupOwner = function(
			credentialReq,
			userAndUserGroupsList,
			selectedUserOrGroup
		) {
			// Remove any of the previous users/group which was owner previously
			_.remove(userAndUserGroupsList, userOrUserGroup => {
				if (userOrUserGroup.selected && userOrUserGroup.selected == true) {
					return true;
				}
			});
			if (selectedUserOrGroup.userInfo.userType === 'USER') {
				//User
				var temp_user = {
					userId: selectedUserOrGroup.userInfo.id,
					userName: selectedUserOrGroup.loginName,
					name: selectedUserOrGroup.name,
					selected: true
				};
				userAndUserGroupsList.push(temp_user);
				credentialManagerFactory.addOwner(credentialReq, temp_user);
			} else {
				//User Group
				var temp_userGroup = {
					userGroupId: selectedUserOrGroup.userInfo.id,
					userGroupName: selectedUserOrGroup.loginName,
					name: selectedUserOrGroup.name,
					selected: true
				};
				userAndUserGroupsList.push(temp_userGroup);
				credentialManagerFactory.addOwner(credentialReq, temp_userGroup);
			}
		};

		credentialManagerFactory.populateUserGroups = function(
			editMode,
			selectedAssocGroups = null,
			selectedAssocUsers = null
		) {
			let userAndUserGroupsList = [];
			let selectedUserAndGroup = [];
			let selectedOwner = {};
			let userOwnerList = [];
			let securityList = [];
			if (editMode) {
				/*
				 * For edit case we need to set the security associations and also the owner. Security
				 * associations is multi-select and uses the 'checked' property. Owner is single-select and
				 * uses 'selected' property
				 */
				//UserGroup
				_.forEach(selectedAssocGroups, singleGroup => {
					let owner = singleGroup.userOrGroup[0];
					if (owner.externalGroupName) {
						//externalgroup
						let groupName =
							owner.providerDomainName && owner.providerDomainName.length > 0
								? owner.providerDomainName + '\\' + owner.externalGroupName
								: owner.externalGroupName;

						userAndUserGroupsList.push({
							userGroupId: owner.groupId,
							userGroupName: groupName,
							name: groupName,
							selected: singleGroup.properties.isCreatorAssociation,
							checked: true
						});

						securityList.push({
							userOrGroup: [
								{
									userGroupId: owner.groupId,
									userGroupName: groupName,
									entityTypeName: 'USERGROUP_ENTITY'
								}
							],
							properties: {
								isCreatorAssociation: singleGroup.properties.isCreatorAssociation,
								permissions: [
									{ permissionId: singleGroup.properties.categoryPermission.categoriesPermissionList[0].permissionId }
								]
							}
						});
						if (singleGroup.properties.isCreatorAssociation) {
							selectedOwner = {
								name: groupName,
								loginName: groupName,
								userInfo: {
									id: owner.groupId,
									name: groupName,
									userType: 'USERGROUP_ENTITY'
								},
								iconClass: 'k-i-myspace'
							};
						}
						selectedUserAndGroup.push({
							name: groupName,
							loginName: groupName,
							userInfo: {
								id: owner.groupId,
								name: groupName,
								userType: 'USERGROUP_ENTITY'
							},
							iconClass: 'k-i-myspace'
						});
					} else {
						userAndUserGroupsList.push({
							userGroupId: singleGroup.userOrGroup[0].userGroupId,
							userGroupName: singleGroup.userOrGroup[0].userGroupName,
							name: singleGroup.userOrGroup[0].userGroupName,
							selected: singleGroup.properties.isCreatorAssociation,
							checked: true
						});
						securityList.push({
							userOrGroup: [
								{
									userGroupId: singleGroup.userOrGroup[0].userGroupId,
									userGroupName: singleGroup.userOrGroup[0].userGroupName,
									entityTypeName: 'USERGROUP_ENTITY'
								}
							],
							properties: {
								isCreatorAssociation: singleGroup.properties.isCreatorAssociation,
								permissions: [
									{ permissionId: singleGroup.properties.categoryPermission.categoriesPermissionList[0].permissionId }
								]
							}
						});
						if (singleGroup.properties.isCreatorAssociation) {
							selectedOwner = {
								name: singleGroup.userOrGroup[0].userGroupName,
								loginName: singleGroup.userOrGroup[0].userGroupName,
								userInfo: {
									id: singleGroup.userOrGroup[0].userGroupId,
									name: singleGroup.userOrGroup[0].userGroupName,
									userType: 'USERGROUP_ENTITY'
								},
								iconClass: 'k-i-myspace'
							};
						}
						selectedUserAndGroup.push({
							name: singleGroup.userOrGroup[0].userGroupName,
							loginName: singleGroup.userOrGroup[0].userGroupName,
							userInfo: {
								id: singleGroup.userOrGroup[0].userGroupId,
								name: singleGroup.userOrGroup[0].userGroupName,
								userType: 'USERGROUP_ENTITY'
							},
							iconClass: 'k-i-myspace'
						});
					}
				});
				//User
				_.forEach(selectedAssocUsers, singleUser => {
					userAndUserGroupsList.push({
						userId: singleUser.userOrGroup[0].userId,
						userName: singleUser.userOrGroup[0].userName,
						name: singleUser.userOrGroup[0].userName,
						selected: singleUser.properties.isCreatorAssociation,
						checked: true
					});
					securityList.push({
						userOrGroup: [
							{
								userId: singleUser.userOrGroup[0].userId,
								userName: singleUser.userOrGroup[0].userName,
								entityTypeName: 'USER_ENTITY'
							}
						],
						properties: {
							isCreatorAssociation: singleUser.properties.isCreatorAssociation,
							permissions: [
								{ permissionId: singleUser.properties.categoryPermission.categoriesPermissionList[0].permissionId }
							]
						}
					});
					if (singleUser.properties.isCreatorAssociation == true) {
						selectedOwner = {
							name: singleUser.userOrGroup[0].userName,
							loginName: singleUser.userOrGroup[0].userName,
							userInfo: {
								id: singleUser.userOrGroup[0].userId,
								name: singleUser.userOrGroup[0].userName,
								userType: 'USER'
							},
							iconClass: 'k-i-user'
						};
					}
					selectedUserAndGroup.push({
						name: singleUser.userOrGroup[0].userName,
						loginName: singleUser.userOrGroup[0].userName,
						userInfo: {
							id: singleUser.userOrGroup[0].userId,
							name: singleUser.userOrGroup[0].userName,
							userType: 'USER'
						},
						iconClass: 'k-i-user'
					});
				});
			}

			if (!_.isEmpty(selectedOwner)) {
				//Remove the selected owner from UserAndUserGroupsList and securityList as it gets added when submitting the request
				_.remove(securityList, securityListItem => {
					if (
						selectedOwner.loginName === securityListItem.userOrGroup[0].userName &&
						selectedOwner.userInfo.id === securityListItem.userOrGroup[0].userId
					) {
						return true;
					} else if (
						selectedOwner.loginName === securityListItem.userOrGroup[0].userGroupName &&
						selectedOwner.userInfo.id === securityListItem.userOrGroup[0].userGroupId
					) {
						return true;
					}
				});
				_.remove(userAndUserGroupsList, userOrUserGroup => {
					if (
						selectedOwner.loginName === userOrUserGroup.userName &&
						selectedOwner.userInfo.id === userOrUserGroup.userId
					) {
						return true;
					} else if (
						selectedOwner.loginName === userOrUserGroup.userGroupName &&
						selectedOwner.userInfo.id === userOrUserGroup.userGroupId
					) {
						return true;
					}
				});
			}
			userOwnerList[0] = selectedOwner;
			userOwnerList[1] = selectedUserAndGroup;
			userOwnerList[2] = userAndUserGroupsList;
			userOwnerList[3] = securityList;
			return userOwnerList;
		};

		credentialManagerFactory.getErrorLabels = function(credentialReq, cloudAccount, vendorSelection) {
			if (cloudAccount) {
				return credentialManagerService.getRecTypeLabels(
					vendorSelection.vendorType[0] ? vendorSelection.vendorType[0].value : 0
				);
			} else {
				return credentialManagerService.getRecTypeLabels(
					credentialReq.recordType[0] ? credentialReq.recordType[0].value : 0
				);
			}
		};

		credentialManagerFactory.azureAccountValidate = function(
			credentialReq,
			environment,
			helpText,
			appPassword,
			isEdit = false
		) {
			let validationResult = {
				isValid: true
			};

			//Environment

			if (environment[0] === undefined) {
				validationResult.isValid = false;
				helpText.environment = true;
			}

			// Application Password
			if (!appPassword && !isEdit) {
				validationResult.isValid = false;
				helpText.appPassword = true;
			}
			// TeanatID
			if (!credentialReq.additionalInformation.azureCredInfo.tenantId) {
				validationResult.isValid = false;
				helpText.tenantId = true;
			}
			// Application ID
			if (!credentialReq.additionalInformation.azureCredInfo.applicationId) {
				validationResult.isValid = false;
				helpText.applicationId = true;
			}
			// Management EndPoint
			if (!credentialReq.additionalInformation.azureCredInfo.endpoints.resourceManagerEndpoint) {
				validationResult.isValid = false;
				helpText.managementEndpoint = true;
			}
			// Authentication EndPoint
			if (!credentialReq.additionalInformation.azureCredInfo.endpoints.activeDirectoryEndpoint) {
				validationResult.isValid = false;
				helpText.authenticationEndpoint = true;
			}
			// storage EndPoint
			if (!credentialReq.additionalInformation.azureCredInfo.endpoints.storageEndpoint) {
				validationResult.isValid = false;
				helpText.storageEndpoint = true;
			}

			return validationResult;
		};

		credentialManagerFactory.validate = function(
			credentialReq,
			cloudAccount,
			vendorSelection,
			helpText,
			accordion1,
			password,
			appPassword,
			isEdit = false
		) {
			let validationResult = {
				isValid: true,
				userNameError: '',
				passwordError: ''
			};

			//Account Name
			if (!credentialReq.credentialRecord.credentialName) {
				validationResult.isValid = false;
				helpText.credentialName = true;
			}

			//Record Type
			if (credentialReq.recordType[0] === undefined) {
				validationResult.isValid = false;
				helpText.recordType = true;
			}

			//Cloud VendorType
			if (cloudAccount && vendorSelection.vendorType[0] === undefined) {
				validationResult.isValid = false;
				helpText.vendorType = true;
			}
			var isUserAccountApplicable =
				!cloudAccount ||
				(cloudAccount &&
					!(
						(vendorSelection.vendorType[0].value === 'MICROSOFT_AZURE_TYPE' &&
							vendorSelection.authType[0].value === 'AZUREACCOUNT') ||
						(vendorSelection.vendorType[0].value === 'AMAZON' &&
							(vendorSelection.authType[0].value === 'AMAZON_STS_IAM_ROLE' ||
								vendorSelection.authType[0].value === 'AMAZON_IAM_ROLE'))
					));
			//User Name
			if (isUserAccountApplicable && !credentialReq.record.userName) {
				validationResult.isValid = false;
				helpText.userName = true;
				let errorLabels = credentialManagerFactory.getErrorLabels(credentialReq, cloudAccount, vendorSelection);
				validationResult.userNameError = errorLabels.errorUserNameLabel;
			}

			//Password
			if (isUserAccountApplicable && !password && !isEdit) {
				validationResult.isValid = false;
				helpText.password = true;
				let errorLabels = credentialManagerFactory.getErrorLabels(credentialReq, cloudAccount, vendorSelection);
				validationResult.passwordError = errorLabels.errorPasswordLabel;
			}

			//Role ARN
			if (
				cloudAccount &&
				vendorSelection.vendorType[0].value === 'AMAZON' &&
				vendorSelection.authType[0].value === 'AMAZON_STS_IAM_ROLE' &&
				!credentialReq.record.userName
			) {
				validationResult.isValid = false;
				helpText.roleARN = true;
			}
			//Owner
			if (_.isEmpty(credentialReq.createAs.userGroup) && _.isEmpty(credentialReq.createAs.user.user)) {
				validationResult.isValid = false;
				helpText.createAs = true;
				accordion1.open = true;
			}
			return validationResult;
		};

		return credentialManagerFactory;
	}
];

credMod.factory(factories);

export default credMod;
