import { acAppcredentialManagerModule } from 'common/js/modules';
import 'credentialManager/js/constants/credentialManager.constant.js';
import 'credentialManager/js/factory/credentialManager.factory.js';
import 'credentialManager/js/services/credentialManager.svc.js';
import 'common/js/directives/cv-credentials-directive.js';
import 'common/js/directives/cv-select-with-create.directive.js';
import 'credentialManager/js/constants/credentialManager.constant.js';

var credMod = acAppcredentialManagerModule;
/**
 * This directive is to be used for selecting either credential manager or username/password for credentials
 *
 * @param accountType-account
 *            for which credential manager options have to be retreived vendor--used to calculate account type
 * @param {boolean}
 *            isEdit - Optional parameter.
 * @param {boolean}
 *            isOptional - Optional parameter. If set to true, username, password and confirmPassword fields
 *            will not be validated
 * @param {string}
 *            passwordComplexity - Optional parameter. It can take values as 1, 2 or 3. 1 refers to no
 *            Complexity level none. 2 refers to complexity level medium. 3 refers to complexity level high.
 *            REfer cvCommon constant PASSWORD_COMPLEXITY_LEVEL
 *
 * It will override the complexity level set at the CommCell level. If this parameter is not provided and at
 * commcell level too the setting is not found, complexity level will default to 1.
 *
 *
 *
 */
credMod.directive('cvCredentialManager', () => {
	return {
		restrict: 'E',
		templateUrl: cv.contextPath + '/modules/credentialManager/partials/cv-credential-manager-template.jsp',
		scope: {
			//accountType : '@',
			model: '=', //this is to store user credentials and should have accountType and credType
			inputName: '=', //this is array of user password field names read by credential directive
			formName: '=', //this is form used by credential directive to print errors
			isEdit: '=',
			needConfirm: '=',
			isOptional: '=',
			passwordComplexity: '@',
			isPasswordOptional: '=',
			showCredential: '@', //this property should be sent as false if we want to hide credential,
			labelClass: '=',
			inputClass: '='
		},
		controller: 'credSelectionController'
	};
});

const controllers = {};
controllers.credSelectionController = [
	'$scope',
	'cvLoc',
	'cvUtil',
	'$uibModal',
	'credentialManagerService',
	'credentialManagerFactory',
	'CREDENTIAL_TYPE',
	function($scope, cvLoc, cvUtil, $modal, credentialManagerService, credentialManagerFactory, CREDENTIAL_TYPE) {
		// initialize
		if ($scope.model.selectedCredential === undefined) {
			$scope.model.selectedCredential = [];
		}
		$scope.model.showCredential = $scope.showCredential ? $scope.showCredential == 'true' : true;

		if (!$scope.passwordComplexity) {
			$scope.passwordComplexity = '1';
		}

		$scope.credLang = cvUtil.getIStevenLocLabels();
		$scope.credLang.nothingSelected = cvLoc('placeholder.credential');
		$scope.model.accountType = $scope.model.accountType ? $scope.model.accountType : [CREDENTIAL_TYPE.WINDOWSACCOUNT];
		$scope.model.createAccountType = $scope.model.createAccountType
			? $scope.model.createAccountType
			: CREDENTIAL_TYPE.WINDOWSACCOUNT;
		//There are 2 type of credentials user and credential Manager
		$scope.model.credType = $scope.model.credType ? $scope.model.credType : 'credManager';

		$scope.model.getCredentials = function() {
			credentialManagerService.getCredentialsMultiRecTypes($scope.model.accountType).then(function(credentials) {
				$scope.fillCredentials(credentials);
			});
		};

		$scope.model.getCredentials();

		//take input for account type
		$scope.openCreateCredentialModal = () => {
			credentialManagerFactory
				.openCreateNewUser({
					cancelReloadApp: true,
					AccountTypeId: $scope.model.accountType[0] ? $scope.model.accountType[0] : 0,
					showInputs: true,
					accountTypes: $scope.model.createAccountType
				})
				.result.then(
					function() {},
					data => {
						if (data && data.msg === 'createSucessful') {
							credentialManagerService
								.getCredentialsMultiRecTypes($scope.model.accountType)
								.then(function(credentials) {
									$scope.model.selectedCredentialName = data.name;
									$scope.fillCredentials(credentials);
								});
						}
					}
				);
		};

		$scope.fillCredentials = credentials => {
			if (credentials.data && Array.isArray(credentials.data)) {
				$scope.savedCredentials = [];
				//preselect credential if present
				var defaultSelected = false;
				for (var i = 0; i < credentials.data.length; i++) {
					let credential = credentials.data[i];
					if (
						$scope.model.selectedCredentialName &&
						$scope.model.selectedCredentialName === credential.credentialRecord.credentialName
					) {
						credential.credentialRecord.selected = true;
						defaultSelected = true;
					}
					$scope.savedCredentials.push(credential.credentialRecord);

					//this is for parent modal to get record type of selected credential
					if ($scope.model.credentialRecordType) {
						$scope.model.credentialRecordType[credential.credentialRecord.credentialName] = credential.recordType;
					}
				}

				if (!defaultSelected && $scope.savedCredentials.length > 0) {
					$scope.savedCredentials[0].selected = true;
				}
			}
		};

		$scope.changeCredType = () => {
			if ($scope.model.credType == 'user') {
				//reset credentials
				$scope.model.selectedCredential = [];
			}
		};
	}
];

credMod.controller(controllers);

export default credMod;
