import { acAppcredentialManagerModule } from 'common/js/modules';
import 'credentialManager/js/services/credentialManager.svc.js';
import 'credentialManager/js/constants/credentialManager.constant.js';
import 'adminConsole/js/services/security.svc.js';
import 'credentialManager/js/factory/credentialManager.factory.js';
import * as credentialManagerTemplate from 'credentialManager/js/credentialManager.template.js';
export class CredentialManangerListController {
	constructor(
		ENTITY_TYPES,
		cvPermissionFactory,
		$compile,
		$scope,
		credentialManagerService,
		cvLoc,
		$modal,
		cvUtil,
		cvToaster,
		$dialogs,
		$log,
		$state,
		$q,
		cvBreadcrumbsTabsFactory,
		credentialManagerFactory
	) {
		this.$scope = $scope;
		this.cvPermissionFactory = cvPermissionFactory;
		this.$compile = $compile;
		this.credentialManagerService = credentialManagerService;
		this.cvLoc = cvLoc;
		this.$modal = $modal;
		this.cvUtil = cvUtil;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.cvToaster = cvToaster;
		this.$dialogs = $dialogs;
		this.$log = $log;
		this.$state = $state;
		this.$q = $q;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.credentialManagerFactory = credentialManagerFactory;
		this.initializeBreadCrumbs();
		this._setupGridOptions();
		var self = this;
	}
	initializeBreadCrumbs() {
		let breadCrumbs = [];
		breadCrumbs.push({
			title: this.cvLoc('label.nav.security'),
			link: '#nav/musers'
		});

		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
	_initColumns() {
		return credentialManagerTemplate.getColumnTemplate({
			cvLoc: this.cvLoc
		});
	}
	_fetchData(data) {
		let self = this;
		self.$scope.credentialManagerList = [];
		self.loading = true;
		self.serverMessage = self.cvUtil.infoMsgLoc('Loading...');
		let cvLoc = self.cvLoc;
		let _computePermittedActionsForRole = function(entity) {
			let arrayOfActionsToOverrideRole = [
				{
					DELETE: {
						permissionIds: [],
						show: true,
						label: cvLoc('action.delete'),
						onClick: self.deleteUser.bind(self),
						groupId: 1
					}
				}
			];
			return self.cvPermissionFactory.updateAndGetCommonActionsList(
				arrayOfActionsToOverrideRole,
				false,
				self.cvPermissionFactory.commonPermittedList
			);
		};
		self.$q
			.all([self.credentialManagerService.getCredentialRecord(), self.credentialManagerService.getCredentialType()])
			.then(
				results => {
					if (results[0]) {
						self.$scope.credentialManagerList = results[0].data;
						self.$scope.isCredentialRecordsLoaded = true;
					}
					if (results[1]) {
						self.$scope.recordTypeList = results[1].data;
					}

					if (results) {
						self.$scope.credentialList = [];
						self.$scope.credentialManagerList.forEach(element => {
							element.recordTypeFormatted = self.getRecordType(element.recordType);
							self.$scope.credentialList.push(element);
							element.permittedOptions = {
								entityType: 'CREDENTIAL_ENTITY',
								entity: angular.copy(element),
								entityId: element.credentialRecord.credentialId,
								entityName: element.credentialRecord.credentialName,
								commcellEntity: {
									commcellName: element.credentialRecord._commcellName_
								},
								appendToBody: true,
								permittedActionList: _computePermittedActionsForRole(element)
							};
							self.permittedOptions = element.permittedOptions;
						});
						data.success(self.$scope.credentialList);
					}
					self.loading = false;
					self.serverMessage = self.cvUtil.emptyMsg();
				},
				error => {
					self.loading = false;
					self.serverMessage = {
						type: 'error',
						message: error
					};
				}
			);
	}
	_setupGridOptions() {
		let self = this;
		this.kendoGridOptions = {};
		this.$scope.kendoGridOptions = this.kendoGridOptions;
		this.kendoGridOptions.gridTitle = this.cvLoc('label.nav.credentialManager');
		this.kendoGridOptions.tableName = 'credentialManagerTable';
		this.kendoGridOptions.url = this._fetchData.bind(this);
		this.kendoGridOptions.usePageToolbar = true;
		this.kendoGridOptions.showCompanyColumnAndFilter = true;
		this.kendoGridOptions.entityInfoPath = 'credentialRecord.entityInfo';
		this.kendoGridOptions.columns = this._initColumns();
		this.kendoGridOptions.onGridDataBound = this._onGridDataBound.bind(this);
		this.kendoGridOptions.gridToolbarMenu = [
			{
				id: 'Add',
				disableOnDeselect: false,
				label: this.cvLoc('label.add'),
				onSelect: event => {
					this.credentialManagerFactory.openCreateNewUser({
						cancelReloadApp: false,
						AccountTypeId: null,
						showInputs: true,
						accountTypes: null
					});
				},
				contextMenuOnly: true
			}
		];
		this.kendoGridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
	}
	_onGridDataBound(dataItem, row) {
		let self = this;
		const permittedOptions = dataItem.permittedOptions;
		const id = permittedOptions.entityId;
		const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${id}`] = permittedOptions;
		row.find('.permittedActions').append(this.$compile(template)(this.$scope));
		const detailLink = row.find('.k-grid-keyDetail');
		detailLink.click(() => {
			self.editCredentialWrapper(dataItem);
		});
	}
	deleteUser(value, entity, entityType, actionObject, entityId, entityName) {
		let self = this;
		let credentialEntity = entity;
		if (credentialEntity.credentialRecord.credentialId <= 0) {
			return;
		}
		var successCallBack = () => {
			self.$state.forceReload();
		};
		var callBackFunctions = {
			noFunction: () => {},
			yesFunction: () => {
				self.credentialManagerService
					.deleteCredentialRecord({
						credentialRecordInfo: angular.toJson(credentialEntity)
					})
					.success(successCallBack)
					.error(errorMessage => {
						errorMessage = errorMessage !== null ? errorMessage : self.cvLoc('generic_error');
						self.$log.error(errorMessage);
						self.cvToaster.showErrorMessage({
							ttl: '10000',
							message: errorMessage
						});
					});
			}
		};

		this.$dialogs.confirm(
			'Delete Credential',
			this.cvLoc('label.confirmDeleteClientGroup', '<b>' + credentialEntity.credentialRecord.credentialName + '</b>'),
			callBackFunctions
		);
	}
	getRecordType(recordType) {
		let str = _.get(
			_.find(this.$scope.recordTypeList, {
				value: recordType
			}),
			'label',
			recordType
		);
		if (recordType === 'AMAZON_S3' || recordType === 'AMAZON_STS_IAM_ROLE') {
			str = this.cvLoc('label.AmazonDetailStr', str);
		} else if (recordType === 'AZUREACCOUNT' || recordType === 'MICROSOFT_AZURE') {
			str = this.cvLoc('label.AzureDetailStr', str);
		}
		return str;
	}

	editCredentialWrapper = function(credentialEntity) {
		let self = this;
		let credEntity = {
			credentialId: credentialEntity.credentialRecord.credentialId,
			credentialName: credentialEntity.credentialRecord.credentialName
		};
		self.credentialManagerFactory.openEditCredential({ credentialEntity: credEntity, fromCredListPage: true });
	};
}
CredentialManangerListController.$inject = [
	'ENTITY_TYPES',
	'cvPermissionFactory',
	'$compile',
	'$scope',
	'credentialManagerService',
	'cvLoc',
	'$uibModal',
	'cvUtil',
	'cvToaster',
	'$dialogs',
	'$log',
	'$state',
	'$q',
	'cvBreadcrumbsTabsFactory',
	'credentialManagerFactory'
];
acAppcredentialManagerModule.controller('credentialManagerListController', CredentialManangerListController);
export default acAppcredentialManagerModule;
